<?php /*** The loop that displays posts.***/ 

//$get_meta = get_post_custom($post->ID);
$day = get_the_time('d'); $month = get_the_time('M'); $year = get_the_time('Y');
$showrmtext = weblusive_get_option('blog_show_rmtext');

?>

<?php if ( ! have_posts() ) : ?>
	<div id="post-0" class="blog-post post error404 not-found col-md-12">
		<h1 class="entry-title"><?php esc_html_e('Not Found', 'express' ); ?></h1>
		<div class="entry-content">
			<p><?php esc_html_e('Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'express' ); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php else: ?>

<?php  while ( have_posts() ) : the_post(); ?>
	<?php $get_meta = get_post_custom($post->ID);		
	$mediatype = isset($get_meta["_blog_mediatype"]) ? $get_meta["_blog_mediatype"][0] : 'image';
	$videoId = isset($get_meta["_blog_video"]) ? $get_meta["_blog_video"][0] : ''; 
	$autoplay =  isset($get_meta["_blog_videoap"]) ? $get_meta["_blog_videoap"][0] : '0';
	$thumbnail = '';
	$thumbsize="express-blog-list-1";
	$post_size = isset($get_meta["_weblusive_post_size"]) ? $get_meta["_weblusive_post_size"][0] : ''; 
	$post_img = isset($get_meta["_weblusive_post_img_pos"]) ? $get_meta["_weblusive_post_img_pos"][0] : ''; 
	$videoId = isset($get_meta["_blog_video"]) ? $get_meta["_blog_video"][0] : ''; 
	
	$showcomments = weblusive_get_option('blog_show_comments');
	
	if ( has_post_thumbnail()) {
		$thumbnail = get_the_post_thumbnail($post->ID, 'blog-default');
		//if (empty($thumbnail)) $thumbnail = '<img src="http://placehold.it/310x223.png" alt="" />';
	}
	else {
		$thumbnail =  '';
	}
	?>
<!-- ************* POST FORMAT IMAGE ************** -->
<?php if ( ( function_exists( 'get_post_format' ) && 'image' == get_post_format( $post->ID ) )  ) : ?> 
	<article <?php post_class("single_blog_post  image"); ?> id="post-<?php the_ID(); ?>">
		<div class="entry-cover">
			<?php if($thumbnail) :?>
			<a href="<?php the_permalink()?>">
				<?php echo $thumbnail; ?>
			</a>
			<?php endif;?>
			<div class="post-meta"><i class="icon_camera_alt"></i></div>
		</div>
		<div class="enetry-header">
			<div class="entry-title">
				<h3><a href="<?php the_permalink()?>"><?php the_title()?></a></h3>
				<?php $meta = express_meta($post); echo $meta ?>
			</div>
		</div>
		<div class="entry-content">			
			<p><?php echo do_shortcode(get_the_excerpt()); ?></p>
		</div>
		<?php if(!$showrmtext) :?>
			<a href="<?php the_permalink()?>" class="readMore"><?php echo  esc_html_e('Read More', 'express');?></a>
		<?php endif;?>
	</article>
<!-- ************* POST FORMAT LINK ************** -->
<?php elseif( ( function_exists( 'get_post_format' ) && 'link' == get_post_format( $post->ID ) )  ) : ?> 
	<article <?php post_class("single_blog_post  link"); ?> id="post-<?php the_ID(); ?>">
		<?php $link = isset($get_meta["_blog_link"]) ? $get_meta["_blog_link"][0] : ''; ?>
		<div class="entry-cover">
			<div class="post-meta"><i class="icon_link_alt"></i></div>
		</div>
		<div class="enetry-header">
			<div class="entry-title">
				<h3><a href="<?php echo $link ?>"><?php the_title()?></a></h3>
				<?php $meta = express_meta($post); echo $meta ?>
			</div>
		</div>
		<div class="entry-content">			
			<p><?php echo do_shortcode(get_the_excerpt()); ?></p>
		</div>
	</article>
<!-- ************* POST FORMAT AUDIO ************** -->
<?php elseif( ( function_exists( 'get_post_format' ) && 'audio' == get_post_format( $post->ID ) )  ) : ?> 
	<article <?php post_class("single_blog_post  audio"); ?> id="post-<?php the_ID(); ?>">
		<div class="entry-cover">
			<div class="audio-container">
				<?php $audio = isset($get_meta["_blog_audio"]) ? $get_meta["_blog_audio"][0] : ''; ?>
				<?php if ($audio):?>
					<?php echo do_shortcode($audio); ?>
				<?php else:?>
					<div class="alert alert-danger fade in">
						<?php esc_html_e('Audio post format was chosen but no embed code provided. Please fix this by providing it.', 'express') ?>
					</div>
				<?php endif?>
			</div>
			<div class="post-meta"><i class="icon_music"></i></div>
		</div>
		<div class="enetry-header">
			<div class="entry-title">
				<h3><a href="<?php the_permalink()?>"><?php the_title()?></a></h3>
				<?php $meta = express_meta($post); echo $meta ?>
			</div>
		</div>
		<div class="entry-content">			
			<p><?php echo do_shortcode(get_the_excerpt()); ?></p>
		</div>
		<?php if(!$showrmtext) :?>
			<a href="<?php the_permalink()?>" class="readMore"><?php echo  esc_html_e('Read More', 'express');?></a>
		<?php endif;?>
	</article>
<!-- ************* POST FORMAT STATUS ************** -->
<?php elseif( ( function_exists( 'get_post_format' ) && 'status' == get_post_format( $post->ID ) )  ) : ?>
	<article <?php post_class("single_blog_post  status"); ?> id="post-<?php the_ID(); ?>">
		<div class="entry-cover">
			<div class="post-meta"><i class="icon_comment_alt"></i></div>
		</div>
		<div class="enetry-header">
			<div class="entry-title">
				<h3><a href="<?php the_permalink()?>"><?php the_title()?></a></h3>
				<?php $meta = express_meta($post); echo $meta ?>
			</div>
		</div>
		<div class="entry-content">
			<?php $status = isset($get_meta["_blog_status"]) ? $get_meta["_blog_status"][0] : ''; ?>
			<?php if ($status):?>
			<p class="status lead"><?php echo $status; ?></p>
			<?php else:?>
				<div class="alert alert-danger fade in">
					<?php esc_html_e('Status post format was chosen but no status text provided. Please fix this by providing it.', 'express') ?>
				</div>
			<?php endif?>
		</div>
		<?php if(!$showrmtext) :?>
			<a href="<?php the_permalink()?>" class="readMore"><?php echo  esc_html_e('Read More', 'express');?></a>
		<?php endif;?>
	</article>
<!-- ************* POST FORMAT QUOTE ************** -->
<?php elseif( ( function_exists( 'get_post_format' ) && 'quote' == get_post_format( $post->ID ) )  ) : ?> 
	<article <?php post_class("single_blog_post  quote"); ?> id="post-<?php the_ID(); ?>">
		<div class="entry-cover">
			<div class="post-meta"><i class="icon_quotations"></i></div>
		</div>
		<div class="enetry-header">
			<div class="entry-title">
				<h3><a href="<?php the_permalink()?>"><?php the_title()?></a></h3>
				<?php $meta = express_meta($post); echo $meta ?>
			</div>
		</div>
		<div class="entry-content">
			<?php $quote = isset($get_meta["_blog_quote"]) ? $get_meta["_blog_quote"][0] : ''; ?>
			<?php if ($quote):?>
			<blockquote><?php echo htmlspecialchars_decode(do_shortcode($quote)); ?></p></blockquote>
			<?php else:?>
				<div class="alert alert-danger fade in">
					<?php esc_html_e('Quote post format was chosen but no url or embed code provided. Please fix this by providing it.', 'express') ?>
				</div>
			<?php endif?>
		</div>
		<?php if(!$showrmtext) :?>
			<a href="<?php the_permalink()?>" class="readMore"><?php echo  esc_html_e('Read More', 'express');?></a>
		<?php endif;?>
	</article>
<!-- ************* POST FORMAT VIDEO ************** -->
<?php elseif( ( function_exists( 'get_post_format' ) && 'video' == get_post_format( $post->ID ) )  ) : ?>
	<article <?php post_class("single_blog_post  video"); ?> id="post-<?php the_ID(); ?>">
		<div class="entry-cover">
			<?php
				global $wp_embed;
				$post_embed = '';
				$video = isset($get_meta["_blog_video"]) ? $get_meta["_blog_video"][0] : ''; 
				$videoself = isset($get_meta["_blog_video_selfhosted"]) ? $get_meta["_blog_video_selfhosted"][0] : ''; 
				?>
			<?php if($video || $videoself) : ?>
				<div class="flex-video">
					<?php
						if ($video):
							$videoSize='width="750" height="366"';
							$post_embed = $wp_embed->run_shortcode('[embed '.$videoSize.']'.$video.'[/embed]'); 
						else:
							$post_embed = $wp_embed->run_shortcode($videoself);
						endif;
						echo $post_embed; 
					?>
				</div>	
			<?php else:?>
				<div class="alert alert-danger fade in">
					<?php esc_html_e('Video post format was chosen but no url or embed code provided. Please fix this by providing it.', 'express') ?>
				</div>
			<?php endif?>
			<div class="post-meta"><i class="icon_film"></i></div>
		</div>
		<div class="enetry-header">
			<div class="entry-title">
				<h3><a href="<?php the_permalink()?>"><?php the_title()?></a></h3>
				<?php $meta = express_meta($post); echo $meta ?>
			</div>
		</div>
		<div class="entry-content">			
			<p><?php echo do_shortcode(get_the_excerpt()); ?></p>
		</div>
		<?php if(!$showrmtext) :?>
			<a href="<?php the_permalink()?>" class="readMore"><?php echo  esc_html_e('Read More', 'express');?></a>
		<?php endif;?>
	</article>
<!-- ************* POST FORMAT GALLERY ************** -->
<?php elseif( ( function_exists( 'get_post_format' ) && 'gallery' == get_post_format( $post->ID ) )  ) : ?> 
	<article <?php post_class("single_blog_post gallery"); ?> id="post-<?php the_ID(); ?>">
		<div class="entry-cover">
			<div class="flexpost flexslider">
				<ul class="slides">
					<?php 
					$argsThumb = array(
						'order'          => 'ASC',
						'post_type'      => 'attachment',
						'post_parent'    => $post->ID,
						'post_mime_type' => 'image',
						'post_status'    => null,
						//'exclude' => get_post_thumbnail_id()
					);
					$attachments = get_posts($argsThumb);
					if ($attachments) {
						foreach ($attachments as $attachment) {
							echo '<li><img src="'.wp_get_attachment_url($attachment->ID, 'full', false, false).'" class="img-responsive blog-post-img" alt="'.get_post_meta($attachment->ID, '_wp_attachment_image_alt', true).'" /></li>';
						}
					}?>
				</ul>
			</div>
			<div class="post-meta"><i class="icon_images"></i></div>
		</div>
		<div class="enetry-header">
			<div class="entry-title">
				<h3><a href="<?php the_permalink()?>"><?php the_title()?></a></h3>
				<?php $meta = express_meta($post); echo $meta ?>
			</div>
		</div>
		<div class="entry-content">			
			<p><?php echo do_shortcode(get_the_excerpt()); ?></p>
		</div>
		<?php if(!$showrmtext) :?>
			<a href="<?php the_permalink()?>" class="readMore"><?php echo  esc_html_e('Read More', 'express');?></a>
		<?php endif;?>
	</article>
<!-- ************* POST FORMAT STANDARD ************** -->
<?php else : ?> 
	<article <?php post_class("single_blog_post standard"); ?> id="post-<?php the_ID(); ?>">
		<div class="entry-cover">
			<?php if($thumbnail) :?>
			<a href="<?php the_permalink()?>">
				<?php echo $thumbnail; ?>
			</a>
			<?php endif;?>
			<div class="post-meta"><i class="icon_document_alt"></i></div>
		</div>
		<div class="enetry-header">
			<div class="entry-title">
				<h3><a href="<?php the_permalink()?>"><?php the_title()?></a></h3>
				<?php $meta = express_meta($post); echo $meta ?>
			</div>
		</div>
		<div class="entry-content">			
			<p><?php echo do_shortcode(get_the_excerpt()); ?></p>
		</div>
		<?php if(!$showrmtext) :?>
			<a href="<?php the_permalink()?>" class="readMore"><?php echo  esc_html_e('Read More', 'express');?></a>
		<?php endif;?>
	</article>
	
<?php endif?>
	<?php  endwhile;?>
<?php endif; ?>