/*
	Project Name : NSure

	- Contact Map
	
	## Document Scroll
	
	## Document Ready
		- Scrolling Navigation
		- Responsive Caret
		- Remove p empty tag for Shortcode
		- Services
		- Offer
		- Why We Are Section
		- Blog Section
		- Testimonials
		- Partners Section
		- Fun Fact - Number
		- Core Values
		- Portfolio
		- Lightbox for Portfolio Images
		- Faq Section
		- Coming Soon
		- Contact Map
		- Contact Form

	## Window Load
		- Site Loader
*/

(function($) {

	"use strict"
	jQuery(document).ready(function($){
		
		 /*----------------ADDED-------------------*/

                /*post format gallery*/
                $('.flexpost').flexslider({
                animation: "fade",
                slideshow: true,
                directionNav: true,
                slideshowSpeed: 3000,
                animationSpeed: 700,
                controlNav: false,
                });
                
                
            
            /* ----------------------------------------------------------- */
            /*  Back to top
            /* ----------------------------------------------------------- */
                $(window).scroll(function () {
                    if ($(this).scrollTop() > 50) {
                        $('#back-to-top').fadeIn();
                    } else {
                        $('#back-to-top').fadeOut();
                    }
                });
                // scroll body to 0px on click
                $('#back-to-top').click(function () {
                    $('#back-to-top').tooltip('hide');
                    $('body,html').animate({
                        scrollTop: 0
                    }, 800);
                    return false;
                });

                $('#back-to-top').tooltip('hide');
                
				/*-------------------------------------------------*/
                /*  category and archive icons
                /*-------------------------------------------------*/ 
                $('.widget_categories ul li , .widget_archive ul li , .widget_meta ul li ').prepend('<i class="fa fa-angle-right"></i>');

				/*---------------Animation---------------------*/
					$('.animation').waypoint(function(direction) {
				$(this).addClass('animation-active');
				}, {offset: '100%', triggerOnce: true });
				
				/*-------------------------------------------------*/
                /* = Sticky Menu
                /*-------------------------------------------------*/
                $(document).scroll(function () {
                        var y = $(document).scrollTop(),
                                header = $(".fixed-top ");

                        if (y >= 48) {
                                header.addClass('fixed animation fadeInDown animation-active').delay( 2000 ).fadeIn();;
                        } else {
                                header.removeClass('fixed animation fadeInDown animation-active');
                        }
                });
	
	/* ## Document Ready - Handler for .ready() called */
	$(document).ready(function($) {

		/* local url of page (minus any hash, but including any potential query string) */
		var url = location.href.replace(/#.*/,'');

		/* - Find all anchors */
		$('#navbar').find('a[href]').each(function(i,a) {

			var $a = $(a);
			var href = $a.attr('href');

			/* check is anchor href starts with page's URI */
			if ( href.indexOf(url+'#') == 0 ) {

				/* remove URI from href */
				href = href.replace(url,'');

				/* update anchors HREF with new one */
				$a.attr('href',href);
			}
		});

		/* Add Easing Effect on Section Scroll */
		$('.navbar-nav li a[href*=#]:not([href=#]), .site-logo a[href*=#]:not([href=#])').on('click', function() {

			if ( location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname ) {
				var target = $(this.hash);
				target = target.length ? target : $('[name=' + this.hash.slice(1) +']');

				if (target.length) {
					$('html, body').animate( { scrollTop: target.offset().top - 83 }, 1000, 'easeInOutExpo' );
					return false;
				}
			}
		});

		/* - Responsive Caret */
		$('.ddl-switch').on('click', function() {

			var li = $(this).parent();

			if ( li.hasClass('ddl-active') || li.find('.ddl-active').length !== 0 || li.find('.dropdown-menu').is(':visible') ) {
				li.removeClass('ddl-active');
				li.children().find('.ddl-active').removeClass('ddl-active');
				li.children('.dropdown-menu').slideUp();	
			}
			else {
				li.addClass('ddl-active');
				li.children('.dropdown-menu').slideDown();
			}
		});
		
		/* - Remove p empty tag for Shortcode */
		$( 'p' ).each(function() {
			var $this = $( this );
				if( $this.html().replace(/\s|&nbsp;/g, '').length == 0) {
				$this.remove();
			}
		});

		/* - Portfolio */
		if( $(".portfolio-section").length ){	
			setTimeout(function() {
				var $container = $("#portfolio");
				$container.isotope({
				  itemSelector: ".grid-item",
				  gutter:0,
				  transitionDuration: "0.5s"
				});
				
				$("#filters.non-paginated li a").on("click",function(){
					$('#filters li a').removeClass('active');
					$(this).addClass('active');
					var selector = $(this).attr('data-filter');
					$('#portfolio').isotope({ filter: selector });		
					return false;
				});	
			},2000);
		}
		
		/* - Lightbox for Portfolio Images */
		if( $(".portfolio-section").length ){
			$(".portfolio-box a.port-icon.img").magnificPopup({
				type: "image",
				tLoading: "Loading image #%curr%...",
				mainClass: "mfp-img-mobile",
				gallery: {
					enabled: true,
					navigateByImgClick: false,
					preload: [0,1] // Will preload 0 - before current, and 1 after the current image
				},
				image: {
					tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',				
				}
			});
                        $(".portfolio-box a.port-icon.vid").magnificPopup({
				type: "iframe",
				tLoading: "Loading video #%curr%...",
				mainClass: "mfp-img-mobile",
				gallery: {
					enabled: true,
					navigateByImgClick: false,
					preload: [0,1] // Will preload 0 - before current, and 1 after the current image
				},
				image: {
					tError: '<a href="%url%">The video #%curr%</a> could not be loaded.',				
				}
			});
		}
		
		/* - Faq Section */
		$(".faq-list li a").on("click",function() {
			var href = $(this).attr('href').split('-');
			$( "[id*='faq-']" ).removeClass("active");
			$( "[id='faq-"+href[1]+"']" ).addClass("active");
			$(".faq-list li a").removeClass('active');
			$(this).addClass("active");
		});
		
		$(".faq-list li a,.faq-content > a").on("click",function() {
			if ( location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname ) {
				var target = $(this.hash);
				target = target.length ? target : $('[name=' + this.hash.slice(1) +']');
				if (target.length) {
					$('html, body').animate( { scrollTop: target.offset().top - 120 }, 1000, 'easeInOutExpo' );
					return false;
				}
			}
		});
		
		/* - Coming Soon 
		var austDay = new Date();
		austDay = new Date(austDay.getFullYear() + 1, 2 - 1, 14);
		$('#defaultCountdown').countdown({until: austDay});
		$('#year').text(austDay.getFullYear());
		
	
		/* Quick Contact Form /- */
		document.addEventListener('DOMContentLoaded', function () {
			document.querySelector('main').className += 'loaded';
		});
		
	});			

	/* ## Window Load - Handler for .load() called */
	$(window).load(function() {

		/* - Site Loader */
		if ( !$('html').is('.ie6, .ie7, .ie8') ) {
			$("#site-loader").delay(1000).fadeOut("slow");
		}
		else {
			$("#site-loader").css('display','none');
		}
	});
    });

})(jQuery);
/* ---------------------------------------------------
	Quick contact form widget
-------------------------------------------------- */

function checkemail(emailaddress){
	"use strict";
	var pattern = new RegExp(/^(("[\w-\s]+")|([\w-]+(?:\.[\w-]+)*)|("[\w-\s]+")([\w-]+(?:\.[\w-]+)*))(@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][0-9]\.|1[0-9]{2}\.|[0-9]{1,2}\.))((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\.){2}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\]?$)/i); 
	return pattern.test(emailaddress); 
}

jQuery(document).ready(function(){ 
	jQuery('.empty-widget-title').parent().parent('h4').css('display', 'none');
	jQuery('.empty-widget-title').parent('.footer-widget-title').css('display', 'none');
	jQuery('.sidebar-widget ul.drop-menu').removeClass('drop-menu').css('display', 'block');
	"use strict";
	jQuery('#registerErrors, .widgetinfo').hide();		
	var $messageshort = false;
	var $emailerror = false;
	var $nameshort = false;
	var $namelong = false;
	
	jQuery('#contactFormWidget input#wformsend').click(function(){ 
		var $name = jQuery('#wname').val();
		var $email = jQuery('#wemail').val();
		var $message = jQuery('#wmessage').val();
		var $contactemail = jQuery('#wcontactemail').val();
		var $contacturl = jQuery('#wcontacturl').val();
		var $subject = jQuery('#wsubject').val();
	
		if ($name !== '' && $name.length < 3){ $nameshort = true; } else { $nameshort = false; }
		if ($name !== '' && $name.length > 30){ $namelong = true; } else { $namelong = false; }
		if ($email !== '' && checkemail($email)){ $emailerror = true; } else { $emailerror = false; }
		if ($message !== '' && $message !== 'Message' && $message.length < 3){ $messageshort = true; } else { $messageshort = false; }
		
		jQuery('#contactFormWidget .loading').animate({opacity: 1}, 250);
		
		if ($name !== '' && $nameshort !== true && $namelong !== true && $email !== '' && $emailerror !== false && $message !== '' && $messageshort !== true && $contactemail !== ''){ 
			jQuery.post($contacturl, 
				{type: 'widget', contactemail: $contactemail, subject: $subject, name: $name, email: $email, message: $message}, 
				function(/*data*/){
					jQuery('#contactFormWidget .loading').animate({opacity: 0}, 250);
					jQuery('.form').fadeOut();
					jQuery('#bottom #wname, #bottom #wemail, #bottom #wmessage').css({'border':'0'});
					jQuery('.widgeterror').hide();
					jQuery('.widgetinfo').fadeIn('slow');
					jQuery('.widgetinfo').delay(2000).fadeOut(1000, function(){ 
						jQuery('#wname, #wemail, #wmessage').val('');
						jQuery('.form').fadeIn('slow');
					});
				}
			);
			
			return false;
		} else {
			jQuery('#contactFormWidget .loading').animate({opacity: 0}, 250);
			jQuery('.widgeterror').hide();
			jQuery('.widgeterror').fadeIn('fast');
			jQuery('.widgeterror').delay(3000).fadeOut(1000);
			
			if ($name === '' || $name === 'Name' || $nameshort === true || $namelong === true){ 
				jQuery('#wname').css({'border-left':'4px solid #red'}); 
			} else { 
				jQuery('#wname').css({'border-left':'4px solid #929DAC'}); 
			}
			
			if ($email === '' || $email === 'Email' || $emailerror === false){ 
				jQuery('#wemail').css({'border-left':'4px solid red'});
			} else { 
				jQuery('#wemail').css({'border-left':'4px solid #929DAC'}); 
			}
			
			if ($message === '' || $message === 'Message' || $messageshort === true){ 
				jQuery('#wmessage').css({'border-left':'4px solid red'}); 
			} else { 
				jQuery('#wmessage').css({'border-left':'4px solid #929DAC'}); 
			}
			
			return false;
		}
	});
});