<!DOCTYPE html>
<!--[if IE 8]> 	<html class="no-js lt-ie9" lang="en"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->

<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    
	<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>
	<!--[if lt IE 9]>
		<script src="<?php echo get_template_directory_uri() ?>/js/html5.js"></script>
	<![endif]-->
	<!--[if IE]>
		<link rel="stylesheet" href="<?php echo get_template_directory_uri() ?>/css/media.css" type="text/css" media="screen" />
	<![endif]-->
	<?php if(weblusive_get_option('header_code')) echo  htmlspecialchars_decode(weblusive_get_option('header_code')); ?>
	
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> data-offset="200" data-spy="scroll" data-target=".ow-navigation">
	<?php $nopreloader = weblusive_get_option('disable_preloader'); if(!$nopreloader):?>
	<div id="site-loader" class="load-complete">
		<div class="loader">
			<div class="loader-inner ball-clip-rotate">
				<div></div>
			</div>
		</div>
	</div>
	<?php endif?>
	<?php if (!is_page_template('under-construction.php')):?>
		<a id="top"></a>
		<header class="header-main">
			<?php 
			$topbar_enable =  weblusive_get_option('topbar_enable');
			if ($topbar_enable): $topsidebar = weblusive_get_option('topbar_sidebar_enable'); ?>
			<!-- Header Top Container -->
			<div class="top-header">
				<div class="container">
					<div class="row">
						<?php
						$ltopsidebar = weblusive_get_option('topbar_lsidebar_enable');
						$rtopsidebar = weblusive_get_option('topbar_rsidebar_enable');
						?>
						<div class="col-md-8">
							<?php if ($ltopsidebar): ?>
								<?php dynamic_sidebar('Left Topbar sidebar'); ?>
							<?php endif ?>
						</div>
						<div class="col-md-4 pull-right">
							<?php if ($rtopsidebar): ?>
								<?php dynamic_sidebar('Right Topbar sidebar'); ?>
							<?php endif ?>
						</div>
					</div>
				</div> <!-- end .container -->
			</div>
			<?php endif ?>			
			<?php $disSticky=weblusive_get_option('sticky_menu');?>
			<div class="menu-block <?php if ($disSticky) : ?>fixed-top<?php endif; ?>">
				<div class="container">
					<div class="row">
						<nav class="navbar ow-navigation ">
							<div class="navbar-header">
								<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
									<span class="sr-only"><?php _e('Toggle navigation', 'express')?></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
								</button>
								<?php 
									$logo = weblusive_get_option('logo'); 
									$logosettings =  weblusive_get_option('logo_setting');
								?>
								<a href="<?php echo esc_url(home_url('/')) ?>" class="navbar-brand">
									<?php $logo_size = ''; if($logosettings == 'logo' && !empty($logo)):
										if(function_exists('getimagesize')){
											$sizes = getimagesize($logo);
											$logo_size = $sizes[3];
										}
									?>
										<img src="<?php echo esc_url($logo) ?>" alt="<?php echo get_bloginfo('name')?>"  id="logo-image" <?php echo $logo_size?> />
									<?php else:?>
										<?php echo get_bloginfo('name') ?>
									<?php endif?>
								</a>
							</div>
							<div id="navbar" class="navbar-collapse collapse no-padding">
								
								<?php
								$walker = new express_Menu_Walker;
								if (has_nav_menu('primary_nav')):
									$menu = wp_nav_menu(
										array(
											'theme_location' => 'primary_nav',
											'menu' => 'primary_nav',
											'container' => '',
											'depth' => 4,
											'menu_class' => 'nav navbar-nav',
											'walker' => $walker,
											'echo' => false
										)
									);
									echo ($menu);
								else:
								?>
								<?php endif; ?>
								<?php
								$enq_button=weblusive_get_option('enq_button');
								$enqlink=weblusive_get_option('enqlink');
								$enqcaption=weblusive_get_option('enqcaption');
								?>
								<?php if($enq_button):?>
									<a href="<?php echo esc_url($enqlink);?>" class="btn"><?php echo esc_attr($enqcaption);?></a>
								<?php endif;?>
							</div>
						</nav>
					</div>
				</div>
			</div>
		</header>
	<?php endif;?>