<?php
if(!class_exists('OP_Receipt'))
{
    class OP_Receipt{
        public $_post_type = '_op_receipt';
        
       
        public function __construct()
        {
           
            $this->init();
        }
        function init(){
            // create openpos data directory
            add_action( 'wp_ajax_openpos_update_receipt_template', array($this,'update_receipt_template') );
            add_action( 'wp_ajax_openpos_delete_receipt', array($this,'delete_receipt') );
            add_action( 'wp_ajax_openpos_update_receipt_content', array($this,'update_receipt_content') );
            add_action( 'wp_ajax_openpos_update_receipt_draft', array($this,'update_receipt_draft') );
            add_action( 'wp_ajax_openpos_update_receipt_preview', array($this,'receipt_preiew') );
            add_action( 'op_register_form_end', array($this,'op_register_form_end'),10,1 );
            add_action( 'op_register_save_after', array($this,'op_register_save_after'),10,3 );
           

            add_filter('op_get_login_cashdrawer_data',array($this,'op_setting_data'),10,1);
            

            
           
        }
        public function receipt_types(){
            return array(
                'receipt' => __('Receipt','openpos'),
                'zreport' => __('X-Report','openpos'),
                'kitchen_receipt' => __('Kitchen Receipt','openpos'),
            );
        }
        public function templates($status = ''){
            $result = array();

            if(!$status)
            {
                $statues = array('publish','draft');
            }else{
                $statues = array($status);
            }

            $posts = get_posts([
                'post_type' => $this->_post_type,
                'post_status' => $statues,
                'numberposts' => -1
            ]);
            foreach($posts as $p)
            {
                $result[] = $this->get($p->ID);
            }
            return $result;
        }
        public function delete($id){
            $post = get_post($id);
            if($post->post_type == $this->_post_type)
            {
                wp_trash_post( $id  );
                return true;
            }
            return false;
        }
        public function save($params){

            $id  = 0;
            if(isset($params['id']) && $params['id'] > 0)
            {
                $id = $params['id'];
            }
            
            $args = array(
                'ID' => $id,
                'post_title' => $params['name'],
                'post_type' => $this->_post_type,
                'post_status' => $params['status'],
                'post_parent' => 0
            );
            if($id)
            {
                $post_id = wp_update_post($args);
            }else{
                $post_id = wp_insert_post($args);
            }
            
            $type = isset($params['type']) ? $params['type'] : 'receipt';
            
            if(!is_wp_error($post_id)){
                update_post_meta($post_id,'template_type',$type);
                return $post_id;
            }else{
                //there was an error in the post insertion,
                throw new Exception($post_id->get_error_message()) ;
            }
        }
        public function get($id)
        {
            global $OPENPOS_CORE;
            $post = get_post($id);
            if(!$post)
            {
                return array();
            }
            if($post->post_type != $this->_post_type)
            {
                return array();
            }
            $name = $post->post_title;
            $created_by = get_the_author_meta('display_name',$post->post_author);

          
            $created_at_time = $post->post_date;
            $created_at = $OPENPOS_CORE->render_ago_date_by_time_stamp($created_at_time);
            $status = $post->post_status;
            
            $content = $post->post_content;
            $custom_css = get_post_meta($id,'custom_css',true);
            $paper_width = get_post_meta($id,'paper_width',true);
            $padding_top = get_post_meta($id,'padding_top',true);
            $padding_right = get_post_meta($id,'padding_right',true);
            $padding_bottom = get_post_meta($id,'padding_bottom',true);
            $padding_left = get_post_meta($id,'padding_left',true);
            $tmp_type = get_post_meta($id,'template_type',true);
            $type = $tmp_type ? $tmp_type : 'receipt';
            
            $result = array(
                'id' => $id,
                'name' => $name,
                'type' => $type,
                'created_by' => $created_by,
                'created_at' => $created_at,
                'status' => $status,
                'content' => $content,
                'custom_css' => $custom_css,
                'paper_width' => $paper_width,
                'padding_top' => $padding_top,
                'padding_right' => $padding_right,
                'padding_bottom' => $padding_bottom,
                'padding_left' => $padding_left
            );
        
            return apply_filters('op_receipt_template_get_data',$result,$this);
        }
        public function update_receipt_template(){

            $result = array(
                'status' => 0,
                'message' => 'Unknown message',
                'data' => array()
            );
            $name = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
            $id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
            $type = isset($_REQUEST['type']) ? $_REQUEST['type'] : 'receipt';
            $status = isset($_REQUEST['status'])  ? $_REQUEST['status'] : 'draft';
            if($name)
            {
                $params = array(
                    'id' => $id,
                    'name' => $name,
                    'type' => $type,
                    'status' => $status
                );
                $post_id = $this->save($params);
                if($post_id)
                {
                    $result['status'] = 1;
                }
            }else{
                $result['message'] = __('Please enter template name','openpos');
            }
            echo json_encode($result);
            exit;
        }
        public function delete_receipt(){
            $result = array(
                'status' => 0,
                'message' => 'Unknown message',
                'data' => array()
            );
            $id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
            if($this->delete($id))
            {
                $result['status'] = 1;
            }
            echo json_encode($result);
            exit;
        }
        public function update_receipt_content(){
            $result = array(
                'status' => 0,
                'message' => 'Unknown message',
                'data' => array()
            );
            $id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
            $template = $this->get($id);
            if(!empty($template))
            {
                $params = $_POST;
                foreach($params as $key => $val)
                {
                    if($key == "content")
                    {
                        $my_post = array();
                        $my_post['ID'] = $id;
                        $my_post['post_content'] = $val;
                        wp_update_post( $my_post );
                    }else{
                        if($key != 'id' )
                        {
                            update_post_meta($id,$key,$val);
                        }
                    }
                }
                update_post_meta($id,'_tmp_setting','');
                $result['status'] = 1;
            }else{
                $result['message'] = 'Template not found';
            }
            echo json_encode($result);
            exit;
        }
        public function update_receipt_draft(){
            $result = array(
                'status' => 0,
                'message' => 'Unknown message',
                'data' => array()
            );
            $id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
            $template = $this->get($id);
            if(!empty($template))
            {
                $params = $_POST;
                $key = "_tmp_setting";
                update_post_meta($id,$key,$params);
                $result['status'] = 1;
            }else{
                $result['message'] = 'Template not found';
            }
            echo json_encode($result);
            exit;
        }
        public function receipt_preiew(){

            $id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
            $order_id = isset($_REQUEST['order_id']) ? (int)$_REQUEST['order_id'] : 0;
            $template = $this->get($id);
            if(!empty($template))
            {
                wp_register_script('openpos.admin.receipt.ejs', OPENPOS_URL.'/assets/js/ejs.js',array('jquery'));

                $data = $this->get_template_preview_data($template);
                if($order_id)
                {
                    $order_data = get_post_meta($order_id,'_op_order',true);
                    if($order_data)
                    {
                        $order_json = json_encode($order_data);
                        $data['order_json'] = $order_json;
                    }
                }
                $is_review = true;
                require(OPENPOS_DIR.'templates/admin/print_receipt.php');
            }else{
               echo 'Template not found';
            }
            
            
            exit;
        }
        public function get_template_preview_data($template){
           
            $setting = $template;
            $html_header = '';

            $receipt_padding_top = $setting['padding_top'];

            $unit = 'in';
            $receipt_padding_right = $setting['padding_right'];
            $receipt_padding_bottom = $setting['padding_bottom'];
            $receipt_padding_left = $setting['padding_left'];
            $receipt_width = $setting['paper_width'];
            $receipt_css = $setting['custom_css'];
           
            $receipt_template =  do_shortcode($setting['content']);

           

            $html_header = '<style type="text/css" media="print,screen">';
            $html_header .= 'body{ ';
            $html_header .= 'background: #FFEB3B;';   
            $html_header .=  '}';
            $html_header .= '#op-page-cut{page-break-after: always; }';
            $html_header .= '#invoice-POS { ';
            $html_header .= 'padding:  '.$receipt_padding_top.$unit. ' ' . $receipt_padding_right.$unit .' '.$receipt_padding_bottom.$unit.' '.$receipt_padding_left.$unit.';';
            $html_header .= 'margin: 0 auto;';
            $html_header .= 'background: #fff;';
            $html_header .= 'width: '.$receipt_width.$unit.' ;';
            $html_header .=  '}';

            $html_header .= $receipt_css;
            $html_header .= '</style>';
           
            $html = '<div id="invoice-POS">';
            $html_body = html_entity_decode(esc_html($receipt_template));
            
            $html_body = trim(preg_replace('/\s\s+/', ' ', $html_body));
            $html .= $html_body;
            $html .= '</div>';
            
            $html = do_shortcode($html);
            $html_page_cut = '<p id="op-page-cut">&nbsp;</p>';
            $html .= $html_page_cut;
            $data = array(
                'setting' => $setting,
                'html_header' => $html_header,
                'html_body' =>   addslashes($html) ,
                'order_json' =>  ''
    
            );
            if(isset($template['type']) )
            {
                if($template['type'] == 'zreport'){
                    $data['order_json'] = file_get_contents(OPENPOS_DIR.'default/zreport_data.txt');
                }
                if($template['type'] == 'kitchen_receipt'){
                    $data['order_json'] = file_get_contents(OPENPOS_DIR.'default/desk_formatted.txt');
                }
            }
           
            return $data;
        }
        public function get_register_template($register_id){
            $template_id = get_post_meta($register_id,'_op_receipt_template',true);
            if(!$template_id)
            {
                $template_id = 0;
            }
            return $this->get($template_id);
        }
        public function get_register_gift_template($register_id){
            $template_id = get_post_meta($register_id,'_op_gift_receipt_template',true);
            if(!$template_id)
            {
                $template_id = 0;
            }
            if($template_id == -1)
            {
                return false;
            }
            return $this->get($template_id);
        }
        public function get_zreport_template($register_id){
            $template_id = get_post_meta($register_id,'_op_zreport_template',true);
            if(!$template_id)
            {
                $template_id = 0;
            }
            return $this->get($template_id);
        }
        public function get_kitchen_template($register_id)
        {
            $template_id = get_post_meta($register_id,'_op_kitchen_template',true);
            if(!$template_id)
            {
                $template_id = 0;
            }
            return $this->get($template_id);
        }
        public function op_register_form_end($default){
            global $OPENPOS_SETTING;
            $openpos_type = $OPENPOS_SETTING->get_option('openpos_type','openpos_pos');
            
            $templates = $this->templates('publish');
            $current_id = 0;
            $current_gift_id = 0;
            $current_zreport_id = 0;
            $current_kitchen_id = 0;
           
            if(isset($default['id']) && $default['id'])
            {
                $current_receipt = $this->get_register_template($default['id']);
                $current_gift_receipt = $this->get_register_gift_template($default['id']);
                $current_zreport = $this->get_zreport_template($default['id']);
                $current_kitchen = $this->get_kitchen_template($default['id']);
                
                if($current_receipt && !empty($current_receipt))
                {
                    $current_id = $current_receipt['id'];
                }
                if(!is_array($current_gift_receipt))
                {
                    $current_gift_id = -1;
                }else{
                    if($current_gift_receipt && !empty($current_gift_receipt))
                    {
                        $current_gift_id = $current_gift_receipt['id'];
                    }
                }
                
                if($current_zreport && !empty($current_zreport))
                {
                    $current_zreport_id = $current_zreport['id'];
                }
                if($current_kitchen && !empty($current_kitchen))
                {
                    $current_kitchen_id = $current_kitchen['id'];
                }
            }
            
            ?>
            <div class="form-group">
                <label class="col-sm-2 control-label"><?php echo __( 'Receipt', 'openpos' ); ?></label>
                <div class="col-sm-10">
                    <select class="form-control" name="receipt_template">
                            <option value="0" <?php echo $current_id == 0 ? 'selected':''; ?>><?php echo __('Default Template','openpos'); ?></option>
                            <?php foreach($templates as $template): if($template['type'] != 'receipt' ){ continue ; }  ?>
                                    <option value="<?php echo $template['id']; ?>"  <?php echo $current_id == $template['id'] ? 'selected':''; ?> ><?php echo $template['name']; ?></option>
                            <?php endforeach; ?>
                    </select>
                    <small id="emailHelp" class="form-text text-muted"><?php echo __( 'Default template = Use receipt template setting at : admin/pos/setting/receipt template setting', 'openpos' ); ?></small>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-2 control-label"><?php echo __( 'Gift Receipt', 'openpos' ); ?></label>
                <div class="col-sm-10">
                    <select class="form-control" name="gift_receipt_template">
                            <option value="0" <?php echo $current_gift_id == 0 ? 'selected':''; ?>><?php echo __('Default Template','openpos'); ?></option>
                            <?php foreach($templates as $template):  if($template['type'] != 'receipt' ){ continue ; } ?>
                                    <option value="<?php echo $template['id']; ?>"  <?php echo $current_gift_id == $template['id'] ? 'selected':''; ?> ><?php echo $template['name']; ?></option>
                            <?php endforeach; ?>
                            <option value="-1" <?php echo $current_gift_id == -1 ? 'selected':''; ?>><?php echo __('Disable','openpos'); ?></option>
                    </select>
                    <small id="emailHelp" class="form-text text-muted"><?php echo __( 'Default template = Use receipt template setting at : admin/pos/setting/receipt template setting', 'openpos' ); ?></small>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-2 control-label"><?php echo __( 'xReport', 'openpos' ); ?></label>
                <div class="col-sm-10">
                    <select class="form-control" name="zreport_template">
                            <option value="0" <?php echo $current_zreport_id == 0 ? 'selected':''; ?>><?php echo __('No','openpos'); ?></option>
                            <?php foreach($templates as $template): if($template['type'] != 'zreport' ){ continue ; } ?>
                                    <option value="<?php echo $template['id']; ?>"  <?php echo $current_zreport_id == $template['id'] ? 'selected':''; ?> ><?php echo $template['name']; ?></option>
                            <?php endforeach; ?>
                    </select>
                    <small id="emailHelp" class="form-text text-muted"><?php echo __( 'Report template print end working session sale ', 'openpos' ); ?></small>
                </div>
            </div>
            <?php if($openpos_type == 'restaurant') : ?>
            <div class="form-group">
                <label class="col-sm-2 control-label"><?php echo __( 'Kitchen Receipt', 'openpos' ); ?></label>
                <div class="col-sm-10">
                    <select class="form-control" name="kitchen_template">
                            <option value="0" <?php echo $current_kitchen_id == 0 ? 'selected':''; ?>><?php echo __('Default Template','openpos'); ?></option>
                            <?php foreach($templates as $template): if($template['type'] != 'kitchen_receipt' ){ continue ; } ?>
                                    <option value="<?php echo $template['id']; ?>"  <?php echo $current_kitchen_id == $template['id'] ? 'selected':''; ?> ><?php echo $template['name']; ?></option>
                            <?php endforeach; ?>
                    </select>
                    <small id="emailHelp" class="form-text text-muted"><?php echo __( 'Receipt print in table / takeaway.', 'openpos' ); ?></small>
                </div>
            </div>
        <?php endif; ?>
        <?php
        }
        public function op_register_save_after($id,$params,$op_register){
               
                if($id && isset($params['receipt_template']))
                {
                    update_post_meta($id,'_op_receipt_template',(int)$params['receipt_template']);
                }
                if($id && isset($params['gift_receipt_template']))
                {
                    update_post_meta($id,'_op_gift_receipt_template',(int)$params['gift_receipt_template']);
                }
                
                if($id && isset($params['zreport_template']))
                {
                    update_post_meta($id,'_op_zreport_template',(int)$params['zreport_template']);
                }
                if($id && isset($params['kitchen_template']))
                {
                    update_post_meta($id,'_op_kitchen_template',(int)$params['kitchen_template']);
                }
                
                
        }
        public function op_setting_data($session_response_data){
            global $OPENPOS_SETTING;
            $openpos_type = $OPENPOS_SETTING->get_option('openpos_type','openpos_pos');

            //receipt_full_template
            $login_cashdrawer_id = $session_response_data['login_cashdrawer_id'];
            $login_warehouse_id = $session_response_data['login_warehouse_id'];
            if($login_cashdrawer_id)
            {
                global $register_id;
                global $warehouse_id;
                $register_id = $login_cashdrawer_id;
                $warehouse_id = $login_warehouse_id;


                $receipt = $this->get_register_template($login_cashdrawer_id);
                $gift_receipt = $this->get_register_gift_template($login_cashdrawer_id);
                $current_zreport = $this->get_zreport_template($login_cashdrawer_id);
                $current_kitchen = $this->get_kitchen_template($login_cashdrawer_id);
                if($receipt && !empty($receipt))
                {
                    
                    $session_response_data['setting']['receipt_full_template'] = $this->generate_full_receipt_template($receipt);

                    $session_response_data['setting']['receipt_template_header'] = '';
                    $session_response_data['setting']['receipt_template_footer'] = '';
                    $session_response_data['setting']['receipt_template'] = '';
                    $session_response_data['setting']['receipt_css'] = '';
                }
                if(!is_array($gift_receipt))
                {
                    $session_response_data['setting']['receipt_gift_full_template'] = '';
                    $session_response_data['setting']['pos_gift_receipt_enable'] = 'no';
                }else{
                    if($gift_receipt && !empty($gift_receipt))
                    {
                        
                        $session_response_data['setting']['receipt_gift_full_template'] = $this->generate_full_receipt_template($gift_receipt,'gift');
                    }
                }
                
                if($current_zreport && !empty($current_zreport))
                {
                    
                    $session_response_data['pos_report_template']= $this->generate_full_receipt_template($current_zreport,'report');
                }
                if($openpos_type == 'restaurant') 
                {
                    if($current_kitchen && !empty($current_kitchen))
                    {
                        
                        $session_response_data['setting']['pos_kitchen_receipt_template']= $this->generate_full_receipt_template($current_kitchen,'kitchen');
                    }else{
                        $file_name = 'kitchen_receipt_template_full.txt';
                        $kitchen_file_path = rtrim(OPENPOS_DIR,'/').'/default/'.$file_name;
                        $kitchen_receipt_template = file_get_contents($kitchen_file_path);
                        
                        $session_response_data['setting']['pos_kitchen_receipt_template']= $kitchen_receipt_template;
                    }
                }
                
            }
            return $session_response_data;
        }
        public function generate_full_receipt_template($receipt,$type = ''){

            $setting = $receipt;
            $html_header = '';
            $receipt_padding_top = $setting['padding_top'];
            $unit = 'in';
            $receipt_padding_right = $setting['padding_right'];
            $receipt_padding_bottom = $setting['padding_bottom'];
            $receipt_padding_left = $setting['padding_left'];
            $receipt_width = $setting['paper_width'];
            $receipt_css = $setting['custom_css'];
            $receipt_template = do_shortcode($setting['content']);
            $html_header = '<style type="text/css" media="print,screen">';
            $html_header .= '#op-page-cut{page-break-after: always; }';
            $html_header .= '#invoice-POS { ';
            $html_header .= 'padding:  '.$receipt_padding_top.$unit. ' ' . $receipt_padding_right.$unit .' '.$receipt_padding_bottom.$unit.' '.$receipt_padding_left.$unit.';';
            $html_header .= 'margin: 0 auto;';
            $html_header .= 'background: #fff;';
            $html_header .= 'width: '.$receipt_width.$unit.' ;';
            $html_header .=  '}';
            $html_header .= $receipt_css;
            $html_header .= '</style>';
            $html = '<div id="invoice-POS">';
            $html_body = html_entity_decode(esc_html($receipt_template));
            $html_body = trim(preg_replace('/\s\s+/', ' ', $html_body));
            $html .= $html_body;
            $html .= '</div>';

            $html_page_cut = '<p id="op-page-cut">&nbsp;</p>';
            
            return '<html><head>'.$html_header.'</head><body style="margin:0;">'.$html.$html_page_cut.'</body></html>';
        }

        public function send_receipt(string $send_to = null,$order_data = array(),$register_id= 0,$source = '') //formatted order data 
        {
            global $OPENPOS_CORE;
            global $_g_send_to;
            $result = array('status' => 0, 'message' => '','data' => array());
            try{
                $allow_send = true;
                $order_id = isset($order_data['order_id']) ? $order_data['order_id'] : 0;
                $template_id = isset($_REQUEST['template_id']) ? (int)$_REQUEST['template_id'] : 0;
                
                if($source != 'manual' && $order_id)
                {
                    if(get_post_meta($order_id,'_op_email_receipt_sent',true) == 'yes'){
                        $allow_send = false;
                    }
                }
                if($allow_send && $send_to != null)
                {
                    $use_woo_email =  apply_filters('op_receipt_use_woo_email',false,$order_data);
                    
                    $order = wc_get_order($order_id);
                    if ( is_wp_error( $order ) ) {
                        $use_woo_email = false;
                    }
                    
                    if($use_woo_email && $order)
                    {
                        $_g_send_to = $send_to;
                        WC()->mailer()->customer_invoice( $order );

                        $result['status'] = 1;
                        $result['message'] = __('Receipt has been sent','openpos');
                    }else{
                        $receipt_url = '';
                        if($order_id && $register_id)
                        {
                            $_op_session_id = get_post_meta($order_id,'_op_session_id',true);
                            $receipt_url = admin_url('admin-ajax.php?action=print_receipt&source=email&id='.(int)$order_id.'&s='.$_op_session_id);
                        }
                        $order_data['receipt_url'] = $receipt_url;
                        $template = apply_filters('op_receipt_email_template','receipt.php',$register_id,$order_data);
                        
                        $template_path_dir = $OPENPOS_CORE->getTemplatePath('emails/'.$template);
                        $template_path = apply_filters('op_receipt_email_template_path',$template_path_dir.'emails',$register_id,$order_data);
                        $template_path = rtrim($template_path,"/");
                        $template_path .= '/';

                        

                        $message =  wc_get_template_html( $template, array('order_data' =>  $order_data) ,$template_path,$template_path);
                        
                    
                        $from_name =  get_option( 'woocommerce_email_from_name' );
                        $from_email =  get_option( 'woocommerce_email_from_address' );
                        $from = array(
                            'name' => $from_name,
                            'email' => $from_email
                        );
                        $from = apply_filters('op_receipt_from_info',$from,$register_id);
                        $headers = array(
                            'Content-Type: text/html; charset=UTF-8',
                            'From: '. $from['name']  .' <'. $from['email']  .'>'
                        );
                        $subject = apply_filters('op_receipt_email_subject',__('New Order Receipt Notification','openpos'),$register_id);
                        $message = apply_filters('op_receipt_email_message',$message,$register_id);

                        
                        if(wp_mail($send_to, $subject, $message,$headers )){
                            $result['status'] = 1;
                            $result['message'] = __('Receipt has been sent','openpos');
    
                            if($source != 'manual' && $order_id)
                            {
                                update_post_meta($order_id,'_op_email_receipt_sent','yes');
                            }
                        }else{
                            $result['status'] = 0;
                            $result['message'] = __('Can not send receipt','openpos');;
                        } 
                    }
                    
                }
                
            }catch (Exception $e)
            {
                $result['status'] = 0;
                $result['message'] = $e->getMessage();
            }
            return $result;
        }
        

    }
}
?>