<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title><?php $name = str_replace('_', ' ', $_REQUEST["c"] ?? 'Canal'); echo $name; ?> | Visualizao de Vdeo</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=no"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <link rel="shortcut icon" type="image/x-icon" href="https://i.ibb.co/37fVLxB/f4027915ec9335046755d489a14472f2.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/plyr@3.6.2/dist/plyr.css" />
    <script src="https://cdn.jsdelivr.net/npm/plyr@3.6.12/dist/plyr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/hls.js@1.1.4/dist/hls.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <style>
        html, body {
            font-family: Poppins;
            background: #000;
            margin: 0;
            padding: 0;
            color: #fff;
        }
        #backButton {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 10000;
            padding: 10px 20px;
            background-color: #007bff;
            color: #ffffff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            display: none;
            font-size: 16px;
        }
    </style>
</head>
<body>
    <button id="backButton" onclick="window.history.back();">Voltar</button>
    <video id="video" controls playsinline style="width: 100%; height: auto;">
        <source src="" type="">
    </video>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    const videoElement = document.getElementById('video');
    let hls;
    let currentUrl = '';

    // Utility function to display messages dynamically on the page
    const messageContainer = document.createElement('div');
    document.body.appendChild(messageContainer);
    messageContainer.style.cssText = "position: absolute; top: 10px; right: 10px; background: rgba(0, 0, 0, 0.75); color: white; padding: 10px; display: none;";

    function showMessage(message) {
        messageContainer.innerText = message;
        messageContainer.style.display = 'block';
    }

    function hideMessage() {
        messageContainer.style.display = 'none';
    }

    function initHls(url) {
        if (hls) {
            hls.destroy();
        }
        hls = new Hls();
        hls.loadSource(url);
        hls.attachMedia(videoElement);
        hls.on(Hls.Events.MANIFEST_PARSED, () => {
            videoElement.play();
        });
        hls.on(Hls.Events.ERROR, (event, data) => {
            if (data.fatal) {
                switch (data.type) {
                    case Hls.ErrorTypes.NETWORK_ERROR:
                        showMessage("Network error, trying to recover...");
                        hls.startLoad();
                        break;
                    case Hls.ErrorTypes.MEDIA_ERROR:
                        showMessage("Media error, attempting to recover...");
                        hls.recoverMediaError();
                        break;
                    default:
                        showMessage("Fatal error, stopping playback.");
                        videoElement.pause();
                        break;
                }
            }
        });
    }

    function setSourceType(url) {
        if (url.match(/\.m3u8$/)) {
            return 'application/vnd.apple.mpegurl';
        } else if (url.match(/\.mp4$/)) {
            return 'video/mp4';
        }
        return ''; // Default type if the URL doesn't match known patterns
    }

    function updateVideo(url, type) {
        currentUrl = url;  // Update current URL
        videoElement.src = url;
        videoElement.type = type;
        videoElement.load();
        if (type === 'application/vnd.apple.mpegurl' && Hls.isSupported()) {
            initHls(url);
        } else {
            videoElement.play();
        }
    }

    function fetchAndUpdateVideoUrl() {
        const noCacheUrl = 'channel_url.json?' + new Date().getTime(); // Adds timestamp to avoid cache
        fetch(noCacheUrl)
            .then(response => response.json())
            .then(data => {
                const newUrl = data.url;
                if (newUrl !== currentUrl) {
                    const type = setSourceType(newUrl);
                    updateVideo(newUrl, type);
                }
            })
            .catch(error => {
                console.error('Error fetching the new URL:', error);
                showMessage('Error fetching the new URL. Will retry...');
            });
    }

    fetchAndUpdateVideoUrl(); // Run once on load
    setInterval(fetchAndUpdateVideoUrl, 10000); // Check every 10 seconds

    document.addEventListener('mousemove', function() {
        document.getElementById('backButton').style.display = 'block';
        clearTimeout(window.mouseMoveTimeout);
        window.mouseMoveTimeout = setTimeout(function() {
            document.getElementById('backButton').style.display = 'none';
        }, 3000);
    });

    new Plyr(videoElement, { captions: { active: true, update: true } });
});
</script>
</body>
</html>
