<?php


date_default_timezone_set('America/Manaus');



 



ini_set('memory_limit', '512M');  
 


$filePath = 'lista2.m3u8';  

 
if (!file_exists($filePath)) {
    die("O arquivo $filePath nÃ£o foi encontrado.");
}

 
$m3u8Content = file_get_contents($filePath);
$lines = explode("\n", $m3u8Content);

 
$liveChannels = [];
$movies = [];

$currentEntry = [];

 
$filtros = ['CNN BRASIL HD','Globo TV Rede','RECORD SP HD','RECORD NEWS HD','CNN BRASIL SD','BAND SP HD','BAND SP SD','GLOBO SP HD','SBT SP SD','RECORD SP HD','MULTISHOW HD' ,'DISCOVERY KIDS FHD (H265)','VIVA HD','REDE TV HD' ,'SPORTV HD','BAND NEWS HD','UFC Fight Pass HD','Premiere Clubes'];

foreach ($lines as $line) {
 
    if (strpos($line, '#EXTINF:') === 0) {
        // ExtraÃ§Ã£o de metadados da entrada atual
        preg_match('/tvg-name="([^"]+)"[^,]*,(.*)/', $line, $nameMatches);
        preg_match('/tvg-logo="([^"]+)"/', $line, $logoMatches);
        preg_match('/group-title="([^"]*)"/', $line, $groupMatches);
        
 
        $currentEntry = [
            'name' => $nameMatches[1] ?? '',
            'title' => $nameMatches[2] ?? '',
            'logo' => $logoMatches[1] ?? '',
            'group' => $groupMatches[1] ?? '',
            'url' => ''  
        ];
    } elseif (filter_var(trim($line), FILTER_VALIDATE_URL)) {
 
        $currentEntry['url'] = trim($line);

 
        if (substr($currentEntry['url'], -4) === '.mp4') {
            $movies[] = $currentEntry;
        } else {
 
            $includeChannel = false;
            if (in_array('', $filtros)) {
                $includeChannel = true;
            } else {
                foreach ($filtros as $filtro) {
                    if (stripos($currentEntry['name'], $filtro) !== false) {
                        $includeChannel = true;
                        break;
                    }
                }
            }
            if ($includeChannel) {
                $liveChannels[] = $currentEntry;
            }
        }

 
        $currentEntry = [];
    }
}

 
function printEntries($entries) {
    foreach ($entries as $entry) {
        echo "Nome: " . $entry['name'] . "<br>";
        echo "TÃ­tulo: " . $entry['title'] . "<br>";
        echo "Logo: " . $entry['logo'] . "<br>";
        echo "Grupo: " . $entry['group'] . "<br>";
        echo "URL: " . $entry['url'] . "<br><br>";
    }
}


// Exemplo de como chamar a função para exibir filmes
// Limitar a quantidade de filmes exibidos a 100
$limitedMovies = array_slice($movies, 0, 1000);
 
//$limitedTv = array_slice($liveChannels, 0, 1000);
$limitedTv = $liveChannels;



?>











<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Seleção de Canais de TV e Filmes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #1E88E5;
            color: #ffffff;
        }
        .navbar {
            background-color: #1565C0;
        }
        .nav-tabs .nav-link {
            color: #ffffff;
        }
        .nav-tabs .nav-link.active {
            background-color: #0D47A1;
            border-color: #0D47A1;
            color: #fff;
        }
        .channel {
            display: flex;
            align-items: center;
            padding: 10px;
            background-color: #1976D2;
            border-radius: 5px;
            margin-bottom: 8px;
            cursor: pointer;
        }



        .channel {
    display: flex; /* Mantém itens da lista em flexbox */
    align-items: center; /* Centraliza verticalmente */
 }

.channel img {
     width: 44px; /* Você pode ajustar a largura conforme necessário */
    margin-right: 15px; /* Adiciona espaço à direita da imagem */
}

.channel span {
    flex-grow: 1; /* Faz com que o texto ocupe o espaço restante */
    text-align: left; /* Alinha o texto à esquerda */
}



        .active-channel {
            background-color: #0D47A1;
        }
        .channel img {
             width: 44px;
        }
        .tab-content {
            background-color: #2196F3;
            padding: 20px;
            border-radius: 5px;
        }


        .search-input {
    width: 100%; /* Ajusta a largura para ocupar todo o espaço disponível */
    padding: 10px; /* Adiciona um pouco de espaço interno para que o texto não fique muito perto das bordas */
    margin-bottom: 20px; /* Adiciona espaço abaixo do campo de pesquisa */
    border: 2px solid #0D47A1; /* Coloca uma borda sólida */
    border-radius: 5px; /* Arredonda as bordas do campo de entrada */
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2); /* Adiciona uma sombra sutil para um efeito 3D leve */
    background-color: #ffffff; /* Muda a cor de fundo para branco */
    color: #333; /* Muda a cor do texto para algo mais escuro para contrastar com o fundo branco */
}

/* Estiliza o placeholder do campo de pesquisa para que fique com uma cor mais clara */
.search-input::placeholder {
    color: #aaa;
}

/* Efeito hover no campo de pesquisa */
.search-input:hover {
    border-color: #1565C0;
}

/* Efeito focus no campo de pesquisa */
.search-input:focus {
    outline: none; /* Remove o contorno padrão que o navegador aplica quando o campo está focado */
    border-color: #1565C0;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.4); /* Sombra mais escura para dar uma sensação de profundidade */
}




body, html {
    height: 100%; /* Define a altura do body e html para cobrir toda a altura da janela */
    margin: 0; /* Remove as margens padro */
    padding: 0; /* Remove o padding padro */
}

.navbar {
    position: fixed; /* Fixa o navbar no topo */
    width: 100%; /* Garante que o navbar ocupe toda a largura */
    z-index: 1000; /* Mantm o navbar acima de outros contedos */
}

.container.mt-5 {
    padding-top: 30px; /* Adiciona um padding no topo para evitar sobreposio com o navbar */
}

.tab-content {
    max-height: calc(100vh - 180px); /* Altura mxima para permitir scrolling dentro das abas */
    overflow-y: auto; /* Adiciona scroll vertical se o contedo exceder a altura mxima */
}










    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark fixed-top">
    <div class="container">
        <a class="navbar-brand text-top" href="#">CONTROL PLAY</a>






        
    </div>
</nav>




<div class="container mt-5" style="padding-top: 20px;">
    <!-- Aqui começam as abas -->

 

 Selecionado: 
 
 
             <ul class="list-unstyled" id="moviesList">
 
            <li class="channel" id="selectedChannel" >
                <img src="http://i.ibb.co/kQsX18p/1.png"  >
                Carregando...
            </li>
 
        </ul>
 




    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="canais-tab" data-bs-toggle="tab" data-bs-target="#canais" type="button" role="tab" aria-controls="canais" aria-selected="true">Canais</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="filmes-tab" data-bs-toggle="tab" data-bs-target="#filmes" type="button" role="tab" aria-controls="filmes" aria-selected="false">Filmes</button>
        </li>


        <li class="nav-item" role="presentation">
            <button class="nav-link" id="institucional-tab" data-bs-toggle="tab" data-bs-target="#institucional" type="button" role="tab" aria-controls="institucional" aria-selected="false">Institucional</button>
        </li>



    </ul>








    <!-- Aqui terminam as abas -->

    <!-- Aqui começa o conteúdo das abas -->
    <div class="tab-content" id="myTabContent">



    <div class="tab-pane fade show active" id="canais" role="tabpanel" aria-labelledby="canais-tab">
        <!-- Campo de pesquisa para canais -->
         <input type="text" class="search-input" id="searchChannels" placeholder="Pesquisar Canais...">

 
        <ul class="list-unstyled" id="channelsList">
            <?php foreach ($limitedTv as $channel): ?>
            <li class="channel" data-name="<?php echo strtolower(htmlspecialchars($channel['name'])); ?>" data-channel="<?php echo htmlspecialchars($channel['url']); ?>">
                <img src="<?php echo htmlspecialchars($channel['logo']); ?>" alt="<?php echo htmlspecialchars($channel['name']); ?>">
                <?php echo htmlspecialchars($channel['name']); ?>
            </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <div class="tab-pane fade" id="filmes" role="tabpanel" aria-labelledby="filmes-tab">
        <!-- Campo de pesquisa para filmes -->
        <input type="text" class="search-input" id="searchMovies" placeholder="Pesquisar Filmes...">
        <ul class="list-unstyled" id="moviesList">
            <?php foreach ($limitedMovies as $movie): ?>
            <li class="channel" data-name="<?php echo strtolower(htmlspecialchars($movie['name'])); ?>" data-channel="<?php echo htmlspecialchars($movie['url']); ?>">
                <img src="<?php echo htmlspecialchars($movie['logo']); ?>" alt="<?php echo htmlspecialchars($movie['name']); ?>">
                <?php echo htmlspecialchars($movie['name']); ?>
            </li>
            <?php endforeach; ?>
        </ul>
    </div>



<?php


$baseDir = rtrim(dirname($_SERVER['PHP_SELF']), '/\\') . '/';
$url = 'http://' . $_SERVER['HTTP_HOST'] . $baseDir;
 

?>



    <div class="tab-pane fade" id="institucional" role="tabpanel" aria-labelledby="institucional-tab">
        <!-- Campo de pesquisa para filmes -->
        <input type="text" class="search-input" id="institucional" placeholder="Pesquisar Institucional...">
        <ul class="list-unstyled" id="institucional">
 
            <li class="channel" data-name="Seguranca 1" data-channel="<?php echo $url;?>/s1.mp4">
                <img src="<?php echo $url;?>/s.jpg" alt="<?php echo "Seguranca 1"; ?>">
                <?php echo "Seguranca 1"; ?>
            </li>
            
        </ul>
    </div>



</div>


</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
 







<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Função para filtrar canais ou filmes
        function filterList(inputElement, listElement) {
            inputElement.addEventListener('keyup', function() {
                let filterValue = this.value.toLowerCase();
                let listItems = listElement.querySelectorAll('li');
                listItems.forEach(function(item) {
                    let name = item.getAttribute('data-name');
                    if (name.indexOf(filterValue) > -1) {
                        item.style.display = '';
                    } else {
                        item.style.display = 'none';
                    }
                });
            });
        }

        // Aplica o filtro à lista de canais
        filterList(document.getElementById('searchChannels'), document.getElementById('channelsList'));

        // Aplica o filtro à lista de filmes
        filterList(document.getElementById('searchMovies'), document.getElementById('moviesList'));

        // Aplica o filtro à lista de filmes
        filterList(document.getElementById('institucional'), document.getElementById('institucional'));


    });
</script>





<script>
document.addEventListener('DOMContentLoaded', function() {
    const channels = document.querySelectorAll('.channel');
    channels.forEach(channel => {
        channel.addEventListener('click', function() {
            const url = this.getAttribute('data-channel');
            const name = this.textContent.trim();
            const logo = this.querySelector('img').src;

            fetch('saveChannelUrl.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ url: url, name: name, logo: logo })
            })
            .then(response => response.text())
            .then(data => {
                console.log(data);
                updateSelectedChannel(name, logo);  // Atualiza a interface
            })
            .catch(error => console.error('Error:', error));
        });
    });

    function updateSelectedChannel(name, logo) {
        const channelDisplay = document.getElementById('selectedChannel');
        channelDisplay.innerHTML = `<img src="${logo}" alt="${name}"> ${name}`;
    }

    // Carrega os dados do canal selecionado ao carregar a pgina
    fetch('channel_url.json')
    .then(response => response.json())
    .then(data => {
        updateSelectedChannel(data.name, data.logo);
    })
    .catch(error => console.error('Erro ao carregar o canal selecionado:', error));
});
</script>






    <script>
        document.querySelectorAll('.channel').forEach(item => {
            item.addEventListener('click', function() {
                document.querySelectorAll('.channel').forEach(channel => {
                    channel.classList.remove('active-channel');
                });
                item.classList.add('active-channel');
            });
        });
    </script>










</body>
</html>
