<?php
// Força exibição de erros para debug
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Inclui funções do WordPress (para get_template_directory())
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');

// Caminho físico do arquivo .pem
$KEY = get_template_directory() . '/qz/private-key.pem';

// Captura o que será assinado
$toSign = $_GET['request'] ?? '';
if (!$toSign) {
    http_response_code(400);
    exit("❌ Nada para assinar.");
}

// Lê o conteúdo da chave
$pem = file_get_contents($KEY);
if (!$pem) {
    http_response_code(500);
    exit("❌ Erro: chave não encontrada em: $KEY");
}

// Inicializa chave
$pkey = openssl_pkey_get_private($pem);
if (!$pkey) {
    http_response_code(500);
    exit("❌ Erro: chave inválida");
}

// Gera assinatura
if (!openssl_sign($toSign, $sig, $pkey, OPENSSL_ALGO_SHA512)) {
    http_response_code(500);
    exit("❌ Erro ao assinar");
}

openssl_free_key($pkey);
header('Content-Type: text/plain');
echo base64_encode($sig);
