<?php
/**
 * sign-message.php – dentro de cada pasta qz/1, qz/2, ...
 * Requer: private-key.pem + digital-certificate.txt
 */

header("Content-Type: text/plain");

$request = $_GET['request'] ?? '';
if (!$request) {
    http_response_code(400);
    exit("Faltando parâmetro 'request'.");
}

// Caminho da chave
$keyFile = __DIR__ . '/private-key.pem';
if (!file_exists($keyFile)) {
    http_response_code(500);
    exit("Chave privada não encontrada.");
}

$privateKey = file_get_contents($keyFile);
$pkey = openssl_pkey_get_private($privateKey);
if (!$pkey) {
    http_response_code(500);
    exit("Erro ao carregar chave.");
}

$ok = openssl_sign($request, $signature, $pkey, OPENSSL_ALGO_SHA512);
openssl_free_key($pkey);

if (!$ok) {
    http_response_code(500);
    exit("Erro ao assinar.");
}

echo base64_encode($signature);
