<?php
/* 
Template Name: Página Simples
*/
get_header(); // chama o header.php do tema
?>
 <?php
/**
 * Template Name: Cadastro de Frete — Rápido (NF obrigatória)
 */
if (!defined('ABSPATH')) exit;

/** ========= FONTES =========
 * Produtos (CPT): cad_frete_produto
 *  - title = nome
 *  - meta 'valor' = preço
 * Contatos (CPT): clientes
 *  - title   = nome
 *  - metas   = 'telefone' e 'doc'
 *  - (fallback de leitura p/ legado: 'contato_remetente', 'cpf_cnpj', 'cpf')
 */

// ---- Produtos (nome + valor) ----
$PRODUTOS = [];
$qp = new WP_Query([
  'post_type'      => 'cad_frete_produto',
  'posts_per_page' => -1,
  'orderby'        => 'title',
  'order'          => 'ASC',
  'no_found_rows'  => true,
  'fields'         => 'ids',
]);
foreach (($qp->posts ?? []) as $pid) {
  $nome  = get_the_title($pid);
  if ($nome === '') continue;
  $valor = (float) get_post_meta($pid, 'valor', true);
  $PRODUTOS[] = ['id' => $pid, 'nome' => $nome, 'valor' => $valor];
}
wp_reset_postdata();

// ---- Contatos (Remetente/Destinatário) ----
$CONTATOS = [];
$dias = 50;

$qc = new WP_Query([
  'post_type'      => 'clientes',
  'date_query'     => [
    [
      'after'     => "$dias days ago",
      'inclusive' => true,
    ],
  ],
  'orderby'        => 'title',
  'order'          => 'ASC',
  'posts_per_page' => -1,
  'no_found_rows'  => true,
  'fields'         => 'ids',
]);

// Remove IDs duplicados
$ids_unicos = array_unique($qc->posts);



$seen = [];
foreach (($qc->posts ?? []) as $pid) {
  $nome = get_the_title($pid);
  if ($nome === '') continue;
  $key = mb_strtolower($nome);
  if (isset($seen[$key])) continue;
  $seen[$key] = true;

  // telefone oficial: 'telefone' (fallback legado 'contato_remetente')
  $tel = (string) get_post_meta($pid, 'telefone', true);
  if ($tel === '') $tel = (string) get_post_meta($pid, 'contato_remetente', true);

  // documento oficial: 'doc' (fallback legado 'cpf_cnpj' ou 'cpf')
  $doc = (string) get_post_meta($pid, 'doc', true);
  if ($doc === '') $doc = (string) get_post_meta($pid, 'cpf_cnpj', true);
  if ($doc === '') $doc = (string) get_post_meta($pid, 'cpf', true);

  $CONTATOS[] = [
    'id'       => $pid,
    'nome'     => $nome,
    'telefone' => $tel,
    'cpf'      => $doc, // mantemos a chave 'cpf' no JS por compatibilidade
  ];
}
wp_reset_postdata();

// AJAX (produto novo) + nonces p/ contatos
$ajax_url         = admin_url('admin-ajax.php');
$nonce_add_prod   = wp_create_nonce('adicionar_produto_nonce');
$nonce_tel_upd    = wp_create_nonce('freteq_atualizar_telefone_nonce');
$nonce_doc_upd    = wp_create_nonce('freteq_atualizar_cpf_nonce');   // usaremos para 'doc'
$nonce_resolver   = wp_create_nonce('freteq_resolver_contato_nonce');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Cadastro de Frete (Rápido)</title>
   <link href="https://code.jquery.com/ui/1.13.3/themes/base/jquery-ui.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  <script src="https://code.jquery.com/ui/1.13.3/jquery-ui.min.js"></script>
  <style>
    body{background:#f7f7f7}
    .box{background:#fff;border:1px solid #e6e6e6;border-radius:10px;padding:16px;margin-bottom:12px}
    .form-label{font-size:.9rem}
    .form-control,.form-select{font-size:.9rem;height:auto;padding:.5rem .6rem}
    table.table-sm td,table.table-sm th{padding:.35rem .5rem}
    .ui-autocomplete{max-height:260px;overflow-y:auto;overflow-x:hidden;z-index:5000!important}
    #topProdutos .chip{border:1px solid #e0e0e0;background:#fafafa;border-radius:999px;padding:.25rem .6rem;font-size:.85rem;cursor:pointer;margin:.15rem;display:inline-flex;gap:.35rem}
    #topProdutos .chip:hover{background:#f0f0f0}
    .nf-row .del-nf{opacity:.8}
  </style>
</head>
<body>
<div class="container py-3">
  <div class="d-flex align-items-center p-3 border rounded bg-white mb-3 shadow-sm">
    <i class="bi bi-truck display-5 me-3"></i>
    <div>
      <h3 class="mb-0">Cadastro de Fretes (Rápido)</h3>
      <small class="text-muted">
        Atalhos: <strong>F2</strong> produto novo • <strong>F4</strong> nova NF • <strong>F6</strong> ir para pagamento • Enter encadeia tudo
      </small>
    </div>
  </div>

  <form id="formFrete" class="needs-validation" novalidate method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">

  <div id="campo-status" style="display:none;">
    <label for="status">Status</label>
    <select id="status" name="status" class="form-control">
      <option value="Recebida">Recebida</option>
      <option value="Entregue">Entregue</option>
    </select>
  </div>

  <input type="hidden" name="action" value="cadastrar_encomenda">
  <input type="hidden" name="tipocat" value="Frete">
  <input type="hidden" id="data_pagamento" name="data_pagamento">
  <input type="hidden" id="produtosSelecionados" name="produtos_selecionados">
  <input type="hidden" id="notas_json" name="notas_fiscais_json">
  <input type="hidden" id="remetente_id" name="remetente_id">
  <input type="hidden" id="destinatario_id" name="destinatario_id">
  <?php wp_nonce_field('freteq_cad', 'freteq_cad_nonce'); ?>

  <div class="box">


  <!-- Linha ÚNICA: Origem até Destinatário -->
  <div class="row g-3">
    <div class="col-lg-1">
      <label for="origemSelect" class="form-label mb-1">Origem</label>
      <select id="origemSelect" name="origem" class="form-select">
        <option>Manaus</option><option>Codajás</option><option>Coari</option>
        <option>Tefé</option><option>Alvarães</option><option>Uarini</option>
      </select>
    </div>
    <div class="col-lg-1">
      <label for="tipoP" class="form-label mb-1">Tipo</label>
      <select id="tipoP" name="tipoP" class="form-select">
        <option value="Avista">À vista</option>
        <option value="Receber">A receber</option>
        <option value="Faturado">Faturado</option>
      </select>
    </div>
    <div class="col-lg-2">
      <label for="transporteSelect" class="form-label mb-1">Transporte</label>
      <select class="form-select" name="transporte" id="Transporte" required>
                    <?php
                    $args = array(
                        'post_type' => 'empresa',
                        'posts_per_page' => -1,
                        'orderby' => 'title',
                        'order' => 'DESC'
                    );
                    $empresa_query = new WP_Query($args);
                    if ($empresa_query->have_posts()) :
                        while ($empresa_query->have_posts()) : $empresa_query->the_post(); ?>
                            <option value="<?php echo get_the_ID(); ?>"><?php the_title(); ?></option>
                        <?php endwhile;
                        wp_reset_postdata();
                    else : ?>
                        <option value=""></option>
                    <?php endif; ?>
                </select>
    </div>
    <div class="col-lg-2">
      <label for="nomeConferente" class="form-label mb-1">Conferente</label>
      <input type="text" id="nomeConferente" name="nome_conferente" class="form-control" required>
    </div>
    <div class="col-lg-2">
      <label for="destinoInput" class="form-label mb-1">Destino (Cidade)</label>
      <input type="text" id="destinoInput" name="destino" class="form-control" required>
    </div>
    <div class="col-lg-2">
      <label for="nomeRemetente" class="form-label mb-1">Remetente</label>
      <input type="text" id="nomeRemetente" name="nome_remetente" class="form-control" required>
      <!-- ocultos -->
      <input type="hidden" id="contatoRemetente" name="contato_remetente" value="nao informado">
      <input type="hidden" id="cpfRemetente" name="cpf_remetente" value="nao informado">
    </div>
    <div class="col-lg-2">
      <label for="nomeDestinatario" class="form-label mb-1">Destinatário</label>
      <input type="text" id="nomeDestinatario" name="nome_destinatario" class="form-control" required>
      <!-- ocultos -->
      <input type="hidden" id="contatoDestinatario" name="contato_destinatario" value="nao informado">
      <input type="hidden" id="cpfDestinatario" name="cpf_destinatario" value="nao informado">
    </div>
  </div>


<hr>
  </div>

<!-- BOTÃO PARA EXPANDIR / RECOLHER MAIS OPÇÕES -->
<div class="text-end mb-2">
  <button class="btn btn-outline-secondary btn-sm" type="button"
          data-bs-toggle="collapse" data-bs-target="#maisOpcoes"
          aria-expanded="false" aria-controls="maisOpcoes"
          id="btnMaisOpcoes">
    <span class="icon">+</span> Mais opções
  </button>
</div>



<!-- ÁREA COLAPSÁVEL -->
<div class="collapse" id="maisOpcoes">
  <div class="row g-3 mt-2">
    <div class="col-12">
      <!-- Coloque aqui o bloco de Nota Fiscal -->

      




    </div>
  </div>



  
  <div class="row g-3 mt-2">
    <div class="col-12">
      <!-- Coloque aqui o bloco de Dados do Carro -->



      
  <!-- DADOS DO CARRO (opcional) -->
  <div class="row g-3 mt-2">
    <div class="col-12">
      <div class="box">
        <h6 class="mb-2">Dados do Carro (opcional)</h6>
        <div class="row g-2">
          <div class="col-sm-3">
            <label class="form-label mb-1" for="carroPlaca">Placa</label>
            <input
              type="text"
              id="carroPlaca"
              name="carro_placa"
              class="form-control"
              placeholder="ABC1D23"
              pattern="^[A-Z]{3}\d[A-Z0-9]\d{2}$|^[A-Z]{3}-?\d{4}$"
              title="Formato novo (AAA1A23) ou antigo (AAA-1234)"
            >
          </div>
          <div class="col-sm-4">
            <label class="form-label mb-1" for="carroModelo">Modelo</label>
            <input type="text" id="carroModelo" name="carro_modelo" class="form-control" placeholder="Ex.: Strada" value="0">
          </div>
          <div class="col-sm-2">
            <label class="form-label mb-1" for="carroCor">Cor</label>
            <input type="text" id="carroCor" name="carro_cor" class="form-control" placeholder="Ex.: Prata" value="0">
          </div>
          <div class="col-sm-3">
            <label class="form-label mb-1" for="carroTelResp">Tel do Responsável</label>
            <input type="text" id="carroTelResp" name="carro_telefone_responsavel" class="form-control" placeholder="(92) 9xxxx-xxxx" value="0">
          </div>
        </div>
      </div>
    </div>
  </div>



  
    </div>
  </div>
</div>




  <!-- NOTA FISCAL -->
  <div class="row g-3 mt-2">
    <div class="col-12">
      <div class="box">
        <div class="d-flex align-items-center justify-content-between">
          <h6 class="mb-0">Nota Fiscal</h6>
          <button class="btn btn-outline-dark btn-sm" type="button" id="btnAddNF" title="F4">
            <i class="bi bi-plus-lg me-1"></i>Adicionar NF (F4)
          </button>
        </div>
        <div id="wrapNF" class="mt-3">
           <div id="listNF"></div>
         </div>
      </div>
    </div>
  </div>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const btn = document.getElementById("btnMaisOpcoes");
  const icon = btn.querySelector(".icon");
  const maisOpcoes = document.getElementById("maisOpcoes");

  maisOpcoes.addEventListener("show.bs.collapse", () => {
    icon.textContent = "–"; // quando abrir
  });
  maisOpcoes.addEventListener("hide.bs.collapse", () => {
    icon.textContent = "+"; // quando fechar
  });
});
</script>

















  



  <!-- Produtos + Pagamento -->
  <div class="row g-3 mt-2">
    <div class="col-lg-7">
      <div class="box">
        <div class="d-flex align-items-center justify-content-between mb-2">
          <h6 class="mb-0">Produtos (rápido)</h6>
          <small class="text-muted">F2: cadastrar produto novo</small>
        </div>
        <div class="row g-2 align-items-center mb-2">
          <div class="col-7">
            <input type="text" id="quickProduto" class="form-control" placeholder="Produto… (ou F2 p/ novo)" autocomplete="off">
          </div>
          <div class="col-2">
            <input type="number" id="quickQtd" class="form-control text-center" min="1" step="1" value="1" title="Quantidade">
          </div>
          <div class="col-3 d-grid">
            <button type="button" id="btnAddProduto" class="btn btn-dark"><i class="bi bi-plus-lg me-1"></i>Adicionar</button>
          </div>
        </div>


        <div class="table-responsive">
          <table class="table table-bordered table-sm align-middle" id="tProdutos">
            <thead class="table-light">
              <tr>
                <th>Produto</th><th class="text-center" style="width:80px">Qtd</th>
                <th class="text-end" style="width:120px">Valor</th><th class="text-end" style="width:120px">Total</th>
                <th style="width:40px"></th>
              </tr>
            </thead>
            <tbody id="listaProdutos"></tbody>
          </table>
        </div>

        <label class="form-label mt-2" for="obs">Observação</label>
        <textarea id="obs" name="obs" rows="3" class="form-control"></textarea>
      </div>
    </div>

    <div class="col-lg-5">
      <div class="box">
        <div class="d-flex align-items-center justify-content-between">
          <h6 class="mb-2">Pagamento e Totais</h6>
         </div>
        <div class="row g-2">
          <div class="col-6"><label class="form-label mb-1">Valor Produtos (R$)</label><input id="valorTotalProdutos" name="valor_total_produtos" class="form-control" readonly></div>
          <div class="col-6"><label class="form-label mb-1">Valor Pago (R$)</label><input id="valorTotalPago" name="valor_total_pago" class="form-control" readonly></div>
          <div class="col-6"><label class="form-label mb-1">Dinheiro (R$)</label><input id="dinheiro" name="valor_dinheiro" class="form-control valor-pagamento" placeholder="0,00"></div>
          <div class="col-6"><label class="form-label mb-1">Pix (R$)</label><input id="pix" name="valor_pix" class="form-control valor-pagamento" placeholder="0,00"></div>
          <div class="col-6"><label class="form-label mb-1">Débito (R$)</label><input id="debito" name="valor_debito" class="form-control valor-pagamento" placeholder="0,00"></div>
          <div class="col-6"><label class="form-label mb-1">Crédito (R$)</label><input id="credito" name="valor_credito" class="form-control valor-pagamento" placeholder="0,00"></div>
          <div class="col-12"><label class="form-label mb-1">Desconto (R$)</label><input id="desconto" name="valor_desconto" class="form-control valor-pagamento" placeholder="0,00"></div>
          <div class="col-12"> <input hidden  id="valorTotalDevido" name="valor_total_devido" class="form-control" readonly></div>
        </div>
      </div>
    </div>
  </div>

  <div class="text-center mt-3">
    <button type="submit" id="enviarBtn" class="btn btn-dark btn-lg"><i class="bi bi-send me-1"></i>Adicionar Frete</button>
  </div>
</form>

</div>

<!-- MODAL: NOVO PRODUTO (F2) -->
<div class="modal fade" id="modalNovoProduto" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content border-0">
      <div class="modal-header">
        <h5 class="modal-title">Cadastrar novo produto</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">
        <div class="mb-2">
          <label class="form-label">Nome</label>
          <input type="text" id="novoProdutoNome" class="form-control" placeholder="Ex.: Caixa Especial">
        </div>
        <div class="mb-2">
          <label class="form-label">Valor (R$)</label>
          <input type="text" id="novoProdutoValor" class="form-control" placeholder="0,00" required>
          <div class="form-text">Use vírgula para centavos. Ex.: 15,00</div>
        </div>
        <div class="alert alert-danger d-none" id="novoProdutoErro"></div>
      </div>
      <div class="modal-footer">
        <button type="button" id="btnSalvarProduto" class="btn btn-dark">
          <span class="spinner-border spinner-border-sm me-2 d-none" id="novoProdutoSpin"></span>
          Salvar (Enter)
        </button>
      </div>
    </div>
  </div>
</div>

<script>
// Dados do WP para JS
window.DB = {
  produtos: <?php echo wp_json_encode($PRODUTOS, JSON_UNESCAPED_UNICODE); ?>,
  contatos: <?php echo wp_json_encode($CONTATOS, JSON_UNESCAPED_UNICODE); ?>
};
window.AJAX = {
  url: '<?php echo esc_js($ajax_url); ?>',
  nonceAddProd: '<?php echo esc_js($nonce_add_prod); ?>',
  nonceTelUpd:  '<?php echo esc_js($nonce_tel_upd); ?>',
  nonceDocUpd:  '<?php echo esc_js($nonce_doc_upd); ?>',
  nonceResolver:'<?php echo esc_js($nonce_resolver); ?>'
};
</script>

<script>
(function($){
  // ===== Utils =====
  const uniq=arr=>[...new Set((arr||[]).filter(Boolean).map(s=>String(s).trim()).filter(Boolean))];
  const f2br=n=>(Number(n)||0).toLocaleString('pt-BR',{minimumFractionDigits:2,maximumFractionDigits:2});
  const br2f=s=>parseFloat(String(s||'').replace(/[^\d,-]/g,'').replace(/\./g,'').replace(',','.'))||0;
  const pad2=n=>String(n).padStart(2,'0');
  const moneyMask=$el=>$el.on('input',function(){let v=this.value.replace(/\D/g,'');v=(parseFloat(v||0)/100).toFixed(2);this.value=f2br(v);calc();});
  const showOrEmpty = v => { v = String(v||'').trim(); return (v === '' || v === '0') ? '' : v; };

  function attachAC($el, list, {mapLabel=(x)=>x, onSelect=null, minLength=0}={}){
    $el.autocomplete({
      minLength, delay:0, appendTo:'body', autoFocus:true,
      source:(req,resp)=>{
        const t=String(req.term||'').toLowerCase();
        const arr=(list||[]).slice().sort((a,b)=>mapLabel(a).localeCompare(mapLabel(b),'pt-BR'));
        resp(!t?arr.map(v=>({label:mapLabel(v), value:mapLabel(v), raw:v}))
                :arr.filter(v=>mapLabel(v).toLowerCase().includes(t)).map(v=>({label:mapLabel(v), value:mapLabel(v), raw:v})));
      },
      position:{ my:'left top+6', at:'left bottom', collision:'fit' }
    }).on('focus',function(){ $(this).autocomplete('search', $(this).val()||''); })
      .on('autocompleteselect',function(_e,ui){ if(onSelect) onSelect(ui.item.raw); });
  }

  // ===== Contatos / índice por nome normalizado =====
  let contatos = (window.DB?.contatos)||[];
  function normName(s){
    s = String(s||'').trim();
    try{ s = s.normalize('NFD').replace(/[\u0300-\u036f]/g, ''); }catch(e){}
    return s.toLowerCase().replace(/\s+/g,' ').trim();
  }
  const byNorm = new Map();
  contatos.forEach(c=>{ const k = normName(c.nome); if(!byNorm.has(k)) byNorm.set(k,c); });

  function addOrUpdateContatoCache(ctt){
    // ctt: {id,nome,telefone,cpf}
    const k = normName(ctt.nome);
    byNorm.set(k, ctt);
    const idx = contatos.findIndex(x=>String(x.id)===String(ctt.id));
    if (idx>=0) contatos[idx]=ctt; else contatos.push(ctt);
    window.DB.contatos = contatos;
  }

  // ===== Estados selecionados =====
  let selRem = null;
  let selDes = null;

  // Remetente
  attachAC($('#nomeRemetente'), contatos, {
    mapLabel:(c)=>c.nome,
    onSelect:(c)=>{
      selRem = c;
      $('#remetente_id').val(c.id || '');
      $('#contatoRemetente').val(showOrEmpty(c.telefone));
      $('#cpfRemetente').val(showOrEmpty(c.cpf)); // 'cpf' carrega 'doc'
    }
  });
  function fillRemetenteByTypedName(){
    const key = normName($('#nomeRemetente').val());
    if(!key) return;
    const c = byNorm.get(key);
    if(c){
      selRem = c;
      $('#remetente_id').val(c.id || '');
      $('#contatoRemetente').val(showOrEmpty(c.telefone));
      $('#cpfRemetente').val(showOrEmpty(c.cpf));
    }
  }
  $('#nomeRemetente').on('blur', function(){
    fillRemetenteByTypedName();
    // criar contato se não existir e houver dados
    const id = $('#remetente_id').val();
    const nome = $(this).val().trim();
    const telefone = $('#contatoRemetente').val().trim();
    const doc = $('#cpfRemetente').val().trim();
    if(!id && nome && (telefone || doc)){
      resolverContato(nome, telefone, doc, (novo)=>{
        selRem = novo;
        $('#remetente_id').val(novo.id);
        addOrUpdateContatoCache(novo);
      });
    }
  });
  $('#nomeRemetente').on('keydown', e=>{ if(e.key==='Enter'){ setTimeout(fillRemetenteByTypedName,0); } });
  $('#nomeRemetente').on('input', function(){
    if (!selRem || this.value.trim() !== String(selRem.nome||'')) {
      $('#remetente_id').val('');
    }
  });

  // Destinatário
  attachAC($('#nomeDestinatario'), contatos, {
    mapLabel:(c)=>c.nome,
    onSelect:(c)=>{
      selDes = c;
      $('#destinatario_id').val(c.id || '');
      $('#contatoDestinatario').val(showOrEmpty(c.telefone));
      $('#cpfDestinatario').val(showOrEmpty(c.cpf));
    }
  });
  function fillDestByTypedName(){
    const key = normName($('#nomeDestinatario').val());
    if(!key) return;
    const c = byNorm.get(key);
    if(c){
      selDes = c;
      $('#destinatario_id').val(c.id || '');
      $('#contatoDestinatario').val(showOrEmpty(c.telefone));
      $('#cpfDestinatario').val(showOrEmpty(c.cpf));
    }
  }
  $('#nomeDestinatario').on('blur', function(){
    fillDestByTypedName();
    const id = $('#destinatario_id').val();
    const nome = $(this).val().trim();
    const telefone = $('#contatoDestinatario').val().trim();
    const doc = $('#cpfDestinatario').val().trim();
    if(!id && nome && (telefone || doc)){
      resolverContato(nome, telefone, doc, (novo)=>{
        selDes = novo;
        $('#destinatario_id').val(novo.id);
        addOrUpdateContatoCache(novo);
      });
    }
  });
  $('#nomeDestinatario').on('keydown', e=>{ if(e.key==='Enter'){ setTimeout(fillDestByTypedName,0); } });
  $('#nomeDestinatario').on('input', function(){
    if (!selDes || this.value.trim() !== String(selDes.nome||'')) {
      $('#destinatario_id').val('');
    }
  });

  // === Atualização automática de telefone/doc quando campo muda (se já tem ID) ===
  function atualizarTelefone(id, telefone, cb){
    $.post(window.AJAX.url, {
      action:'freteq_atualizar_telefone',
      nonce: window.AJAX.nonceTelUpd,
      id: id,
      telefone: telefone
    }, function(resp){
      if(resp?.success){
        cb?.(resp.data?.telefone || telefone);
      }
    }, 'json');
  }
  function atualizarDoc(id, doc, cb){
    $.post(window.AJAX.url, {
      action:'freteq_atualizar_cpf', // mantém nome, mas atualiza 'doc'
      nonce: window.AJAX.nonceDocUpd,
      id: id,
      cpf: doc
    }, function(resp){
      if(resp?.success){
        cb?.(resp.data?.cpf || doc);
      }
    }, 'json');
  }
  function resolverContato(nome, telefone, doc, cb){
    $.post(window.AJAX.url, {
      action:'freteq_resolver_contato',
      nonce: window.AJAX.nonceResolver,
      nome:nome, telefone:telefone, cpf:doc
    }, function(resp){
      if(resp?.success && resp.data){
        // normaliza payload para cache local
        const c = {
          id: resp.data.id,
          nome: resp.data.nome,
          telefone: resp.data.telefone || '',
          cpf: resp.data.cpf || ''
        };
        cb?.(c);
      }else{
        console.warn('Falha ao resolver contato', resp);
      }
    }, 'json');
  }

  // Remetente: atualizar quando o valor muda e há ID
  $('#contatoRemetente').on('blur change', function(){
    const id = $('#remetente_id').val(); if(!id) return;
    const telefone = String($(this).val()||'').trim();
    atualizarTelefone(id, telefone, (val)=>{
      if(selRem && String(selRem.id)===String(id)){ selRem.telefone = val; }
      addOrUpdateContatoCache({id, nome: $('#nomeRemetente').val().trim(), telefone: val, cpf: $('#cpfRemetente').val().trim()});
    });
  });
  $('#cpfRemetente').on('blur change', function(){
    const id = $('#remetente_id').val(); if(!id) return;
    const doc = String($(this).val()||'').trim();
    atualizarDoc(id, doc, (val)=>{
      if(selRem && String(selRem.id)===String(id)){ selRem.cpf = val; }
      addOrUpdateContatoCache({id, nome: $('#nomeRemetente').val().trim(), telefone: $('#contatoRemetente').val().trim(), cpf: val});
    });
  });

  // Destinatário: idem
  $('#contatoDestinatario').on('blur change', function(){
    const id = $('#destinatario_id').val(); if(!id) return;
    const telefone = String($(this).val()||'').trim();
    atualizarTelefone(id, telefone, (val)=>{
      if(selDes && String(selDes.id)===String(id)){ selDes.telefone = val; }
      addOrUpdateContatoCache({id, nome: $('#nomeDestinatario').val().trim(), telefone: val, cpf: $('#cpfDestinatario').val().trim()});
    });
  });
  $('#cpfDestinatario').on('blur change', function(){
    const id = $('#destinatario_id').val(); if(!id) return;
    const doc = String($(this).val()||'').trim();
    atualizarDoc(id, doc, (val)=>{
      if(selDes && String(selDes.id)===String(id)){ selDes.cpf = val; }
      addOrUpdateContatoCache({id, nome: $('#nomeDestinatario').val().trim(), telefone: $('#contatoDestinatario').val().trim(), cpf: val});
    });
  });

  // Conferente/Destino base
  const uniqList = arr => [...new Set(arr)];
  attachAC($('#nomeConferente'), uniqList(['Elissandro','Carlisson','Railson','Elias']));
  attachAC($('#destinoInput'),  uniqList(['Manaus','Codajás','Coari','Tefé','Alvarães','Uarini']));

  // ===== NOTAS FISCAIS =====
  const $listNF=$('#listNF'), $notasJSON=$('#notas_json');
  function novaLinhaNF(data={}){
    const id='nf_'+Math.random().toString(36).slice(2,8);
    const $row=$(`
      <div class="nf-row row g-2 align-items-end mb-2" data-id="${id}">
        <div class="col-3">
          <label class="form-label mb-1">Número</label>
          <input id="nf-num"  class="form-control nf-num"   value="${data.numero||''}" >
        </div>
        <div class="col-2">
          <label class="form-label mb-1">Série</label>
          <input class="form-control nf-serie" placeholder="1" value="${data.serie||''}">
        </div>
        <div class="col-3">
          <label class="form-label mb-1">Valor (R$)</label>
          <input class="form-control nf-val" placeholder="0,00" value="${data.valor?f2br(data.valor):''}">
        </div>
        <div class="col-3">
          <label class="form-label mb-1">Obs.</label>
          <input class="form-control nf-obs" placeholder="opcional" value="${data.obs||''}">
        </div>
        <div class="col-1 text-end">
          <button type="button" class="btn btn-sm btn-outline-danger del-nf"><i class="bi bi-x"></i></button>
        </div>
      </div>
    `);
    $listNF.append($row);
    return $row;
  }
  function serializeNF(){
    const arr=[];
    $listNF.find('.nf-row').each(function(){
      const $r=$(this);
      const numero=$r.find('.nf-num').val().trim();
      const serie =$r.find('.nf-serie').val().trim();
      const valor =br2f($r.find('.nf-val').val());
      const obs   =$r.find('.nf-obs').val().trim();
      if(numero || serie || valor>0 || obs) arr.push({numero,serie,valor,obs});
    });
    $notasJSON.val(JSON.stringify(arr));
    return arr;
  }
  novaLinhaNF();

  // atalhos NF / pagamento
  $(document).on('keydown', function(e){
    if(e.key==='F4'){ e.preventDefault(); const $r=novaLinhaNF(); setTimeout(()=>{ $r.find('.nf-num').focus().select(); },20); }
    if(e.key==='F6'){ e.preventDefault(); $('#dinheiro').focus().select(); }
  });
  $listNF.on('keydown','input',function(e){
    if(e.key!=='Enter') return;
    e.preventDefault();
    const $inp=$(this), $row=$inp.closest('.nf-row');
    if($inp.hasClass('nf-num'))   { $row.find('.nf-serie').focus().select(); return; }
    if($inp.hasClass('nf-serie')) { $row.find('.nf-val').focus().select(); return; }
    if($inp.hasClass('nf-val'))   { $row.find('.nf-obs').focus().select(); return; }
    if($inp.hasClass('nf-obs'))   { $('#quickProduto').focus(); return; }
  });
  $('#btnAddNF').on('click',()=>{ const $r=novaLinhaNF(); setTimeout(()=>{ $r.find('.nf-num').focus().select(); },20); });
  $listNF.on('click','.del-nf',function(){ $(this).closest('.nf-row').remove(); });

  // ===== Produtos =====
  const $quick=$('#quickProduto'), $qtd=$('#quickQtd'), $btn=$('#btnAddProduto'),
        $tbody=$('#listaProdutos');
  const itens={};
  let selected=null;
  let freq=(function(){ try{return JSON.parse(localStorage.getItem('freq_produtos')||'{}')}catch(e){return{}} })();
  const bump=n=>{const k=String(n).toLowerCase();freq[k]=(freq[k]||0)+1;localStorage.setItem('freq_produtos',JSON.stringify(freq));};

  function listaOrdenada(term=''){
    const t=String(term).toLowerCase();
    const arr=window.DB.produtos.slice().sort((a,b)=>{
      const ak=a.nome.toLowerCase(), bk=b.nome.toLowerCase();
      const fa=freq[ak]||0, fb=freq[bk]||0; if(fa!==fb) return fb-fa;
      return ak.localeCompare(bk,'pt-BR');
    });
    return t?arr.filter(p=>p.nome.toLowerCase().includes(t)):arr;
  }
  function byNameExact(n){ const k=String(n||'').toLowerCase(); return window.DB.produtos.find(p=>p.nome.toLowerCase()===k); }

  $quick.autocomplete({
    minLength:0, delay:0, appendTo:'body', autoFocus:true,
    source:(req,resp)=>{
      const lst=listaOrdenada(req.term).map(p=>({label:p.nome+' — R$ '+f2br(p.valor), value:p.nome, raw:p}));
      resp(lst);
    },
    position:{ my:'left top+6', at:'left bottom', collision:'fit' }
  }).on('focus',function(){ $(this).autocomplete('search', $(this).val()||''); })
    .on('autocompleteselect',function(_e,ui){ selected=ui.item.raw; setTimeout(()=>{ $qtd.focus().select(); },0); });

  $quick.on('keydown',function(e){
    if(e.key==='F2'){ e.preventDefault(); abrirModalNovoProduto($quick.val().trim()); return; }
    if(e.key==='Enter'){
      const $w=$quick.autocomplete('widget'); if($w.is(':visible')) return;
      e.preventDefault();
      if(!selected){
        const ex=byNameExact($quick.val());
        if(ex){ selected=ex; $qtd.focus().select(); }
        else abrirModalNovoProduto($quick.val().trim());
        return;
      }
      $qtd.focus().select();
    }
    if(e.key==='Escape'){ this.value=''; selected=null; }
  });
  $btn.on('click',function(){ if(selected){ $qtd.focus().select(); } else { $quick.focus(); $quick.autocomplete('search',$quick.val()||''); } });
  $qtd.on('keydown',function(e){ if(e.key==='Enter'){ e.preventDefault(); confirmar(); } if(e.key==='Escape'){ e.preventDefault(); selected=null; $quick.focus(); } });

  function getQtd(){ let v=parseInt($qtd.val(),10); if(!v||v<1)v=1; $qtd.val(v); return v; }
  function confirmar(){
    if(!selected){ $quick.focus(); return; }
    const q=getQtd(); const id=String(selected.id); const nome=selected.nome; const preco=Number(selected.valor)||0;
    if(!itens[id]) itens[id]={id,nome,preco:preco,quantidade:q}; else itens[id].quantidade+=q;
    bump(nome);
    renderLinha(id); syncHidden(); calc(); renderChips();
    selected=null; $quick.val('').focus(); $quick.autocomplete('search',''); $qtd.val('1');
  }
  function renderLinha(id){
    const it=itens[id]; const tot=it.preco*it.quantidade;
    let $tr=$tbody.find(`tr[data-id="${id}"]`);
    if(!$tr.length){
      $tr=$(`
        <tr data-id="${id}">
          <td class="nome"></td>
          <td class="text-center" style="width:80px"><input type="number" min="1" class="form-control form-control-sm qnt" style="width:70px"></td>
          <td class="text-end preco"></td>
          <td class="text-end total"></td>
          <td class="text-center" style="width:40px"><button type="button" class="btn btn-sm btn-outline-danger del"><i class="bi bi-x"></i></button></td>
        </tr>`).appendTo($tbody);
    }
    $tr.find('.nome').text(it.nome);
    $tr.find('.qnt').val(it.quantidade);
    $tr.find('.preco').text('R$ '+f2br(it.preco));
    $tr.find('.total').text('R$ '+f2br(tot));
  }
  $tbody.on('input','.qnt',function(){
    const id=String($(this).closest('tr').data('id')); let q=parseInt(this.value,10); if(!q||q<1)q=1;
    itens[id].quantidade=q; renderLinha(id); syncHidden(); calc();
  });
  $tbody.on('click','.del',function(){
    const id=String($(this).closest('tr').data('id')); delete itens[id]; $(this).closest('tr').remove(); syncHidden(); calc();
  });
  function syncHidden(){ const payload=Object.values(itens).map(p=>({id:p.id,nome:p.nome,preco:p.preco,quantidade:p.quantidade})); $('#produtosSelecionados').val(JSON.stringify(payload)); }

  // Chips top
  function renderChips(){
    const top=window.DB.produtos.slice().sort((a,b)=>{
      const ak=a.nome.toLowerCase(), bk=b.nome.toLowerCase();
      const fa=freq[ak]||0, fb=freq[bk]||0; if(fa!==fb) return fb-fa;
      return ak.localeCompare(bk,'pt-BR');
    }).slice(0,10);
    $('#topProdutos').empty().append(top.map(p=>{
      const $c=$(`<span class="chip"><i class="bi bi-bag"></i><span>${p.nome}</span><small class="text-muted">R$ ${f2br(p.valor||0)}</small></span>`);
      $c.on('click',()=>{ selected=p; $('#quickProduto').val(p.nome); $('#quickQtd').focus().select(); });
      return $c;
    }));
  }
  renderChips();

  // ===== Pagamento / Totais =====
  moneyMask($('#dinheiro')); moneyMask($('#pix')); moneyMask($('#debito')); moneyMask($('#credito')); moneyMask($('#desconto'));
  function calc(){
    let soma=0; Object.values(itens).forEach(p=>{ soma+=(p.preco||0)*(p.quantidade||0); });
    $('#valorTotalProdutos').val(f2br(soma));
    const dinheiro=br2f($('#dinheiro').val()), pix=br2f($('#pix').val()), deb=br2f($('#debito').val()), cre=br2f($('#credito').val()), desc=br2f($('#desconto').val());
    const pago=dinheiro+pix+deb+cre, devido=Math.max(soma-pago-desc,0);
    $('#valorTotalPago').val(f2br(pago)); $('#valorTotalDevido').val(f2br(devido));
    const tipo=$('#tipoP').val(); const ok=(tipo!=='Avista') || (Math.abs((soma-desc)-pago)<0.01); $('#enviarBtn').prop('disabled',!ok);
  }
  $('#tipoP').on('change',function(){
    const t=$(this).val();
    if(t==='Avista'){
      const d=new Date();
      $('#data_pagamento').val(`${pad2(d.getDate())}-${pad2(d.getMonth()+1)}-${d.getFullYear()} ${pad2(d.getHours())}:${pad2(d.getMinutes())}`);
      $('.valor-pagamento').prop('disabled',false).removeClass('bg-light');
    }else if(t==='Receber'){
      $('#data_pagamento').val('');
      $('.valor-pagamento').prop('disabled',true).addClass('bg-light').val('');
    }else{
      $('#data_pagamento').val('');
      $('.valor-pagamento').prop('disabled',false).removeClass('bg-light');
    }
    calc();
  }).trigger('change');

  // Enter encadeando pagamento
  const payOrder=['#dinheiro','#pix','#debito','#credito','#desconto','#enviarBtn'];
  $(document).on('keydown','.valor-pagamento',function(e){
    if(e.key==='Enter'){
      e.preventDefault();
      const i=payOrder.indexOf('#'+this.id);
      const next=payOrder[i+1]||'#enviarBtn';
      $(next).focus();
      if(next!=='#enviarBtn') $(next).select?.();
    }
  });

  // ===== Modal Produto Novo (F2) =====
const $modalNP = $('#modalNovoProduto'),
      $npNome  = $('#novoProdutoNome'),
      $npValor = $('#novoProdutoValor'),
      $npErr   = $('#novoProdutoErro'),
      $npSpin  = $('#novoProdutoSpin');

function abrirModalNovoProduto(seedName=''){
  $npErr.addClass('d-none').text('');
  $npSpin.addClass('d-none');
  $npNome.val(seedName||'');
  $npValor.val('');
  $modalNP.modal('show');
  setTimeout(()=>{ $npNome.focus(); },100);
}

function salvarNovoProduto(){
  const nome  = String($npNome.val()||'').trim();
  const valor = br2f($npValor.val());

  // valida nome
  if(!nome){
    $npErr.removeClass('d-none').text('Informe o nome.');
    $npNome.focus();
    return;
  }

  // valida valor
  if(!valor || isNaN(valor) || valor <= 0){
    $npErr.removeClass('d-none').text('Informe um valor válido.');
    $npValor.focus();
    return;
  }

  $npErr.addClass('d-none');
  $npSpin.removeClass('d-none');

  $.post(window.AJAX.url,{
      action:'adicionar_produto_frete',
      nonce: window.AJAX.nonceAddProd,
      nome:  nome,
      valor: valor
  },function(resp){
      $npSpin.addClass('d-none');
      if(resp && resp.success && resp.data){
        const novo = {
          id:    String(resp.data.id ?? resp.data.nome),
          nome:  resp.data.nome || nome,
          valor: Number(resp.data.valor) || valor
        };
        if(!window.DB.produtos.find(p=>p.id===novo.id)){
          window.DB.produtos.push(novo);
        }
        selected = novo;
        $('#quickProduto').val(novo.nome);
        $modalNP.modal('hide');
        renderChips();
        setTimeout(()=>{ $('#quickQtd').focus().select(); },150);
      }else{
        $npErr.removeClass('d-none').text(
          (resp && resp.data && resp.data.message) || 'Erro ao salvar.'
        );
      }
  },'json').fail(function(){
      $npSpin.addClass('d-none');
      $npErr.removeClass('d-none').text('Falha de comunicação.');
  });
}

$('#btnSalvarProduto').on('click', salvarNovoProduto);

$modalNP.on('shown.bs.modal', ()=>{
  $npNome.trigger('focus');
});

$modalNP.on('keydown', function(e){
  if(e.key==='Enter'){
    e.preventDefault();
    salvarNovoProduto();
  }
});


  // ======= NAVEGAÇÃO POR ENTER (principal) ======= 
  const ordemMain = ['nomeConferente','destinoInput','nomeRemetente','nomeDestinatario','nf-num','quickProduto'];
  $(document).on('keydown', function(e){
    if(e.key !== 'Enter') return;
    const $t = $(e.target);
    if ($t.closest('#wrapNF').length) return;
    if ($t.is('#quickProduto, #quickQtd')) return;
    if ($('#modalNovoProduto').is(':visible')) return;
    const id = e.target.id || '';
    const i = ordemMain.indexOf(id);
    if (i === -1) return;
    e.preventDefault();
    if (i < ordemMain.length - 1) {
      const prox = '#'+ordemMain[i+1];
      $(prox).focus();
      if ($(prox).is('input,textarea')) $(prox)[0].select?.();
    } else {
      const $nfNum = $('#listNF .nf-row:first .nf-num');
      if ($nfNum.length) { $nfNum.focus(); $nfNum[0].select?.(); }
    }
  });

  // evita submit por Enter fora dos fluxos previstos
  $('#formFrete').on('keydown', function(e){
    if (e.key === 'Enter') {
      const $t = $(e.target);
      const id = e.target.id || '';
      const inMain = ordemMain.includes(id);
      const inNF = !!$t.closest('#wrapNF').length;
      const inProduto = $t.is('#quickProduto, #quickQtd');
      const inPay = $t.hasClass('valor-pagamento');
      if (!inNF && !inProduto && !inPay && !inMain && !$t.is('textarea')) {
        e.preventDefault();
      }
    }
  });

  // ===== Submit: validações finais =====
  $('#formFrete').on('submit',function(e){
    const notas = serializeNF();
    if(notas.length===0){ e.preventDefault(); alert('⚠️ Informe ao menos uma Nota Fiscal.'); return false; }
    if($('#listaProdutos tr').length===0){ e.preventDefault(); alert('⚠️ Adicione pelo menos um produto.'); return false; }
    $('#enviarBtn').prop('disabled',true).html('<span class="spinner-border spinner-border-sm me-2"></span>Enviando…');
  });

  // Autofocus inicial
  setTimeout(()=>$('#nomeConferente').focus(),60);
})(jQuery);
</script>
















<script>
document.addEventListener("DOMContentLoaded", () => {
  // === LISTA DE CAMPOS QUE VOCÊ QUER SALVAR ===
  // Pode ser id ou name (misturado)
  const idsOuNames = [
    "transporteSelect",
    "origemSelect",
    "tipoPagamento",
    "tipoP"
    
  ];

  // Localiza os campos no formulário
  const campos = idsOuNames
    .map(chave => 
      document.getElementById(chave) || document.querySelector(`[name="${chave}"]`)
    )
    .filter(c => c); // remove null

  campos.forEach(campo => {
    const id = campo.id || campo.name;
    if (!id) return;

    // --- Restaurar valor salvo ---
    const salvo = localStorage.getItem("form_" + id);
    if (salvo !== null) {
      if (campo.type === "checkbox" || campo.type === "radio") {
        campo.checked = salvo === "true";
      } else {
        campo.value = salvo;
      }
    }

    // --- Salvar quando alterar ---
    campo.addEventListener("change", () => {
      if (campo.type === "checkbox" || campo.type === "radio") {
        localStorage.setItem("form_" + id, campo.checked);
      } else {
        localStorage.setItem("form_" + id, campo.value);
      }
    });

    // --- Salvar enquanto digita (para inputs/textarea) ---
    campo.addEventListener("input", () => {
      if (campo.type !== "checkbox" && campo.type !== "radio") {
        localStorage.setItem("form_" + id, campo.value);
      }
    });
  });
});
</script>




















<script>
document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("formFrete");

  form.addEventListener("submit", (e) => {
    let erros = [];

    // Lista de IDs obrigatórios
    const obrigatorios = [
      "nomeConferente",
      "destinoInput",
      "origemSelect",
      "tipoP",
      "transporteSelect",
      "nomeRemetente",
      "nomeDestinatario",
      
    ];

    obrigatorios.forEach(id => {
      const campo = document.getElementById(id);
      if (campo && !campo.value.trim()) {
        erros.push(campo);
        campo.classList.add("is-invalid"); // bootstrap borda vermelha
      } else if (campo) {
        campo.classList.remove("is-invalid");
      }
    });

    if (erros.length > 0) {
      e.preventDefault(); // cancela envio
      erros[0].focus();   // foca no primeiro campo vazio
      alert("⚠️ Preencha todos os campos obrigatórios antes de cadastrar.");
      return false;
    }

    // valida se tem ao menos 1 nota fiscal
    const notas = JSON.parse(document.getElementById("notas_json").value || "[]");
    if (notas.length === 0) {
      e.preventDefault();
      alert("⚠️ Informe ao menos uma Nota Fiscal.");
      return false;
    }

    // valida se tem ao menos 1 produto
    if (document.querySelectorAll("#listaProdutos tr").length === 0) {
      e.preventDefault();
      alert("⚠️ Adicione pelo menos um produto.");
      return false;
    }
  });
});
</script>



<style>


.box {
    background: #EDE7F6;
    border: 1px solid #e6e6e6;
    border-radius: 10px;
    padding: 16px;
    margin-bottom: 12px;
}
</style>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>






<!-- MODAL: Escolher impressora (QZ) -->
<div class="modal fade" id="modalEscolherImpressora" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">
          <i class="bi bi-printer me-2"></i>Escolher impressora
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">
        <div id="printerMsg" class="alert alert-info py-2 px-3 d-none"></div>

        <div id="printerError" class="alert alert-danger py-2 px-3 d-none"></div>

        <div id="printerLoading" class="text-center py-3">
          <div class="spinner-border" role="status"></div>
          <div class="small mt-2">Carregando impressoras do QZ…</div>
        </div>

        <div id="printerList" class="list-group d-none" style="max-height:280px;overflow:auto;"></div>

        <div class="form-check mt-3">
          <input class="form-check-input" type="checkbox" value="1" id="printerRemember" checked>
          <label class="form-check-label" for="printerRemember">Lembrar esta impressora</label>
        </div>
      </div>
      <div class="modal-footer">
        <button id="btnPrinterReload" type="button" class="btn btn-outline-secondary">
          Recarregar lista
        </button>
        <button id="btnPrinterCancel" type="button" class="btn btn-outline-danger" data-bs-dismiss="modal">
          Cancelar
        </button>
        <button id="btnPrinterConfirm" type="button" class="btn btn-dark" disabled>
          Imprimir e concluir
        </button>
      </div>
    </div>
  </div>
</div>


 


</body>
</html>


<?php
get_footer(); // Chama o footer.php do tema
