<?php
/**
 * Template Name: POS
 */
defined('ABSPATH') || exit;

// Evitar cache nessa página (importante pra sessão do carrinho)
if (!defined('DONOTCACHEPAGE')) define('DONOTCACHEPAGE', true);

// Limpa o carrinho silenciosamente ao carregar esta página
if (function_exists('WC') && !is_admin() && WC()->cart) {
    WC()->cart->empty_cart();
    WC()->cart->calculate_totals();
}
 
?>

<?php
/* 
Template Name: Página Simples
*/
get_header(); // Chama o header.php do tema
?>

     <?php 
        // Executa o shortcode normalmente
        echo do_shortcode('[wbtm-bus-search-form style="flix"]');
    ?>
 

 


 <script>
document.addEventListener("DOMContentLoaded", function(){
    function trocarIcones(){
        document.querySelectorAll(".fa-bus").forEach(function(el){
            el.classList.remove("fa-bus");
            el.classList.add("fa-ship");
        });
    }

    // já tenta trocar ao carregar
    trocarIcones();

    // observa mudanças no DOM (quando plugin insere elementos novos)
    const observer = new MutationObserver(function(mutations){
        trocarIcones();
    });

    observer.observe(document.body, { childList: true, subtree: true });
});
</script>







<script>
document.addEventListener("DOMContentLoaded", function(){
    function traduzirSeats(){
        document.querySelectorAll("body *").forEach(function(el){
            if(el.childNodes.length === 1 && el.textContent.trim() === "Seats Available"){
                el.textContent = "Disponíveis";
            }
        });
    }

    // já tenta traduzir ao carregar
    traduzirSeats();

    // observa mudanças no DOM (quando plugin insere elementos novos)
    const observer = new MutationObserver(function(mutations){
        traduzirSeats();
    });

    observer.observe(document.body, { childList: true, subtree: true });
});
</script>









 <script>
document.addEventListener("DOMContentLoaded", function(){
    function autoClickBotao(){
        const botao = document.querySelector('#get_wbtm_bus_details');
        if(botao){
            botao.click();
            observer.disconnect(); // para de observar depois de clicar
        }
    }

    // tenta clicar logo ao carregar
    autoClickBotao();

    // observa mudanças no DOM (caso o botão apareça depois via AJAX)
    const observer = new MutationObserver(function(mutations){
        autoClickBotao();
    });

    observer.observe(document.body, { childList: true, subtree: true });
});
</script>



<?php
get_footer(); // Chama o footer.php do tema
