 



  
<?php
/* 
Template Name: Página Simples
*/
get_header(); // chama o header.php do tema
?>

<?php date_default_timezone_set('America/Manaus');?>



 



<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">

<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciamento de Fretes</title>
    <!-- Bootstrap CSS -->
     <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.12.1/css/dataTables.bootstrap5.min.css"/>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.3.0/css/responsive.bootstrap5.min.css"/>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.3.2/css/buttons.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/select/1.3.3/css/select.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/select/1.3.3/js/dataTables.select.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

   <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>



  
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js"></script>



 
 
 
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/pt.js"></script>
 
 
  



 








    <style>




 




.ticket {
  width: 300px;
  height: auto;
  background-color: #f8f9fa;
  border: 2px dashed #000;

  border-radius: 15px;
  position: relative;
}

.ticket:before, .ticket:after {
  content: '';
  width: 15px;
  height: 15px;
  background-color: #ffffff;
  border-radius: 50%;
  position: absolute;
}

.ticket:before {
  top: 26px;
  left: -10px;
}

.ticket:after {
  top: 26px;
  right: -10px;
}



        table.dataTable thead th {
            white-space: nowrap;
        }
        table.dataTable tbody td {
            white-space: nowrap;
        }
        .filter-container {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            margin-bottom: 10px;
            background: linear-gradient(to right, #f7f7f7, #e9e9e9);
            padding: 10px;
            border-radius: 10px;
        }
        .filter-group {
            display: flex;
            flex-direction: column;
            flex: 1;
 
        }
        .filter-group label {
            margin-bottom: 5px;
            font-weight: bold;
            color: #0056b3;
        }
        .filter-group select {
            padding: 5px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            background: linear-gradient(to right, #ffffff, #e9e9e9);
        }
        .filter-group select#filter-data {
            background: linear-gradient(to right, #ffffff, #d3e0ea);
            border: 1px solid #007bff;
        }
        .dt-buttons {
            margin-bottom: 10px;
        }
        tfoot {
            font-weight: bold;
        }
        .modal {
            z-index: 1050; /* Bootstrap default modal z-index */
        }
        .modal-backdrop {
            z-index: 1040; /* Bootstrap default backdrop z-index */
        }
        /* Opcional: For�ar que o menu lateral tenha um �ndice z menor */
        #adminmenumain, #wpadminbar {
            z-index: 1;
        }
        .loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 20px;
            height: 20px;
            border: 3px solid #ccc;
            border-top: 3px solid #000;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            transform: translate(-50%, -50%);
        }
        @keyframes spin {
            0% { transform: translate(-50%, -50%) rotate(0deg); }
            100% { transform: translate(-50%, -50%) rotate(360deg); }
        }
        .loading-container {
            position: relative;
        }
        .loading-container .loading {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            z-index: 10;
        }
        .loading-container.loading .loading {
            display: block;
        }
        .status-item {
            padding: 10px 20px;
            border-radius: 0px ;
            color: white;
            font-weight: bold;
            display: inline-block;
            text-align: center;
            width: 100%;
        }
        .total-faturado {
            background-color: #28a745; /* Verde */
        }
        .total-desconto {
            background-color: #007bff; /* Azul claro */
        }
        .total-lancados {
            background-color: #0056b3; /* Azul escuro */
        }
        .total-volumes {
            background-color: #ffc107; /* Amarelo */
            color: black;
        }
        .total-receber {
            background-color: #dc3545; /* Vermelho */
        }
        .total-pagamento {
            background-color: #adb5bd; /* Cinza */
            color: #0056b3;
        }
        .status-item2 {
            display: flex;
            align-items: center;
            border: 1px solid #ddd;
            border-radius: 0px 40px 40px 0px;
            height: 68px; /* Ajuste conforme necess�rio */
            padding: 0;
            margin-bottom: 20px; /* Espa�amento entre cards */
            background: aliceblue;
        }
        .status-item2 .icon-background {
            background-color: #fff; /* Fundo azul */
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            height: 100%;
            width: 100px; /* Largura do �cone */
            border-right: 1px solid #ddd;
        }
        .status-item2 .icon-size {
            width: 50px; /* Ajuste conforme necess�rio */
            height: auto;
        }
        .status-item2 .text-container {
            padding-left: 10px;
        }
        .status-indicator {
            display: inline-block;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
            vertical-align: middle;
        }
        .status-pagamento-avista {
            background-color: #28a745;
        }
        .status-faturado-devendo {
            background-color: #dc3545;
        }
        .status-a-receber-devendo {
            background-color: #dc3545;
        }
        .status-quitado {
            background-color: #dc3545;
        }
        .status-text {
            display: inline-block;
            vertical-align: middle;
        }


body {
    overflow-x: hidden;
}


    </style>
</head>
<body>




 



    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>


 


    <div class="container-xxl">
        <br>
   <div class="d-flex justify-content-between align-items-center mb-1">
<h5 class="mb-0"><i class="fas fa-money-bill"></i> FLUXO DE CAIXA -  ENTRADAS E SA&Iacute;DAS</h5>


   
</div>
 

      <br>   <div class="status-container row">
           



     <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-lancados-container">
                    <span class="status-item  total-desconto    ">Entradas Geral<br> <span id="total-entrada">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>






            <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-receber-container ">
                    <span class="status-item total-receber  ">Sa&iacute;das Avulsas <br><span id="total-avulso">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>




 <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-faturado-container" >
                    <span class="status-item total-faturado"  > Saldo Atual <br><span id="total-saldo">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>



 

 <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-encomenda-container" >
                    <span class="status-item total-faturado  " style="background-color: floralwhite;color: #000;"> Encomendas <br><span id="total-encomenda">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>


             <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-fretes-container" >
                    <span class="status-item total-faturado  " style="background-color: floralwhite;color: #000;"> Fretes <br><span id="total-fretes1">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>
            

 <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-passagens-container" >
                    <span class="status-item total-faturado  " style="background-color: floralwhite;color: #000;"> Passagens <br><span id="total-passagens">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>





 

          
       
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="status-item2 loading-container">
                    <div class="icon-background" id="total-dinheiro-container">
                        <img src="<?php echo get_bloginfo('template_directory');?>/real.png" alt="Dinheiro" class="icon-size">
                    </div>
                    <div class="text-container">
                        <span>DINHEIRO</span><br>
                        <div class="loading"></div>
                        <span id="total-dinheiro">R$ 0,00</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="status-item2 loading-container">
                    <div class="icon-background" id="total-pix-container">
                        <img src="<?php echo get_bloginfo('template_directory');?>/pix.png" alt="Pix" class="icon-size">
                    </div>
                    <div class="text-container">
                        <span>PIX</span><br>
                        <div class="loading"></div>
                        <span id="total-pix">R$ 0,00</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="status-item2 loading-container">
                    <div class="icon-background" id="total-debito-container">
                        <img src="<?php echo get_bloginfo('template_directory');?>/debito.png" alt="D�bito" class="icon-size">
                    </div>
                    <div class="text-container">
                        <span>D&Eacute;BITO</span><br>
                        <div class="loading"></div>
                        <span id="total-debito">R$ 0,00</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="status-item2 loading-container">
                    <div class="icon-background" id="total-credito-container">
                        <img src="<?php echo get_bloginfo('template_directory');?>/bandeiras.jpg" alt="Cr�dito" class="icon-size">
                    </div>
                    <div class="text-container">
                        <span>CR&Eacute;DITO</span><br>
                        <div class="loading"></div>
                        <span id="total-credito">R$ 0,00</span>
                    </div>
                </div>
            </div>

</div>



      
        <div class="filter-container">
            <div class="col-md-4 col-lg-4 filter-group">
                <label for="filter-data" class="form-label">Periodo:</label>
                <div class="loading-container" id="filter-data-container">




                    
<input type="text" id="filter-data2" class="form-control" value="Per&iacute;odo">


 
 
  


 

<script>
    // Inicializando o Flatpickr
    flatpickr("#filter-data2", {
        mode: "range",
        locale: "pt", // Definindo para portugu�s
        dateFormat: "d/m/Y", // Formato de data dd/mm/yyyy
        onClose: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 2) {
                // Formatar as datas em dois formatos diferentes
                var data_inicial_br = flatpickr.formatDate(selectedDates[0], "d/m/Y"); // Formato dd/mm/yyyy
                var data_final_br = flatpickr.formatDate(selectedDates[1], "d/m/Y");
                var data_inicial_int = flatpickr.formatDate(selectedDates[0], "Y-m-d"); // Formato yyyy-mm-dd
                var data_final_int = flatpickr.formatDate(selectedDates[1], "Y-m-d");

                // Obtendo a home URL do WordPress atrav�s do PHP, sem incluir a barra adicional no final
                var homeUrl = "<?php echo esc_url(home_url('filtro-caixa')); ?>";

                // Cria��o da URL com os par�metros de data
                var url = new URL(homeUrl);
                url.searchParams.set('data_inicial_br', data_inicial_br);
                url.searchParams.set('data_final_br', data_final_br);
                url.searchParams.set('data_inicial_int', data_inicial_int);
                url.searchParams.set('data_final_int', data_final_int);

                // Redirecionar para a URL com as datas selecionadas
                window.location.href = url.toString();
            }
        }
    });
</script>




                    <div class="loading"></div>
                </div>
            </div>
            <div class="col-md-4 col-lg-4 filter-group">
                <label for="filter-status" class="form-label">M&oacute;dulos:</label>
                <select id="filter-status" class="form-select">
                    <option value="">Todos</option>
                </select>
            </div>


     <div class="col-md-4 col-lg-4 filter-group">
                <label for="filter-status" class="form-label">Tipo:</label>
                <select id="filter-tipo" class="form-select">
                    <option value="">Todos</option>
                </select>
            </div>



            

  


            <div class="col-md-4 col-lg-4 filter-group">
                <label for="filter-cidade" class="form-label">Operador:</label>
                <select id="filter-cidade" class="form-select">
                    <option value="">Todos</option>
                </select>
            </div>
           
        </div>
        <div class="table-responsive mt-2">
            <?php
            date_default_timezone_set('America/Manaus');
            ?>
            <br>
               <?php

 
// Capturar as datas da URL
$data_inicial = isset($_GET['data_inicial_int']) ? $_GET['data_inicial_int'] : '';
$data_final   = isset($_GET['data_final_int'])   ? $_GET['data_final_int']   : '';

if ($data_inicial && $data_final) {
    // Se as datas vierem pela URL, usa elas
    $data_inicial_convertida = (new DateTime($data_inicial))->format('Y-m-d 00:00:00');
    $data_final_convertida   = (new DateTime($data_final))->format('Y-m-d 23:59:59');
} else {
    // Últimos 2 dias (ontem e hoje)
    $data_inicial_convertida = (new DateTime('-0 day'))->format('Y-m-d 00:00:00');
    $data_final_convertida   = (new DateTime('today'))->format('Y-m-d 23:59:59');
}

 





// Ajustar os argumentos da consulta para obter todos os posts dos tipos desejados sem data_query
$args2 = array(
    'post_type' => array('frete', 'encomendas', 'passagem', 'avulsos'),
    'posts_per_page' => -1,
    'post_status' => 'publish' // apenas publicados

);

// Executar a consulta
$the_query = new WP_Query($args2);

if ($the_query->have_posts()) : ?>
<p>Exibindo registros de pagamentos de: <?php echo date('d/m/Y', strtotime($data_inicial_convertida)); ?> at&eacute; <?php echo date('d/m/Y', strtotime($data_final_convertida)); ?></p>    


<table id="example" class="table table-striped table-bordered custom-datatable" style="width:100%; font-size: 13px;">
        <thead>
            <tr>
<th>N&ordm;</th>

 <th>Emiss&atilde;o</th>

                <th>Operador</th>

                <th>Data Pagamento</th>
<th>M&oacute;dulo</th>
<th>Tipo</th>

                <th>Dinheiro</th>
                <th>Pix</th>
                <th>D&eacute;bito</th>
                <th>Cr&eacute;dito</th>

 
   
<th>Hist&oacute;rico</th>

            </tr>
        </thead>
        <tbody>
      <?php
function formatar_valor($valor) {
    // Mantido por compatibilidade; abaixo usamos br_to_float nas somas
    $valor = str_replace(['.', ','], '', $valor);
    if (is_numeric($valor)) $valor = $valor / 100; else $valor = 0;
    return number_format($valor, 2, ',', '.');
}

if (!function_exists('br_to_float')) {
    function br_to_float($v) {
        if ($v === null || $v === '') return 0.0;
        $v = (string)$v;
        $v = str_replace('.', '', $v);
        $v = str_replace(',', '.', $v);
        return (float)$v;
    }
}

$plurals = [
    'frete'      => 'Fretes',
    'encomendas' => 'Encomendas',
    'passagem'   => 'Passagens',
    'avulsos'    => 'Avulsos',
    'avulso'     => 'Avulsos',
];

/**
 * Converte string de data para timestamp.
 * Aceita: ISO, "dd/mm/yyyy [hh:mm[:ss]]", e ACF datepicker "Ymd".
 */
function parse_date_to_ts($s) {
    if (!$s) return false;
    $s = trim((string)$s);

    // tenta ISO / formatos reconhecidos pelo strtotime
    $ts = strtotime($s);
    if ($ts !== false) return $ts;

    // dd/mm/yyyy [hh:mm[:ss]]
    if (preg_match('#^(\d{2})/(\d{2})/(\d{4})(?:\s+(\d{2}):(\d{2})(?::(\d{2}))?)?$#', $s, $m)) {
        $d=$m[1]; $mo=$m[2]; $y=$m[3];
        $H=$m[4] ?? '00'; $i=$m[5] ?? '00'; $sec=$m[6] ?? '00';
        $iso = sprintf('%04d-%02d-%02d %02d:%02d:%02d', $y, $mo, $d, $H, $i, $sec);
        $ts = strtotime($iso);
        if ($ts !== false) return $ts;
    }

    // ACF datepicker (Ymd)
    if (preg_match('#^(\d{4})(\d{2})(\d{2})$#', $s, $m)) {
        $iso = sprintf('%04d-%02d-%02d 00:00:00', $m[1], $m[2], $m[3]);
        $ts = strtotime($iso);
        if ($ts !== false) return $ts;
    }

    return false;
}

/**
 * Busca a melhor "data de pagamento" para PASSAGEM.
 */
function get_passagem_payment_ts($post_id) {
    $candidatas = [
        'data_pagamento_passagem',
        'data_pagamento',
        'passagem_data_pagamento',
        'data_compra',
        'dt_pagamento',
        'data', // às vezes salvam genérico
    ];
    foreach ($candidatas as $k) {
        $v = get_post_meta($post_id, $k, true);
        $ts = parse_date_to_ts($v);
        if ($ts !== false) return $ts;
    }

    // fallback: CPT relacionado
    $rel = get_post_meta($post_id, 'origem_destino_passagem', true);
    if ($rel) {
        $v = get_post_meta($rel, 'data_pagamento', true);
        $ts = parse_date_to_ts($v);
        if ($ts !== false) return $ts;
    }

    // último recurso: post_date
    return (int) get_post_time('U', true, $post_id);
}

// ===== Loop principal =====
while ($the_query->have_posts()) : $the_query->the_post();

    $encomenda_id    = get_the_ID();
    $data_emissao    = get_the_date('d/m/Y H:i');
    $autor_encomenda = get_the_author_meta('display_name', get_post_field('post_author', $encomenda_id));
    $post_type       = get_post_type($encomenda_id);

    // ===== MÓDULO (usa tipocat; se vazio, cai pro post_type) =====
    $tipocat_meta = strtolower(trim((string) get_post_meta($encomenda_id, 'tipocat', true)));
    if ($tipocat_meta !== '') {
        $modulo_label = $plurals[$tipocat_meta] ?? ucfirst($tipocat_meta);
    } else {
        $modulo_label = $plurals[$post_type] ?? ucfirst($post_type);
    }

    // ===== Histórico padrão =====
    $historico = 'Origem ->> Destino: <br>' .
        (get_post_meta($encomenda_id, 'origem', true) ?: '-') . ' ->> ' .
        (get_post_meta($encomenda_id, 'destino', true) ?: '-');

    $data_pagamento = '';
    $tipo           = 'Entrada'; // por padrão, NÃO-avulsos são Entrada
    $pgto_ts        = null;      // pode ser setado por tipo
    $dinheiro = 0.00; $pix = 0.00; $debito = 0.00; $credito = 0.00;

    if ($post_type === 'frete') {

        if (have_rows('financeiro', $encomenda_id)) {
            while (have_rows('financeiro', $encomenda_id)) : the_row();
                $raw = get_sub_field('financeiro_data_criacao');
                $raw = $raw ? str_replace(',', '', $raw) : '';
                $data_pagamento = $raw ? date('Y-m-d H:i', strtotime($raw)) : '';
                break;
            endwhile;
        }

        // Totais do frete por forma
        $dinheiro = br_to_float(get_post_meta($encomenda_id, 'total_dinheiro_frete', true));
        $pix      = br_to_float(get_post_meta($encomenda_id, 'total_pix_frete', true));
        $debito   = br_to_float(get_post_meta($encomenda_id, 'total_debito_frete', true));
        $credito  = br_to_float(get_post_meta($encomenda_id, 'total_credito_frete', true));

        $transporte_id = get_post_meta($encomenda_id, 'transporte', true);
        $historico     = $transporte_id ? get_the_title($transporte_id) : 'Nenhum transporte encontrado';

    } elseif ($post_type === 'passagem') {

        // Data de pagamento robusta
        $pgto_ts = get_passagem_payment_ts($encomenda_id);
        $data_pagamento = $pgto_ts ? date('Y-m-d H:i:s', $pgto_ts) : '';

        // Histórico pelo relacionamento (se houver)
        $origem_destino_id = get_post_meta($encomenda_id, 'origem_destino_passagem', true);
        if ($origem_destino_id) {
            $historico = 'Origem ->> Destino: <br>' . get_the_title($origem_destino_id);
        }

        // Formas de pagamento (várias chaves possíveis)
        $dinheiro = br_to_float(
            get_post_meta($encomenda_id, 'dinheiro', true)
            ?: get_post_meta($encomenda_id, 'valor_dinheiro', true)
        );
        $pix = br_to_float(
            get_post_meta($encomenda_id, 'pix', true)
            ?: get_post_meta($encomenda_id, 'valor_pix', true)
        );
        $debito = br_to_float(
            get_post_meta($encomenda_id, 'debito', true)
            ?: get_post_meta($encomenda_id, 'valor_debito', true)
        );
        $credito = br_to_float(
            get_post_meta($encomenda_id, 'credito', true)
            ?: get_post_meta($encomenda_id, 'valor_credito', true)
        );

        // No seu fluxo, passagem sempre é ENTRADA
        $tipo = 'Entrada';

    } elseif ($post_type === 'encomendas') {

        $data_pagamento = get_post_meta($encomenda_id, 'data_pagamento', true);
        $data_pagamento = $data_pagamento ? date('Y-m-d H:i', strtotime($data_pagamento)) : '';

        $historico = 'Origem ->> Destino: <br>' .
            (get_post_meta($encomenda_id, 'origem', true) ?: '-') . ' ->> ' .
            (get_post_meta($encomenda_id, 'destino', true) ?: '-');

        $dinheiro = br_to_float(get_post_meta($encomenda_id, 'valor_dinheiro', true));
        $pix      = br_to_float(get_post_meta($encomenda_id, 'valor_pix', true));
        $debito   = br_to_float(get_post_meta($encomenda_id, 'valor_debito', true));
        $credito  = br_to_float(get_post_meta($encomenda_id, 'valor_credito', true));

    } elseif ($post_type === 'avulsos') {

        $data_pagamento = get_post_meta($encomenda_id, 'data_pagamento_avulso', true);
        $data_pagamento = $data_pagamento
            ? date('Y-m-d H:i', strtotime($data_pagamento))
            : get_the_date('Y-m-d H:i', $encomenda_id);

        // Só AVULSOS tem Entrada/Saida
        $tipo_meta = strtolower(trim((string) get_post_meta($encomenda_id, 'tipo', true)));
        $tipo = ($tipo_meta === 'entrada') ? 'Entrada' : 'Saida';

        $historico = get_post_meta($encomenda_id, 'historico', true);

        $dinheiro = br_to_float(get_post_meta($encomenda_id, 'avulso_dinheiro', true));
        $pix      = br_to_float(get_post_meta($encomenda_id, 'avulso_pix', true));
        $debito   = br_to_float(get_post_meta($encomenda_id, 'avulso_debito', true));
        $credito  = br_to_float(get_post_meta($encomenda_id, 'avulso_credito', true));
    }

    $total = $dinheiro + $pix + $debito + $credito;

    $dinheiro_fmt = number_format($dinheiro, 2, ',', '.');
    $pix_fmt      = number_format($pix,      2, ',', '.');
    $debito_fmt   = number_format($debito,   2, ',', '.');
    $credito_fmt  = number_format($credito, 2, ',', '.');

    // Período (já definido acima no seu arquivo)
    $inicio_ts = strtotime($data_inicial_convertida);
    $fim_ts    = strtotime($data_final_convertida);

    // $pgto_ts pode ter sido definido (passagem). Se não, tenta parsear da string.
    if (!isset($pgto_ts) || !$pgto_ts) {
        $pgto_ts = parse_date_to_ts($data_pagamento);
    }

    if ($pgto_ts !== false && $pgto_ts >= $inicio_ts && $pgto_ts <= $fim_ts) :
        $data_pagamento_formatada = date('d/m/Y H:i', $pgto_ts); ?>
        <tr>
            <td><?= esc_html($encomenda_id); ?></td>
            <td><?= esc_html($data_emissao); ?></td>
            <td><?= esc_html($autor_encomenda); ?></td>
            <td><?= esc_html($data_pagamento_formatada); ?></td>

            <td><?= esc_html($modulo_label); ?></td>  <!-- Módulo -->
            <td><?= esc_html($tipo); ?></td>          <!-- Tipo -->

            <td><?= esc_html($dinheiro_fmt); ?></td>
            <td><?= esc_html($pix_fmt); ?></td>
            <td><?= esc_html($debito_fmt); ?></td>
            <td><?= esc_html($credito_fmt); ?></td>

            <td><?= $historico; ?></td>
        </tr>
    <?php endif;

endwhile;
?>


        </tbody>
    </table>

<?php else : ?>
    <p>Nenhuma encomenda encontrada.</p>
<?php endif; ?>

<?php wp_reset_postdata(); ?>





        </div>
    </div>

    <!-- Modal para Adicionar Novo Post -->
    <div class="modal fade" id="addPostModal" tabindex="-1" aria-labelledby="addPostModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document" style="max-width: 96%;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <iframe id="addPostIframe" src="" width="100%" height="600px" frameborder="0"></iframe>
                </div>
            </div>
        </div>
    </div>
 



 <script>
jQuery(function($){

  /* === Conversão e formatação BRL (use em TUDO) === */
  function brlToFloat(v){
    if (v == null) return 0;
    v = String(v).trim()
      // remove pontos de milhar: ponto seguido de 3 dígitos
      .replace(/\.(?=\d{3}(?:\D|$))/g,'')
      // remove qualquer coisa que não seja dígito, vírgula, ponto, sinal
      .replace(/[^\d,.-]/g,'')
      // vírgula decimal → ponto
      .replace(',', '.');
    const n = parseFloat(v);
    return isNaN(n) ? 0 : n;
  }
  const fmtBRL = n => Number(n||0).toLocaleString('pt-BR',{style:'currency',currency:'BRL'});
  const norm   = t => (t||'').toString().normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim();

  /* === Totais dos cartões (usa brlToFloat) === */
  function updateTotals(api){

    // helper: soma colunas de valores da linha
    const somaValores = (row) =>
      brlToFloat(row[6]) + brlToFloat(row[7]) + brlToFloat(row[8]) + brlToFloat(row[9]);

    // Totais por tipo (Entrada geral) e Saída (somente Avulsos)
    const totalEntrada = (function(){
      let t = 0;
      api.rows({search:'applied'}).data().each(function(row){
        if ((row[5]||'').toString().trim() === 'Entrada'){
          t += somaValores(row);
        }
      });
      return t;
    })();

    const totalSaidaAvulso = (function(){
      let t = 0;
      api.rows({search:'applied'}).data().each(function(row){
        const modulo = (row[4]||'').toString().trim();
        const tipo   = (row[5]||'').toString().trim();
        if (modulo === 'Avulsos' && tipo === 'Saida'){
          t += somaValores(row);
        }
      });
      return t;
    })();

    const totalSaldo = totalEntrada - totalSaidaAvulso;

    // Totais por módulo (somente Entradas) — aceita sing./plural
    function totalModulo(nomes){
      if (!Array.isArray(nomes)) nomes = [nomes];
      let t = 0;
      api.rows({search:'applied'}).data().each(function(row){
        const modulo = (row[4]||'').toString().trim();
        const tipo   = (row[5]||'').toString().trim();
        if (nomes.includes(modulo) && tipo === 'Entrada'){
          t += somaValores(row);
        }
      });
      return t;
    }

    const totalEncomenda = totalModulo(['Encomenda','Encomendas']);
    const totalPassagem  = totalModulo(['Passagem','Passagens']);
    const totalFrete     = totalModulo(['Frete','Fretes']);

    // Totais por forma (somente Entradas)
    let d=0,p=0,db=0,cr=0;
    api.rows({search:'applied'}).data().each(function(row){
      if ((row[5]||'').toString().trim() === 'Entrada'){
        d  += brlToFloat(row[6]);
        p  += brlToFloat(row[7]);
        db += brlToFloat(row[8]);
        cr += brlToFloat(row[9]);
      }
    });

    // Atualiza a UI
    $('#total-entrada').html(fmtBRL(totalEntrada));
    $('#total-avulso').html(fmtBRL(totalSaidaAvulso));
    $('#total-saldo').html(fmtBRL(totalSaldo));

    $('#total-encomenda').html(fmtBRL(totalEncomenda));
    $('#total-passagens').html(fmtBRL(totalPassagem));
    $('#total-fretes1').html(fmtBRL(totalFrete));

    $('#total-dinheiro').html(fmtBRL(d));
    $('#total-pix').html(fmtBRL(p));
    $('#total-debito').html(fmtBRL(db));
    $('#total-credito').html(fmtBRL(cr));
  }

  /* === DataTable === */
  const table = $('#example').DataTable({
    order: [[0,'desc']],
    dom: 'Bfrtip',
    buttons: [{
      text: '<i class="fas fa-file-alt"></i> Relatório ',
      action: function (e, dt) {
        // Filtros para cabeçalho do relatório
        const filtroModulo   = $('#filter-status option:selected').text() || 'Todos';
        const filtroTipo     = $('#filter-tipo option:selected').text()   || 'Todos';
        const filtroOperador = $('#filter-cidade option:selected').text() || 'Todos';

        // Período (capta do <p> renderizado pelo PHP)
        let periodo = '';
        const pTxt = $('p:contains("Exibindo registros de pagamentos de:")').text();
        if (pTxt) periodo = pTxt.replace(/^.*?:\s*/,'');

        // Agregadores
        const formaEntrada = { dinheiro:0, pix:0, debito:0, credito:0 };
        const formaSaida   = { dinheiro:0, pix:0, debito:0, credito:0 };
        const entradasPorModulo = {};
        let totalEntradas = 0;
        let avulsoEntrada = 0;
        let avulsoSaida   = 0;
        const saidasDetalhe = [];

        // Percorre linhas filtradas
        dt.rows({search:'applied'}).every(function(){
          const row     = this.data();
          const id      = (row[0]||'').toString().trim();
          const operador= (row[2]||'').toString().trim();
          const dpgto   = (row[3]||'').toString().trim();
          const modulo  = (row[4]||'').toString().trim();
          const rawTipo = norm(row[5]); // "Entrada" | "Saida"
          const tipo    = (modulo === 'Avulsos') ? rawTipo : 'Entrada';

          const dinh = brlToFloat(row[6]);
          const pix  = brlToFloat(row[7]);
          const deb  = brlToFloat(row[8]);
          const cred = brlToFloat(row[9]);
          const soma = dinh + pix + deb + cred;
          const hist = (row[10]||'').toString().trim();

          if (tipo === 'Entrada'){
            totalEntradas += soma;
            entradasPorModulo[modulo] = (entradasPorModulo[modulo]||0) + soma;

            formaEntrada.dinheiro += dinh;
            formaEntrada.pix      += pix;
            formaEntrada.debito   += deb;
            formaEntrada.credito  += cred;

            if (modulo === 'Avulsos') avulsoEntrada += soma;
          }

          if (modulo === 'Avulsos' && tipo === 'Saida'){
            avulsoSaida += soma;

            formaSaida.dinheiro += dinh;
            formaSaida.pix      += pix;
            formaSaida.debito   += deb;
            formaSaida.credito  += cred;

            saidasDetalhe.push({ id, dpgto, modulo, operador, dinh, pix, deb, cred, historico: hist });
          }
        });

        const totalSaidas = avulsoSaida;
        const saldoGeral  = totalEntradas - totalSaidas;

        // HTML do relatório
        const css = `
          <style>
            *{box-sizing:border-box}
            body{font-family:Arial,Helvetica,sans-serif; margin:20px; font-size:13px}
            h1,h2,h3{margin:10px 0}
            table{border-collapse:collapse; width:100%; margin:10px 0}
            th,td{border:1px solid #000; padding:6px; vertical-align:top}
            th{background:#f2f2f2}
            .grid{display:grid; grid-template-columns: 1fr 1fr; gap:16px}
            .muted{color:#555}
            .badge{display:inline-block; padding:2px 8px; border-radius:6px; background:#eee; margin-left:6px}
            .nowrap{white-space:nowrap}
            .right{text-align:right}
            .center{text-align:center}
            .mb16{margin-bottom:16px}
            .box{border:1px solid #000; padding:10px; border-radius:8px}
            @media print { .noprint{display:none !important} body{margin:0} }
          </style>
        `;

        const head = `
          <div class="mb16">
            <h1 class="center">Relatório  do Caixa</h1>
            <div class="center muted">
              ${periodo ? `<div><strong>Período:</strong> ${periodo}</div>` : ``}
              <div><strong>Filtros</strong>: Módulo: ${filtroModulo} | Tipo: ${filtroTipo} | Operador: ${filtroOperador}</div>
            </div>
          </div>
        `;

        const resumoGeral = `
          <div class="grid">
            <div class="box">
              <h3>Resumo Geral</h3>
              <table>
                <tr><th>Descrição</th><th class="right">Valor</th></tr>
                <tr><td>Total de Entradas</td><td class="right">${fmtBRL(totalEntradas)}</td></tr>
                <tr><td>Total de Saídas</td><td class="right">${fmtBRL(totalSaidas)}</td></tr>
                <tr><td><strong>Total</strong></td><td class="right"><strong>${fmtBRL(saldoGeral)}</strong></td></tr>
              </table>
            </div>
            <div class="box">
              <h3>Totais por Forma de Pagamento</h3>
              <table>
                <tr>
                  <th></th>
                  <th class="right">Dinheiro</th>
                  <th class="right">Pix</th>
                  <th class="right">Débito</th>
                  <th class="right">Crédito</th>
                  <th class="right">Total</th>
                </tr>
                <tr>
                  <td><strong>Entradas</strong></td>
                  <td class="right">${fmtBRL(formaEntrada.dinheiro)}</td>
                  <td class="right">${fmtBRL(formaEntrada.pix)}</td>
                  <td class="right">${fmtBRL(formaEntrada.debito)}</td>
                  <td class="right">${fmtBRL(formaEntrada.credito)}</td>
                  <td class="right"><strong>${fmtBRL(formaEntrada.dinheiro+formaEntrada.pix+formaEntrada.debito+formaEntrada.credito)}</strong></td>
                </tr>
                <tr>
                  <td><strong>Saídas</strong></td>
                  <td class="right">${fmtBRL(formaSaida.dinheiro)}</td>
                  <td class="right">${fmtBRL(formaSaida.pix)}</td>
                  <td class="right">${fmtBRL(formaSaida.debito)}</td>
                  <td class="right">${fmtBRL(formaSaida.credito)}</td>
                  <td class="right"><strong>${fmtBRL(formaSaida.dinheiro+formaSaida.pix+formaSaida.debito+formaSaida.credito)}</strong></td>
                </tr>
              </table>
            </div>
          </div>
        `;

        // Resumo por módulo (Entradas)
        let linhasEntradasModulo = '';
        Object.keys(entradasPorModulo).sort().forEach(m => {
          linhasEntradasModulo += `
            <tr>
              <td>${m || '-'}</td>
              <td class="right"><strong>${fmtBRL(entradasPorModulo[m])}</strong></td>
            </tr>
          `;
        });
        const porModuloEntradas = `
          <div class="box">
            <h3>Resumo por Módulo (Entradas)</h3>
            <table>
              <tr><th>Módulo</th><th class="right">Entradas</th></tr>
              ${linhasEntradasModulo || `<tr><td colspan="2" class="center muted">Sem dados</td></tr>`}
            </table>
          </div>
        `;

        // Lista de Saídas (somente Avulsos)
        let linhasSaidas = '';
        saidasDetalhe
          .sort((a,b) => (a.dpgto||'').localeCompare(b.dpgto||'')) // ordena por data
          .forEach(s => {
            linhasSaidas += `
              <tr>
                <td class="nowrap">${s.id}</td>
                <td class="nowrap">${s.dpgto}</td>
                <td>${s.modulo}</td>
                <td>${s.operador}</td>
                <td class="right">${fmtBRL(s.dinh)}</td>
                <td class="right">${fmtBRL(s.pix)}</td>
                <td class="right">${fmtBRL(s.deb)}</td>
                <td class="right">${fmtBRL(s.cred)}</td>
                <td>${s.historico || ''}</td>
              </tr>
            `;
          });
        const listaSaidas = `
          <div class="box">
            <h3>Lista de Saídas (Avulsos) <span class="badge">${saidasDetalhe.length}</span></h3>
            <table>
              <tr>
                <th>ID</th><th>Data Pagamento</th><th>Módulo</th><th>Operador</th>
                <th class="right">Dinheiro</th><th class="right">Pix</th><th class="right">Débito</th><th class="right">Crédito</th>
                <th>Histórico</th>
              </tr>
              ${linhasSaidas || `<tr><td colspan="9" class="center muted">Não há saídas no filtro atual.</td></tr>`}
            </table>
          </div>
        `;

        // Abre a janela do relatório
        const w = window.open('', '_blank');
        w.document.open();
        w.document.write(`
          <html lang="pt-BR">
            <head><meta charset="utf-8"><title>Relatório  do Caixa</title>${css}</head>
            <body>
              <div class="noprint" style="text-align:right; margin-bottom:10px;">
                <button onclick="window.print()">Imprimir</button>
                <button onclick="window.close()">Fechar</button>
              </div>
              ${head}${resumoGeral}${porModuloEntradas}${listaSaidas}
            </body>
          </html>
        `);
        w.document.close();
      }
    }],
    select: true,
    responsive: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      sLengthMenu: "_MENU_ resultados por página",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sSearch: "Pesquisar",
      oPaginate: { sNext: "Próximo", sPrevious: "Anterior" }
    },
    drawCallback: function(){ updateTotals(this.api()); }
  });

  /* === Filtros: só popula se o select existir na página === */
  function populateFilterOptions(columnIndex, filterSelector){
    const $sel = $(filterSelector);
    if (!$sel.length) return; // não existe na página
    const columnData = table.column(columnIndex).data().unique().sort();
    $sel.empty().append('<option value="">Todos</option>');
    columnData.each(function(d){ $sel.append('<option value="'+d+'">'+d+'</option>'); });
  }
  function addColumnFilter(columnIndex, filterSelector){
    const $sel = $(filterSelector);
    if (!$sel.length) return;
    $sel.on('change', function(){
      table.column(columnIndex).search($(this).val()).draw();
    });
  }

  // Ajuste os índices conforme suas colunas
  populateFilterOptions(5, '#filter-tipo');     // Tipo
  populateFilterOptions(4, '#filter-status');   // Módulo
  populateFilterOptions(2, '#filter-cidade');   // Operador

  addColumnFilter(5, '#filter-tipo');
  addColumnFilter(4, '#filter-status');
  addColumnFilter(2, '#filter-cidade');

}); // jQuery ready
</script>




    <style>
        div.dataTables_wrapper div.dataTables_filter {
            text-align: right;
            display: yes;
        }
    </style>



 
 
 <style>
    .offcanvas-end {
      width: 50%; /* Define a largura como 50% da tela */
    }
    .offcanvas-body {
      padding: 0; /* Remove o padding para que o iframe ocupe todo o espa�o */
    }
    iframe {
      width: 100%;
      height: 100vh; /* Ajusta a altura do iframe para caber na viewport */
      border: none;
    }


    #adminmenuwrap {

 
      z-index: 2;
    }




iframe {
 
    margin-top: -30px;

}

.disabled-btn {
    opacity: 0.5;
    cursor: not-allowed;
}


  </style>
 
 

 <script>
     

            $('#filter-data').on('change', function() {
                var periodo = $(this).val();
                var url = new URL(window.location.href);
                url.searchParams.set('periodo', periodo);
                window.location.href = url.toString();
            });
       



////////////PAGAMENTO


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
 
 
 <!-- Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="paymentModalLabel">Inserir Valores de Pagamento</h5>
      </div>
      <div class="modal-body">
        <input type="hidden" id="selected-ids">

        <div class="form-group">
          <label for="cash-amount">Valor em Dinheiro:</label>
          <input type="text" class="form-control payment-input" id="cash-amount" name="valor_dinheiro" placeholder="0,00">
        </div>
        <div class="form-group">
          <label for="pix-amount">Valor em Pix:</label>
          <input type="text" class="form-control payment-input" id="pix-amount" name="valor_pix" placeholder="0,00">
        </div>
        <div class="form-group">
          <label for="debit-amount">Valor em D�bito:</label>
          <input type="text" class="form-control payment-input" id="debit-amount" name="valor_debito" placeholder="0,00">
        </div>
        <div class="form-group">
          <label for="credit-amount">Valor em Cr�dito:</label>
          <input type="text" class="form-control payment-input" id="credit-amount" name="valor_credito" placeholder="0,00">
        </div>
        <div class="form-group">
          <label for="discount-amount">Valor de Desconto:</label>
          <input type="text" class="form-control payment-input" id="discount-amount" name="valor_desconto" placeholder="0,00">
        </div>



        <p>Total a pagar: R$ <span id="total-amount">0,00</span></p>
        <p>Total informado: R$ <span id="input-total">0,00</span></p>
        <p>Total faltando: R$ <span id="missing-total">0,00</span></p>
        <p id="error-message" style="color: red; display:none;">O total informado n�o corresponde ao total a pagar!</p>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="confirm-payment">Confirmar Pagamento</button>
      </div>
    </div>
  </div>
</div>




<script type="text/javascript">
    var homeurl = "<?php echo esc_url( home_url( '/' ) ); ?>";
</script>

 






 


 
</body>
</html>
<?php
get_footer(); // chama o footer.php do tema
