<?php
/* 
Template Name: Página Simples
*/
get_header(); // chama o header.php do tema
?>
 

 
   
 <?php
// Desativa exibi��o de erros na tela
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);

// Seu c�digo PHP abaixo...
?>



<?php
// Verifique se os par�metros 'encomendaid' e 'entrega' est�o presentes na URL
if ( isset( $_GET['encomendaid'] ) && !empty( $_GET['encomendaid'] ) && isset( $_GET['ent'] ) && $_GET['ent'] === 'ok' ) {
    // Pega o valor do 'encomendaid' e converte para inteiro por seguran�a
    $encomenda_id = intval( $_GET['encomendaid'] );

    // Defina o novo valor do campo personalizado 'status'
    $novo_status = 'Entregue'; // ou o valor que voc� deseja

    // Atualiza o campo personalizado 'status' para o post com o ID correspondente
    update_post_meta( $encomenda_id, 'status', $novo_status );

    // Opcional: voc� pode exibir uma mensagem de confirma��o ou redirecionar para uma p�gina espec�fica
      //echo 'Status da encomenda atualizado com sucesso.';
} else {
    // Caso os par�metros n�o estejam corretos, voc� pode exibir uma mensagem de erro
     // echo 'Par�metros inv�lidos.';
}
?>




<?php
// Verifica se o ID da encomenda est� presente na URL
if (isset($_GET['encomendaid'])) {
    $encomenda_id = intval($_GET['encomendaid']);

    // Obt�m o post com o ID da encomenda
    $encomenda_post = get_post($encomenda_id);

    if ($encomenda_post) {
        // Data de emiss�o
        $data_emissao = get_the_date('d/m/Y H:i', $encomenda_post);
        $data_emissao2 = get_the_date('d/m/y', $encomenda_post);


        // Autor da encomenda
        $autor_encomenda = get_the_author_meta('display_name', $encomenda_post->post_author);

        // Obt�m os meta dados da encomenda
// Recupera o ID armazenado no campo 'transporte'
$transporte_id = get_post_meta($encomenda_id, 'transporte', true);

// Verifica se existe um ID e obt�m o t�tulo do post
if (!empty($transporte_id)) {
    $transporte_titulo = get_the_title($transporte_id);
} else {
    $transporte_titulo = 'T�tulo n�o encontrado';
}

 


        $nome_remetente = get_post_meta($encomenda_id, 'nome_remetente', true);
        $contato_remetente = get_post_meta($encomenda_id, 'contato_remetente', true);
        $cpf_remetente = get_post_meta($encomenda_id, 'cpf_remetente', true);
        $nome_destinatario = get_post_meta($encomenda_id, 'nome_destinatario', true);
        $contato_destinatario = get_post_meta($encomenda_id, 'contato_destinatario', true);
        $cpf_destinatario = get_post_meta($encomenda_id, 'cpf_destinatario', true);
        $origem = get_post_meta($encomenda_id, 'origem', true);
        $destino = get_post_meta($encomenda_id, 'destino', true);
        $tipodepagamento = get_post_meta($encomenda_id, 'tipodepagamento', true);
        $valor_total_produtos = get_post_meta($encomenda_id, 'valor_total_produtos', true);
        $valor_total_pago = get_post_meta($encomenda_id, 'valor_total_pago', true);
        $valor_total_devido = get_post_meta($encomenda_id, 'valor_total_devido', true);
        $valor_desconto = get_post_meta($encomenda_id, 'valor_desconto', true);
        $setor = get_post_meta($encomenda_id, 'setor', true);

 


        $tipoP = get_post_meta($encomenda_id, 'tipoP', true);
        $data_pagamento = get_post_meta($encomenda_id, 'data_pagamento', true);
 
        $obs = get_post_meta($encomenda_id, 'obs', true);

$contato_remetente_numeros = preg_replace('/\D/', '', $contato_remetente);
$contato_destinatario_numeros = preg_replace('/\D/', '', $contato_destinatario);





        
       // Produtos selecionados
$produtos_json = get_post_meta($encomenda_id, 'produtos_selecionados', true);
$produtos_selecionados = json_decode($produtos_json, true);

// Preparar a lista de produtos e calcular a quantidade total
$lista_produtos = [];
$quantidade_total = 0; // Vari�vel para armazenar a quantidade total

if (is_array($produtos_selecionados)) {
    foreach ($produtos_selecionados as $produto_id => $detalhes) {
        $quantidade = isset($detalhes['quantidade']) ? $detalhes['quantidade'] : 0;
        $preco = isset($detalhes['preco']) ? $detalhes['preco'] : 0;

        // Obter o t�tulo do post pelo ID
        $titulo_produto = get_the_title(intval($produto_id));

        // Montar linha formatada com t�tulo no lugar do ID
        $lista_produtos[] = "{$quantidade} x {$titulo_produto} (R$ {$preco})";

        // Acumula a quantidade total
        $quantidade_total += $quantidade;
    }
}

// Criar uma string �nica com todos os produtos, separados por <br>
$produtos = implode("<br>", $lista_produtos);

// Exibir, se quiser:
// echo "Lista de Produtos:<br>" . $produtos . "<br>";
// echo "Quantidade Total de Produtos: " . $quantidade_total;

        // Exibir a lista de produtos e a quantidade total
         //echo "Lista de Produtos:<br>" . $produtos_unicos . "<br>";
         //echo "Quantidade Total de Produtos: " . $quantidade_total;
    }
}



?>




<?php
// Define os argumentos para obter o primeiro post do tipo 'empresa'
$args = array(
    'p' => $transporte,
    'post_type' => 'empresa',    // Tipo de post
    'posts_per_page' => 1,       // Limita o n�mero de posts para obter apenas o primeiro
    'orderby' => 'date',         // Ordena pela data de publica��o
    'order' => 'ASC'             // Pega o mais antigo primeiro; use 'DESC' para pegar o mais recente
);

// Obt�m o primeiro post do tipo 'empresa'
$empresa_post = get_posts($args);

if (!empty($empresa_post)) {
    $empresa_post = $empresa_post[0]; // Como estamos limitando para apenas 1 post, pegamos o primeiro do array

    // Exemplo de como obter os dados do post
    $empresa_id = $empresa_post->ID;
    $titulo = get_the_title($empresa_id);
    $cnpj = get_post_meta($empresa_id, 'cnpj', true);
    $razao = get_post_meta($empresa_id, 'razao', true);
    $endereco = get_post_meta($empresa_id, 'endereco', true);
    $urlgps = get_post_meta($empresa_id, 'urlgps', true);

 
 
    
}
?>




<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Etiqueta para Impress�o</title>

    <!-- CSS do Bootstrap -->
 
    <!-- CSS Personalizado -->
    <style>
        .container {
            padding: 10px;
    text-transform: uppercase;
        }

        .box {
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            border: 2px solid #000;
        }

        /* Estilo da Etiqueta */
        #etiqueta {
            background-color: #fff;
            text-align: center;
            padding: 5px;
            border: 0px solid #000;
        }

        #etiqueta h5 {
            margin-bottom: 5px;
            font-weight: bold;
            font-size: 1.5em;
        }

        #etiqueta .info-block {
            border: 1px solid #000;
            padding: 2px;
            margin: 2px;
            height: 100px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        #etiqueta .info-content {
            font-weight: bold;
            color: #000;
            width: 100%;
            text-align: center;
            white-space: nowrap;
            overflow: hidden;
        }

        /* Ajustar tamanho da fonte automaticamente para caber no espa�o */
        .fit-text {
            font-size: 2.2em;
            transition: font-size 0.2s ease;
        }

        .print-btn {
            margin-bottom: 10px;
            display: block;
            width: 100%;
            font-weight: bold;
        }

        /* Garantir que as bordas e o design sejam impressos */
        @media print {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }

            body {
                margin: 0;
                padding: 0;
            }

            #etiqueta {
                border: 2px solid #000 !important;
                padding: 10px !important;
            }

            .print-btn {
                display: none; /* N�o imprimir o bot�o de impress�o */
            }

            #comprovante {
                border: 2px dashed #000;
                font-family: 'Courier New', Courier, monospace;
                background-color: #f9f9f9;
            }
        }

        .row {
            --bs-gutter-x: 0rem !important;
        }

        /* Estilo do Comprovante */
        #comprovante {
            border: 2px dashed #000;
            font-family: 'Courier New', Courier, monospace;
            background-color: #f9f9f9;
            padding: 10px;
        }

        /* Centralizar a parte inicial do comprovante */
        #comprovante .header-comprovante {
            text-align: center;
            margin-bottom: 20px;
        }

        #comprovante p {
            font-size: 1.1em;
            margin: 5px 0;
            text-align: left; /* Deixar o resto alinhado � esquerda */
        }

        /* Borda separando o comprovante e a etiqueta */
        .border-separator {
            border-left: 2px solid #000;
            height: 100%;
margin-left: 40px;
        }

    </style>
</head>
<body>
    <div class="container">
        <div class="row">
            <!-- Comprovante -->
            <div class="col-md-6 col-12">
                <!-- Bot�o de impress�o acima do comprovante -->
            

 
 


                
                <div id="comprovante">
                    <!-- Parte do comprovante a ser centralizada -->
                    <div class="header-comprovante" >
 <h5 style="text-align: center;" >




 <?php
// ID do post de transporte salvo na encomenda
$transporte_id = get_post_meta($encomenda_id, 'transporte', true);

if ($transporte_id) {

    // Pega o título do transporte
    $titulo_transporte = get_the_title($transporte_id);

    // Pega todos os campos personalizados do transporte
    $cnpj         = get_post_meta($transporte_id, 'cnpj', true);
    $razao        = get_post_meta($transporte_id, 'razao', true);
    $endereco     = get_post_meta($transporte_id, 'endereco', true);
    $urlgps       = get_post_meta($transporte_id, 'urlgps', true);
    $escalas      = get_post_meta($transporte_id, 'escalas', true);
    $telefone_1   = get_post_meta($transporte_id, 'telefone_1', true);
    $telefone_2   = get_post_meta($transporte_id, 'telefone_2', true);
    $telefone_pix = get_post_meta($transporte_id, 'telefone_pix', true);

 

}  
?>



<?php
 

// Atribuindo partes
$nome   = $titulo_transporte;
$cnpj   = $cnpj;
$contato = $telefone_1;
$contato2 = $telefone_2;
$contato3 =  $telefone_pix;


$pix    = $telefone_pix; 
 

// Exibindo com estilos
echo "<div style='font-size: 26px; font-weight: bold;'>$nome</div>";
echo "<div style='margin-top: 5px;'> $cnpj</div>";
echo "<div> $contato</div>";
echo "<div> $contato2</div>"; 
 
 
echo "<div>$pix</div>";
echo "<div>$pix2</div>";
?>





 
 </div>                    <!-- Resto do conte�do do comprovante, alinhado � esquerda -->
                    <hr style="border: 1px dashed #000;">



<p style="text-align: center; font-size: 18px; font-weight: bold;">
  <b style="font-size: 25px; font-weight: 1200; color: #000;">NOTA DE ENCOMENDA</b>


 
</p>

<p><strong><span style=" font-size: 30px;">N&ordm; </span></strong> <span style=" font-size: 30px; border: 2px dashed #000; border-radius: 50%; padding: 5px; display: inline-block; font-family: 'Comic Sans MS', cursive; text-align: center;"><?php echo $encomenda_id; ?></span></p>

                    <p><strong>Transporte:</strong><?php echo  $transporte_titulo ;?> </p>



                    <p><strong>Remetente:</strong> <?php echo esc_html($nome_remetente); ?></p>

                    <p><strong>Destinat&aacute;rio:</strong> <?php echo esc_html($nome_destinatario); ?></p>



                    <p><strong>Emissao:</strong> <?php echo $data_emissao; ?></p>
<?php if (!empty($data_pagamento)) : ?>
    <p><strong>Data de Pagamento:</strong> <?php echo $data_pagamento; ?></p>
<?php endif; ?>


                    <p><strong>Tipo:</strong><?php echo $tipoP; ?> </p>

                    <p><strong>Trecho:</strong> <?php echo esc_html($origem); ?> / <?php echo esc_html($destino); ?></p>
                    <hr style="border: 1px dashed #000;">

                    
                    <p><strong>Setor:</strong> <?php echo esc_html($setor); ?> </p>
                    <hr style="border: 1px dashed #000;">

                    <p><strong>Descri&ccedil;&atilde;o dos Produtos:</strong> <br><?php echo $produtos; ?> </p>




                    <p><strong>Quantidade:</strong> <?php echo $quantidade_total; ?></p>
                    <hr style="border: 1px dashed #000;">

                    <p><strong>Observa&ccedil;&atilde;o:</strong> <br><?php echo $obs; ?> </p>
                    <hr style="border: 1px dashed #000;">

                    <p><strong>Total:</strong> R$ <?php echo esc_html($valor_total_produtos); ?></p>
                    <p><strong>Desconto:</strong> R$ <?php echo $valor_desconto; ?></p>
                    <p><strong>Pago:</strong> R$ <?php echo esc_html($valor_total_pago); ?></p>
                    <p><strong>Devedor:</strong> R$ <?php echo esc_html($valor_total_devido); ?></p>
                    <p><strong>Operador:</strong> <?php echo $autor_encomenda; ?></p>
                </div>
            </div>

            <!-- Borda separadora -->
            <div class="col-md-1 d-none d-md-block">
                <div class="border-separator"></div>
            </div>

            <!-- Etiqueta -->
            <div class="col-md-5 col-12">
                <!-- Bot�o de impress�o acima da etiqueta -->
                
                <div class="box" id="etiqueta">
                    <h5><?php echo  $transporte_titulo ;?> - <?php echo $data_emissao2;?></h5>
                    <div class="row">
                        <div class="col-8">
                            <div class="info-block">
                                <div class="info-title">Destinat&aacute;rio</div>
                                <div class="info-content fit-text" id="destinatario"><?php
$nomes = explode(' ', $nome_destinatario);
echo $nome_formatado = $nomes[0];

 
?>
</div>




 <div class="info-title"><?php echo $nomes[1]; ?> <?php echo $nomes[2]; ?></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="info-block">
                                <div class="info-title">N:</div>
                                <div class="info-content fit-text" id="numero"><?php echo $encomenda_id; ?></div>
                            </div>
                        </div>
                        <div class="col-8">
                            <div class="info-block">
                                <div class="info-title">Destino</div>
                                <div class="info-content fit-text" id="destino"><?php echo esc_html($destino); ?></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="info-block">
                                <div class="info-title">Volume</div>
                                <div class="info-content fit-text" id="volume">1/<?php echo $quantidade_total; ?></div>
                            </div>
                        </div>

 


                    </div>
                </div>

    <button class="btn btn-primary print-btn"  id="com" ">
    <i class="bi bi-printer-fill"></i> Imprimir Comprovante
</button>



<button class="btn btn-secondary print-btn"  id="btnEtiqueta" >
    <i class="bi bi-tag-fill"></i> Imprimir Etiqueta
</button>

 








<button class="btn btn-success print-btn" onclick="enviarMensagem('55<?php echo $contato_remetente_numeros;?>')">
    <i class="bi bi-whatsapp"></i> Enviar para Remetente
</button>




<button class="btn btn-success print-btn" onclick="enviarMensagem('55<?php echo $contato_destinatario_numeros;?>')">
    <i class="bi bi-whatsapp"></i> Enviar para Destinatario
</button>














 <!-------------------------------------------------
   1. SELECTS DE IMPRESSORAS + BOT�ES
-------------------------------------------------->
<div class="row g-2 mb-3">
  <div class="col-sm">
    <label class="form-label fw-bold">Comprovante</label>
    <select id="selComprovante" class="form-select"></select>
  </div>

  <div class="col-sm">
    <label class="form-label fw-bold">Etiqueta</label>
    <select id="selEtiqueta" class="form-select"></select>
  </div>

  <div class="col-auto d-flex align-items-end">
    <button id="btnSalvarImp" class="btn btn-primary">Salvar</button>
  </div>
</div>




<script>
        // Fun��o para enviar o n�mero via AJAX
        function enviarMensagem(numero) {
            // Cria os dados do POST
            const dados = new URLSearchParams();
            dados.append('numero', numero);

            // Envia a requisi��o via fetch
            fetch('', {
                method: 'POST',
                body: dados,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
            })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                    alert(`Enviado com Sucesso`);
                    }  
                })
                .catch(error => {
                    alert(`Enviado com Sucesso`);
                });
        }
    </script>
 
 






 








<!-- Adicione o link do Bootstrap Icons ao seu HTML -->
             </div>

        </div>


    </div>

    <!-- JavaScript para impress�o -->
     











<script>
function printDiv(divId) {
    let printContent = '';

    if (divId === 'etiqueta') {
        let quantidadeTotal = <?php echo $quantidade_total; ?>; // Valor do PHP para o numerador
        let etiquetaContent = '';

        for (let i = 1; i <= quantidadeTotal; i++) {
            // Gerar o valor correto do volume
            let volumeContent = `${i}/${quantidadeTotal}`;
            let originalContent = document.getElementById(divId).innerHTML;

            // Substituir o valor do volume no conte�do original
            let updatedContent = originalContent.replace(
                /<div class="info-content fit-text" id="volume">.*?<\/div>/,
                `<div class="info-content fit-text" id="volume">${volumeContent}</div>`
            );

            etiquetaContent += updatedContent; // Adicionar o conte�do atualizado ao conte�do final
        }
        printContent = etiquetaContent;
    } else if (divId === 'comprovante') {
        // Obter o conte�do do comprovante
        printContent = document.getElementById(divId).innerHTML;
    }

    // Criar um iframe oculto para a impress�o
    let printFrame = document.createElement('iframe');
    printFrame.style.position = 'absolute';
    printFrame.style.width = '0';
    printFrame.style.height = '0';
    printFrame.style.border = 'none';

    // Adicionar o iframe ao body
    document.body.appendChild(printFrame);

    let frameDoc = printFrame.contentWindow || printFrame.contentDocument;
    if (frameDoc.document) frameDoc = frameDoc.document;

    frameDoc.open();
    frameDoc.write(`
        <html>
        <head>
            <title>Imprimir</title>
             <style>
                * {
                    -webkit-print-color-adjust: exact !important;
                    print-color-adjust: exact !important;
                    color-adjust: exact !important;
                    text-transform: uppercase;
                }
                .box {
                    padding: 10px;
                    border-radius: 5px;
                    border: 0px solid #000;
                    text-align: center;
                }
                .info-block {
                    border: 1px solid #000;
                    padding: 2px;
                    margin: 2px;
                    height: 100px;
                    display: flex;
                    flex-direction: column;
                    justify-content: center;
                    align-items: center;
                }
                .info-content {
                    font-size: 2em;
                    font-weight: bold;
                    color: #000;
                    white-space: nowrap;
                    text-align: center;
                    overflow: hidden;
                }
                .fit-text {
                    font-size: 2em;
                    max-width: 100%;
                }
                .row {
                    --bs-gutter-x: 0rem !important;
                }
                .print-btn {
                    display: none;
                }
                #comprovante .header-comprovante {
                    text-align: center;
                    margin-bottom: 20px;
                }
            </style>
        </head>
        <body>
            ${printContent}
        </body>
        </html>
    `);
    frameDoc.close();

    // Iniciar a impress�o
    printFrame.contentWindow.focus();
    printFrame.contentWindow.print();

    // Remover o iframe ap�s a impress�o
    printFrame.addEventListener('onafterprint', () => {
        printFrame.remove();
    });
}

// Ajustar o tamanho da fonte para caber no bloco
function ajustarFonte() {
    const elements = document.querySelectorAll('.fit-text');
    elements.forEach(el => {
        let fontSize = 3;
        while (el.scrollWidth > el.offsetWidth) {
            fontSize -= 0.1;
            el.style.fontSize = fontSize + 'em';
            if (fontSize < 1.8) break; // Limite m�nimo para o tamanho da fonte
        }
    });
}

// Executar ajuste de fonte quando a p�gina carregar
window.onload = ajustarFonte;
</script>




















<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
 
     <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        #mensagemFeedback {
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
            display: none; /* Inicialmente escondido */
        }
    </style>
</head>
<body>

    <!-- Bot�o para enviar a mensagem -->

    <!-- Mensagem de feedback -->
    <div id="mensagemFeedback">Mensagem enviada com sucesso!</div>

    <!-- Modal de Confirma��o -->
    <!-- Modal de Confirma��o -->
<div class="modal fade" id="confirmacaoModal" tabindex="-1" aria-labelledby="confirmacaoModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="confirmacaoModalLabel">Confirmar Envio</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Selecione para quem deseja enviar a mensagem:</p>
                <div class="mb-3">
                    <label for="enviarPara" class="form-label">Envio para o WhatsApp:</label>
                    <select class="form-select" id="enviarPara">
 
                        <option value="remetente">Remetente</option>
                        <option value="destinatario">Destinat&aacute;rio</option>
                         <!-- <option value="todos">Ambos</option> -->
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success" id="confirmarEnvio">Confirmar</button>
            </div>
        </div>
    </div>
</div>






     





 

 
























 
 






  

<?php
 

  
/**
 * Fun��o para remover acentos de um texto
 *
 * @param string $texto
 * @return string
 */
function remover_acentos($texto) {
    return preg_replace(
        [
            "/(\u00e1|\u00e0|\u00e3|\u00e2|\u00e4)/",
            "/(\u00c1|\u00c0|\u00c3|\u00c2|\u00c4)/",
            "/(\u00e9|\u00e8|\u00ea|\u00eb)/",
            "/(\u00c9|\u00c8|\u00ca|\u00cb)/",
            "/(\u00ed|\u00ec|\u00ee|\u00ef)/",
            "/(\u00cd|\u00cc|\u00ce|\u00cf)/",
            "/(\u00f3|\u00f2|\u00f5|\u00f4|\u00f6)/",
            "/(\u00d3|\u00d2|\u00d5|\u00d4|\u00d6)/",
            "/(\u00fa|\u00f9|\u00fb|\u00fc)/",
            "/(\u00da|\u00d9|\u00db|\u00dc)/",
            "/(\u00f1)/",
            "/(\u00d1)/",
            "/(\u00e7)/",
            "/(\u00c7)/"
        ],
        explode(" ", "a A e E i I o O u U n N c C"),
        $texto
    );
}

// Exemplo: certifica-se de que as vari�veis usadas abaixo estejam definidas ou receba o valor correto.
$titulo                = isset($titulo) ? sanitize_text_field($titulo) : '';
$valor_total_devido    = isset($valor_total_devido) ? sanitize_text_field($valor_total_devido) : '';
$valor_desconto        = isset($valor_desconto) ? sanitize_text_field($valor_desconto) : '';
$produtos              = isset($produtos) ? wp_kses_post($produtos) : '';
$nome                  = isset($nome) ? $nome : '';
$encomenda_id          = isset($encomenda_id) ? $encomenda_id : '';
$nome_remetente        = isset($nome_remetente) ? $nome_remetente : '';
$origem                = isset($origem) ? $origem : '';
$destino               = isset($destino) ? $destino : '';
$tipodepagamento       = isset($tipodepagamento) ? $tipodepagamento : '';
$valor_total_produtos  = isset($valor_total_produtos) ? $valor_total_produtos : '';
$valor_total_pago      = isset($valor_total_pago) ? $valor_total_pago : '';
$quantidade_total      = isset($quantidade_total) ? $quantidade_total : '';
$obs                   = isset($obs) ? $obs : '';

// Montar a mensagem com os detalhes da encomenda
$mensagem  = "*$nome*\n";
$mensagem .= "Comprovante de Encomenda\n";
$mensagem .= "*N: $encomenda_id* \n\n";

$mensagem .= "\u{1F4E4} *Transporte:* $transporte_titulo \n";



$mensagem .= "\u{1F4E4} *Remetente:* $nome_remetente\n";
$mensagem .= "\u{1F4E4} *Destinatario:* $nome_destinatario\n";

$mensagem .= "\u{1F69A} *Origem:* $origem\n";
$mensagem .= "\u{1F4CD} *Destino:* $destino\n";
//$mensagem .= "\u{1F4B3} *Tipo de Pagamento:* $tipodepagamento\n";
$mensagem .= "\u{1F4B8} *Valor Total Produtos:* R$ $valor_total_produtos\n";
$mensagem .= "\u{2705} *Valor Total Pago:* R$ $valor_total_pago\n";
$mensagem .= "\u{2757} *Valor Total Devido:* R$ $valor_total_devido\n";
$mensagem .= "\u{1F516} *Valor Desconto:* R$ $valor_desconto\n\n";

// Converte as quebras de linha (se houver) de <br> para \n
$produtosFormatado = str_replace('<br>', "\n", $produtos);
$mensagem .= "\u{1F6CD} *Encomenda:*\n$produtosFormatado\n";
$mensagem .= "\u{1F4E6} *Quantidade de Encomenda:* $quantidade_total\n\n";
$mensagem .= "*Obs:* $obs\n\n";

// Adicionando o link na mensagem e removendo acentos
//$link = esc_url(home_url('/ecomprovante/?encomendaid=')) . $encomenda_id;
//$mensagem .= remover_acentos("Clique no link abaixo para mais detalhes:\n");
//$mensagem .= "$link\n\n";

 
?>




<?php
// Define o cabe�alho para resposta JSON apenas se for uma solicita��o AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se o n�mero est� presente no POST
    if (!isset($_POST['numero'])) {
        echo json_encode([
            'status'  => 'error',
            'message' => 'N�mero de destino n�o fornecido.'
        ]);
        exit;
    }

    // N�mero de destino recebido do POST
    $numerodestino = $_POST['numero'];

    // Certifica-se de que o n�mero � v�lido
    if (!preg_match('/^\d+$/', $numerodestino)) {
        echo json_encode([
            'status'  => 'error',
            'message' => 'N�mero de destino inv�lido.'
        ]);
        exit;
    }

 

    // URL do servi�o
    $nodeurl = 'https://evolution.geratec.com.br/message/sendText/anam';

    // Dados para envio via CURL
    $data = [
        'number' => $numerodestino,
        'text'   => $mensagem,
    ];

    // Inicializar e configurar o CURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'apikey: 3651109E2DFD-4DDE-9F51-18EA16C1A922'
    ]);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_URL, $nodeurl);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    // Executa a requisi��o
    $response = curl_exec($ch);

    // Fecha a conex�o CURL
    curl_close($ch);

     
    exit;
}
?>



 
 <?php
 ;
$autoPrintComprovante = $autoPrintComprovante ?? true;
$autoPrintEtiqueta    = (!isset($_GET['ent']) || $_GET['ent'] !== 'ok');
?>
 

<!-- Bootstrap s� para estilo dos selects/bot�es -->
 
<!-- Bibliotec�a QZ Tray -->
<script src="<?php echo get_template_directory_uri(); ?>/qz/js/qz-tray.js"></script>
 
 

 
 
 
 





   



<script>
// ======================================================
// 1. FLAGS DE AUTO-PRINT (vindas do PHP)
// ======================================================
const AUTO_PRINT_COMPROVANTE = <?php echo json_encode($autoPrintComprovante ?? true); ?>;
const AUTO_PRINT_ETIQUETA    = <?php
  $autoPrintEtiqueta = !isset($_GET['ent']) || $_GET['ent'] !== 'ok';
  echo json_encode($autoPrintEtiqueta);
?>;

// ======================================================
// 2. SEGURAN�A QZ-TRAY
// ======================================================
qz.security.setCertificatePromise((res, rej) => {
  fetch("<?php echo get_template_directory_uri(); ?>/qz/digital-certificate.txt",
        { cache:"no-store" })
    .then(r => r.ok ? res(r.text()) : rej("Erro certificado"));
});
qz.security.setSignatureAlgorithm("SHA512");
qz.security.setSignaturePromise(req => (res, rej) => {
  fetch("<?php echo get_template_directory_uri(); ?>/qz/sign-message.php?request="
        + encodeURIComponent(req), { cache:"no-store" })
    .then(r => r.ok ? res(r.text()) : rej("Erro assinatura"));
});

// ======================================================
// 3. SELECT DE IMPRESSORAS + PERSIST�NCIA
// ======================================================
const LS_COMP = "printer_comprovante";
const LS_ETIQ = "printer_etiqueta";

async function popularSelects() {
  await qz.websocket.connect();
  try {
    const lista = await qz.printers.find();             // todas as impressoras
    const selC  = document.getElementById("selComprovante");
    const selE  = document.getElementById("selEtiqueta");
    [selC, selE].forEach(sel => sel.innerHTML = "");
    lista.forEach(p => { selC.add(new Option(p, p)); selE.add(new Option(p, p)); });
    selC.value = localStorage.getItem(LS_COMP) || selC.options[0]?.value;
    selE.value = localStorage.getItem(LS_ETIQ) || selE.options[0]?.value;
  } finally { qz.websocket.disconnect(); }
}
document.getElementById("btnSalvarImp").addEventListener("click", () => {
  localStorage.setItem(LS_COMP, document.getElementById("selComprovante").value);
  localStorage.setItem(LS_ETIQ, document.getElementById("selEtiqueta").value);
  alert("Impressoras salvas!");
});

// ======================================================
// 4. CONFIGS DAS IMPRESSORAS (din�micas)
// ======================================================
function cfgComprovante() {
  const nome = localStorage.getItem(LS_COMP) || "EPSON TM-T20 Receipt5";
  return qz.configs.create(nome, { copies:1, encoding:"CP860", margins:0, rasterize:false });
}
function cfgEtiqueta() {
  const nome = localStorage.getItem(LS_ETIQ) || "ELGIN L42PRO FULL";
  return qz.configs.create(nome, { copies:1, encoding:"UTF-8" });
}
const ZPL_CALIBRAR = "^XA^JUS^JUA^MNW^MTT^PR4^XZ";   // opcional

// ======================================================
// 5. GERAR COMPROVANTE (ESC/POS)
// ======================================================
function gerarComprovante(){
  const esc='\x1B', gs='\x1D', init=esc+'@';
  const align={L:esc+'a\0',C:esc+'a\1',R:esc+'a\2'};
  const bold={ON:esc+'E\1',OFF:esc+'E\0'};
  const underline={ON:esc+'-\1',OFF:esc+'-\0'};
  const size=n=>gs+'!'+String.fromCharCode(n);
  const cut=esc+'i', HR=()=>"-".repeat(42)+"\n";
  const pad=(l,v)=>l.padEnd(13,' ') + ": " + v + "\n";

  /* ---- dados vindos do PHP ---- */
  const empresa      ="<?php echo addslashes($nome); ?>";
  const cnpj         ="<?php echo addslashes($cnpj); ?>";
  const tel1         ="<?php echo addslashes($contato); ?>";
  const tel2         ="<?php echo addslashes($contato2); ?>";
  const chavePix     ="<?php echo addslashes($pix); ?>";
  const numEnvio     ="<?php echo addslashes($encomenda_id); ?>";
  const remetente    ="<?php echo addslashes($nome_remetente); ?>";
  const destinatario ="<?php echo addslashes($nome_destinatario); ?>";
  const emissao      ="<?php echo $data_emissao; ?>";
  const pagamento    ="<?php echo addslashes($data_pagamento); ?>";
  const tipo         ="<?php echo addslashes($tipoP); ?>";
  const trecho       ="<?php echo addslashes($origem.' / '.$destino); ?>";
  const obs          ="<?php echo addslashes($obs); ?>";
  const qtd          ="<?php echo addslashes($quantidade_total); ?>";
  const total        ="<?php echo addslashes($valor_total_produtos); ?>";
  const desconto     ="<?php echo addslashes($valor_desconto); ?>";
  const pago         ="<?php echo addslashes($valor_total_pago); ?>";
  const devedor      ="<?php echo addslashes($valor_total_devido); ?>";
  const operador     ="<?php echo addslashes($autor_encomenda); ?>";
  const itensRaw     = `<?php echo trim(preg_replace('/\s+/', ' ', strip_tags($produtos))); ?>`;

  const itens=[], re=/(\d+\s*[xX]\s*[^0-9]+)/g; let m;
  while((m=re.exec(itensRaw))!==null) itens.push(m[1].trim());
  if(!itens.length) itens.push(...itensRaw.split(/[,;]+/).map(s=>s.trim()).filter(Boolean));

  return init +
    align.C+size(17)+empresa+"\n"+
    size(0)+cnpj+"\n"+
    `FONE: ${tel1}\nFONE: ${tel2}\nCHAVE PIX: ${chavePix}\n\n`+
    HR()+"COMPROVANTE DE ENCOMENDA\n"+HR()+"\n"+
    align.L+bold.ON+underline.ON+size(17)+"N� "+numEnvio+"\n"+
    bold.OFF+underline.OFF+size(0)+"\n"+
    pad("Transporte",empresa)+
    pad("Remetente",remetente)+
    pad("Destinatario",destinatario)+
    pad("Emissao",emissao)+
    (pagamento?pad("Pagamento",pagamento):"")+
    pad("Tipo",tipo)+
    pad("Trecho",trecho)+
    HR()+"Descricao dos Produtos:\n"+itens.join("\n")+"\n"+
    `Qtd total: ${qtd}\n`+HR()+
    "Observacao:\n"+obs+"\n"+HR()+
    align.R+
    `TOTAL     : R$ ${total.padStart(9,' ')}\n`+
    `DESCONTO  : R$ ${desconto.padStart(9,' ')}\n`+
    `PAGO      : R$ ${pago.padStart(9,' ')}\n`+
    `DEVEDOR   : R$ ${devedor.padStart(9,' ')}\n`+
    align.L+`OPERADOR: ${operador}\n`+HR()+
    "\n\n\n"+cut;
}

// ======================================================
// 6. GERAR ETIQUETA (ZPL) � layout avan�ado
// ======================================================
const DPI=203, CM_TO_DOTS=DPI/2.54;
const PW=Math.round(8.5*CM_TO_DOTS), LL=Math.round(5.0*CM_TO_DOTS);
const MID_X=Math.round(PW/2), MID_Y=Math.round(LL/2);

const SCALE_Y=LL/400, escalar=d=>Math.max(20,Math.round(d*SCALE_Y));
const FONT_TITLE=escalar(50), FONT_DATE=escalar(38), FONT_LABEL=escalar(35), FONT_DATA=escalar(60);

const barco          ="<?php echo addslashes($partes[0] ?? 'BARCO'); ?>";
const totalEtiq      =parseInt("<?php echo intval($quantidade_total ?? 1); ?>")||1;
const nomeCompleto   ="<?php echo addslashes($nome_destinatario ?? 'Destinat�rio'); ?>";
const numero         ="<?php echo addslashes($encomenda_id ?? '000'); ?>";
const destino        ="<?php echo addslashes($destino ?? 'Destino'); ?>";
const dataHora       ="<?php echo $data_emissao; ?>";

function abreviarNome(n){ const p=n.trim().split(/\s+/); return p.length<=2?n:`${p[0]} ${p.at(-1)}`; }
const destinatario = abreviarNome(nomeCompleto);

function fonteELinhas(txt,base){
  let size=base, lines=1;
  const charW=t=>t*0.6;
  let needW=txt.length*charW(size);
  if(needW> MID_X){
    size=Math.max(20,Math.floor(size*(MID_X/needW)));
    needW=txt.length*charW(size);
    if(size===20 && needW> MID_X) lines=2;
  }
  return {size, lines};
}
const { size:FONT_DEST_NOME, lines:LINES_DEST_NOME } = fonteELinhas(destinatario, FONT_DATA);

function gerarEtiqueta(atual){
  const Y1=Math.round(LL*0.025),
        Y2=Math.round(LL*0.20),
        Y3=Math.round(LL*0.30),
        Y4=Math.round(LL*0.3875),
        Y5=Math.round(LL*0.55),
        Y6=Math.round(LL*0.6375);

  return `^XA
^CI28
^PW${PW}
^LL${LL}
^LH0,0
^MNY
^CF0,${FONT_TITLE}
^FO0,${Y1}^FB${PW},1,0,C,0^FD ${barco} ^FS
^CF0,${FONT_DATE}
^FO0,${Y2}^FB${PW},1,0,C,0^FDData/Hora: ${dataHora}^FS
^GB${PW},2,2^FS
^FO${MID_X},${Math.round(LL*0.275)}^GB2,${Math.round(LL*0.5875)},2^FS
^FO0,${MID_Y}^GB${PW},2,2^FS
^CF0,${FONT_LABEL}
^FO0,${Y3}^FB${MID_X},1,0,C,0^FDDESTINATARIO^FS
^FO${MID_X},${Y3}^FB${MID_X},1,0,C,0^FDN^FS
^CF0,${FONT_DEST_NOME}
^FO0,${Y4}^FB${MID_X},${LINES_DEST_NOME},0,C,0^FD${destinatario}^FS
^CF0,${FONT_DATA}
^FO${MID_X},${Y4}^FB${MID_X},1,0,C,0^FD${numero}^FS
^CF0,${FONT_LABEL}
^FO0,${Y5}^FB${MID_X},1,0,C,0^FDDESTINO^FS
^FO${MID_X},${Y5}^FB${MID_X},1,0,C,0^FDVOLUME^FS
^CF0,${FONT_DATA}
^FO0,${Y6}^FB${MID_X},1,0,C,0^FD${destino}^FS
^FO${MID_X},${Y6}^FB${MID_X},1,0,C,0^FD${atual}/${totalEtiq}^FS
^XZ`;
}

// ======================================================
// 7. IMPRESS�O
// ======================================================
async function imprimirComprovante(){
  await qz.websocket.connect();
  try {
    await qz.print(cfgComprovante(), [{ type:'raw', format:'plain', data:gerarComprovante() }]);
  } finally { qz.websocket.disconnect(); }
}
async function imprimirEtiquetas(){
  await qz.websocket.connect();
  try {
    const jobs=[{ type:'raw', format:'plain', data:ZPL_CALIBRAR }];
    for(let i=1;i<=totalEtiq;i++) jobs.push({ type:'raw', format:'plain', data:gerarEtiqueta(i) });
    await qz.print(cfgEtiqueta(), jobs);
  } finally { qz.websocket.disconnect(); }
}

// ======================================================
// 8. BOT�ES
// ======================================================
document.getElementById("com")       .addEventListener("click", async () => {
  await imprimirComprovante();
  await imprimirEtiquetas();
});
document.getElementById("btnEtiqueta").addEventListener("click", imprimirEtiquetas);

// ======================================================
// 9. AUTO-PRINT + INICIALIZA��O
// ======================================================
window.addEventListener("DOMContentLoaded", async () => {
  await popularSelects();                      // carrega impressoras
  await new Promise(r => setTimeout(r, 350));  // pequena folga

  if (AUTO_PRINT_COMPROVANTE && AUTO_PRINT_ETIQUETA){
    await imprimirComprovante();
    await new Promise(r => setTimeout(r, 450));   // folga USB
    await imprimirEtiquetas();
  } else if (AUTO_PRINT_COMPROVANTE){
    await imprimirComprovante();
  } else if (AUTO_PRINT_ETIQUETA){
    await imprimirEtiquetas();
  }
});
</script>







</body>


 
  





</html>



<?php
get_footer(); // chama o footer.php do tema