<?php
/*
Template Name: Lista Ônibus (iframe)
*/
if (!defined('ABSPATH')) exit;
get_header();
?>

<div class="container my-4">
  <h2 class="mb-3">Transportes</h2>

  <div class="embed-box" style="position:relative; min-height:70vh;">
    <!-- LOADER -->
    <div id="iframe-loader" style="
      position:absolute; inset:0; display:flex; flex-direction:column;
      align-items:center; justify-content:center; gap:12px;
      background:rgba(255,255,255,.96); z-index:10; font:14px/1.4 system-ui,Segoe UI,Roboto;">
      <div class="spinner" style="
        width:48px; height:48px; border-radius:50%;
        border:4px solid #e5e7eb; border-top-color:#3b82f6;
        animation:spin 1s linear infinite;"></div>
      <div>Carregando…</div>
    </div>

    <iframe
      id="iframe-bus"
      src="<?php echo admin_url('edit.php?post_type=wbtm_bus&noheader=1'); ?>"
      style="width:100%; height:70vh; border:0; background:#fff; border-radius:6px; opacity:0; transition:opacity .2s ease;">
    </iframe>
  </div>
</div>

<style>
@keyframes spin{to{transform:rotate(360deg)}}
</style>

<script>
document.addEventListener("DOMContentLoaded", function(){
  const iframe = document.getElementById("iframe-bus");
  const loader = document.getElementById("iframe-loader");

  const showLoader = () => { loader.style.display = 'flex'; iframe.style.opacity = '0'; };
  const hideLoader  = () => { loader.style.display = 'none'; iframe.style.opacity = '1'; };

  function applyCompact(doc){
    if (!doc || doc.getElementById('cpt-compact-css')) return;
    const css = `
      /* remove menu/header/rodapé do admin */
      #wpadminbar, #adminmenuback, #adminmenuwrap, #wpfooter { display:none !important; }
      #wpcontent { margin-left:0 !important; }
      /* remove notices, busca, filtros, abas, opções da tela */
      .notice, .update-nag, .updated, .error, .is-dismissible,
      #screen-meta, #screen-meta-links, .subsubsub,
      .search-box, .tablenav { display:none !important; }
      /* mantém só o botão "Adicionar novo" (esconde o título) */
      .wrap > h1.wp-heading-inline { display:none !important; }
      .page-title-action { margin:10px 10px 0 10px !important; display:inline-block !important; }
      /* layout compacto */
      .wrap { margin:0 !important; padding:10px !important; }
      #wpbody-content { padding-bottom:0 !important; }
      .wp-list-table { font-size:14px; }
    `;
    const style = doc.createElement('style');
    style.id = 'cpt-compact-css';
    style.textContent = css;
    doc.head.appendChild(style);
  }

  function hookNavigation(doc, win){
    if (!doc) return;

    // Mostra loader em qualquer navegação interna (links, ordenação, paginação, formulários)
    doc.addEventListener('click', function(e){
      const a = e.target.closest && e.target.closest('a');
      if (!a) return;
      // só clique normal (sem Ctrl/Meta/Middle), sem target=_blank
      if (e.button !== 0 || e.ctrlKey || e.metaKey || e.shiftKey || a.target === '_blank') return;
      if (a.href && !a.href.startsWith('javascript:')) showLoader();
    }, true);

    doc.addEventListener('submit', function(){ showLoader(); }, true);

    // beforeunload da página dentro do iframe
    if (win) { win.addEventListener('beforeunload', showLoader, true); }
  }

  function afterLoad(){
    const doc = iframe.contentDocument || iframe.contentWindow?.document;
    try { applyCompact(doc); } catch(e){}
    try { hookNavigation(doc, iframe.contentWindow); } catch(e){}

    // Reaplica CSS se plugins injetarem algo depois
    if (doc) {
      const mo = new MutationObserver(() => applyCompact(doc));
      mo.observe(doc.documentElement, { childList:true, subtree:true });
    }
    hideLoader();
  }

  // Mostra loader desde o início
  showLoader();

  // Quando o iframe concluir o carregamento
  iframe.addEventListener('load', function(){
    const doc = iframe.contentDocument || iframe.contentWindow?.document;
    if (doc && doc.readyState !== 'complete') {
      doc.addEventListener('readystatechange', function(){
        if (doc.readyState === 'complete') afterLoad();
      });
    } else {
      afterLoad();
    }
  });
});
</script>

<?php get_footer(); ?>
