<?php
/**
 * Template Name: Página Bem-vindo Clean
 */
if ( ! defined('ABSPATH') ) exit;

get_header();

$current_user = wp_get_current_user();
$display_name = $current_user->display_name ?: $current_user->user_login;
$roles        = wp_roles()->get_names();
$user_roles   = array();
foreach ( (array) $current_user->roles as $r ) {
    $user_roles[] = isset($roles[$r]) ? $roles[$r] : ucfirst($r);
}
?>
<style>
  .welcome-wrap {
    max-width: 700px;
    margin: 3rem auto;
    padding: 2rem;
    text-align: center;
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 8px 24px rgba(0,0,0,.06);
  }
  .welcome-wrap h1 {
    font-size: clamp(26px, 3vw, 36px);
    font-weight: 700;
    margin-bottom: 0.6rem;
    color: #1e293b;
  }
  .welcome-wrap p {
    font-size: 1.05rem;
    color: #64748b;
    margin-bottom: 1rem;
  }
  .welcome-badge {
    display: inline-block;
    padding: .35rem .9rem;
    background: #e0f2fe;
    color: #0369a1;
    border-radius: 999px;
    font-size: .9rem;
    font-weight: 600;
  }
</style>

<div class="welcome-wrap">
  <h1>Bem-vindo, <?php echo esc_html($display_name); ?> 👋</h1>
  <p>Aqui você vê um resumo rápido de acesso, atalhos do menu e suporte.</p>
  <?php if ( ! empty($user_roles) ): ?>
    <span class="welcome-badge"><?php echo esc_html(implode(', ', $user_roles)); ?></span>
  <?php endif; ?>
</div>

<?php get_footer(); ?>
