<?php
if ( ! defined( 'ABSPATH' ) ) exit;

// Registrar CPT Rotas
function tpp_register_rotas_cpt() {
    $labels = array(
        'name' => 'Rotas',
        'singular_name' => 'Rota',
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'menu_icon' => 'dashicons-location',
        'supports' => array('title'),
    );
    register_post_type('tpp_rota', $args);
}
add_action('init', 'tpp_register_rotas_cpt');

// Metabox de Detalhes da Rota
function tpp_add_rota_metaboxes() {
    add_meta_box('tpp_rota_detalhes', 'Detalhes da Rota', 'tpp_rota_detalhes_callback', 'tpp_rota', 'normal', 'high');
}
add_action('add_meta_boxes', 'tpp_add_rota_metaboxes');

function tpp_rota_detalhes_callback($post) {
    $passagem = get_post_meta($post->ID, 'tpp_passagem', true);
    $tarifa = get_post_meta($post->ID, 'tpp_tarifa', true);
    $desconto = get_post_meta($post->ID, 'tpp_desconto', true);
    $saida = get_post_meta($post->ID, 'tpp_saida', true);
    $chegada = get_post_meta($post->ID, 'tpp_chegada', true);
    $limite = get_post_meta($post->ID, 'tpp_limite', true);
    ?>
    <div class="postbox">
        <div class="inside" style="display:flex;flex-wrap:wrap;gap:20px;">
            <p style="flex:1 1 30%">
                <label>Valor Passagem<br>
                <input type="number" step="0.01" name="tpp_passagem" value="<?php echo esc_attr($passagem); ?>" class="regular-text"></label>
            </p>
            <p style="flex:1 1 30%">
                <label>Tarifa<br>
                <input type="number" step="0.01" name="tpp_tarifa" value="<?php echo esc_attr($tarifa); ?>" class="regular-text"></label>
            </p>
            <p style="flex:1 1 30%">
                <label>Desconto R$<br>
                <input type="number" step="0.01" name="tpp_desconto" value="<?php echo esc_attr($desconto); ?>" class="regular-text"></label>
            </p>
            <p style="flex:1 1 45%">
                <label>Hora Saída<br>
                <input type="time" name="tpp_saida" value="<?php echo esc_attr($saida); ?>" class="regular-text"></label>
            </p>
            <p style="flex:1 1 45%">
                <label>Hora Chegada<br>
                <input type="time" name="tpp_chegada" value="<?php echo esc_attr($chegada); ?>" class="regular-text"></label>
            </p>
            <p style="flex:1 1 45%">
                <label>Limite Compra (horas antes)<br>
                <input type="number" name="tpp_limite" value="<?php echo esc_attr($limite); ?>" class="regular-text"></label>
            </p>
        </div>
    </div>
    <?php
}

// Salvar metadados
function tpp_save_rota_meta($post_id) {
    $fields = ['tpp_passagem','tpp_tarifa','tpp_desconto','tpp_saida','tpp_chegada','tpp_limite'];
    foreach ($fields as $f) {
        if (isset($_POST[$f])) {
            update_post_meta($post_id, $f, sanitize_text_field($_POST[$f]));
        }
    }
}
add_action('save_post_tpp_rota', 'tpp_save_rota_meta');
?>
