<?php
/*
* Author: engr.sumonazma@gmail.com
* Copyright: mage-people.com
*/

if (!defined('ABSPATH')) {
    die; // Cannot access pages directly.
}

$post_id = $post_id ?? WBTM_Global_Function::data_sanitize($_POST['post_id']);
$start_route = $start_route ?? WBTM_Global_Function::data_sanitize($_POST['start_route']);
$end_route = $end_route ?? WBTM_Global_Function::data_sanitize($_POST['end_route']);
$date = $_POST['date'] ?? '';
$all_info = $all_info ?? WBTM_Functions::get_bus_all_info($post_id, $date, $start_route, $end_route);
$seat_price = $seat_price ?? WBTM_Functions::get_seat_price($post_id, $start_route, $end_route);
?>
<table>
    <tbody>
        <tr>
            <th>
                <span class="fas fa-map-marker-alt"></span>
                <?php echo WBTM_Translations::text_bp(); ?>
            </th>
            <td>
                <h6><?php echo esc_html($all_info['bp']); ?></h6>
                <?php echo esc_html($all_info['dp_time'] ? WBTM_Global_Function::date_format($all_info['bp_time'], 'full') : ''); ?>
            </td>
        </tr>
        <tr>
            <th>
                <span class="fas fa-map-marker-alt"></span>
                <?php echo WBTM_Translations::text_dp(); ?>
            </th>
            <td>
                <h6><?php echo esc_html($all_info['dp']); ?></h6>
                <?php echo esc_html($all_info['dp_time'] ? WBTM_Global_Function::date_format($all_info['dp_time'], 'full') : ''); ?>
            </td>
        </tr>
        <?php if ($all_info['start_point'] != $all_info['bp']) { ?>
            <tr>
                <th>
                    <span class="fas fa-map-marker-alt"></span>
                    <?php echo WBTM_Translations::text_start_point(); ?>
                </th>
                <td>
                    <h6><?php echo esc_html($all_info['start_point']); ?></h6>
                    <?php echo esc_html($all_info['start_time'] ? WBTM_Global_Function::date_format($all_info['start_time'], 'full') : ''); ?>
                </td>
            </tr>
        <?php } ?>
        <tr>
            <th>
                <span class="fa fa-calendar"></span>
                <?php echo WBTM_Translations::text_date(); ?>
            </th>
            <td><?php echo WBTM_Global_Function::date_format($date); ?></td>
        </tr>
        <tr>
            <th>
                <span class="fas fa-bus"></span>
                <?php echo WBTM_Translations::text_coach_type(); ?>
            </th>
            <td>
                <?php 
                $bus_type = WBTM_Functions::synchronize_bus_type($post_id);
                echo $bus_type; 
                ?>
            </td>
        </tr>
        <tr>
            <th>
                <span class="fas fa-money-bill"></span>
                <?php echo WBTM_Translations::text_fare(); ?>
            </th>
            <td>
                <?php echo wc_price($seat_price); ?>
                <small>/<?php echo WBTM_Translations::text_seat(); ?></small>
            </td>
        </tr>
    </tbody>
</table>
<?php
