<?php
	/**
	 * Plugin Name: Bus Ticket Booking with Seat Reservation PRO
	 * Plugin URI: http://mage-people.com
	 * Description: Pro version of Woocommerce Bus Tickets Manager, A Complete Bus Ticketing System for WordPress & WooCommerce
	 * Version: 5.2.7
	 * Author: MagePeople Team
	 * Author URI: http://www.mage-people.com/
	 * Text Domain: addon-bus--ticket-booking-with-seat-pro
	 * Domain Path: /languages/
	 */
// If this file is called directly, abort.
	if (!defined('ABSPATH')) {
		die;
	}
	if (!class_exists('Wbtm_Woocommerce_bus_Pro')) {
		class Wbtm_Woocommerce_bus_Pro {
			public function __construct() {
				$this->load_plugin();
			}
			private function load_plugin() {
				include_once(ABSPATH . 'wp-admin/includes/plugin.php');
				//===================//
				if (!defined('WBTM_STORE_URL')) {
					define('WBTM_STORE_URL', 'https://mage-people.com/');
				}
				define('WBTM_PRO_ID', 85351);
				define('WBTM_PRO_NAME', 'Bus Ticket Booking with Seat Reservation PRO');
				//===================//
				if (!defined('WBTM_PLUGIN_DIR_PRO')) {
					define('WBTM_PLUGIN_DIR_PRO', dirname(__FILE__));
				}
				if (!defined('WBTM_PLUGIN_URL_PRO')) {
					define('WBTM_PLUGIN_URL_PRO', plugins_url() . '/' . plugin_basename(dirname(__FILE__)));
				}
				//===================//
				if (is_plugin_active('bus-ticket-booking-with-seat-reservation/woocommerce-bus.php')) {
					if (!class_exists('EDD_SL_Plugin_Updater')) {
						include WBTM_PLUGIN_DIR_PRO . '/plugin-updates/EDD_SL_Plugin_Updater.php';
					}
					$license_key = trim(get_option('wtm_pro_license_key'));
					$edd_updater = new EDD_SL_Plugin_Updater(WBTM_STORE_URL, __FILE__, array(
						'version' => '5.2.7',
						'license' => $license_key,
						'item_name' => WBTM_PRO_NAME,
						'item_id' => WBTM_PRO_ID,
						'author' => 'MagePeople Team',
						'url' => home_url(),
						'beta' => false
					));
					register_activation_hook(__FILE__, [$this, 'on_activation_page_create']);
					require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Dependencies_Pro.php';
				} else {
					add_action('admin_notices', [$this, 'plugin_not_active']);
				}
			}
			public function plugin_not_active() {
				$bus_install_url = get_admin_url() . 'plugin-install.php?s=bus-ticket-booking-with-seat-reservation&tab=search&type=term';
				printf('<div class="error" style="background:red; color:#fff;"><p>%s</p></div>', __('You Must Install WooCommerce Bus Ticket Booking with Seat Reservation Plugin before activating Bus Ticket Booking with Seat Reservation PRO, Because It is dependent on Woocommerce Plugin. <a class="btn button" href=' . $bus_install_url . '>Click Here to Install</a>'));
			}
			public function on_activation_page_create() {
				if (!get_option('wbtm_ticket_page') && !WBTM_Global_Function::get_page_by_slug('view-ticket')) {
					$ticket_page = array(
						'post_type' => 'page',
						'post_name' => 'view-ticket',
						'post_title' => 'View Ticket',
						'post_content' => '[view-ticket]',
						'post_status' => 'publish',
					);
					wp_insert_post($ticket_page);
					update_option('wbtm_ticket_page','yes');
				}
			}
		}
		new Wbtm_Woocommerce_bus_Pro();
	}
