<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if ( ! defined( 'ABSPATH' ) ) {
		die;
	} // Cannot access pages directly.
	if ( ! class_exists( 'WBTM_return_discount' ) ) {
		class WBTM_return_discount {
			public function __construct() {
				add_action( 'wbtm_add_return_discount', [ $this, 'add_return_discount' ] );
                add_action('wbtm_settings_save',[$this,'settings_save']);
				add_action( 'woocommerce_cart_calculate_fees',[$this,'custom_wc_add_discount']);
			}
			public function add_return_discount( $post_id ) {
				$discount = WBTM_Global_Function::get_post_info( $post_id, 'bus_return_discount', 0 );
				$discount_type = WBTM_Global_Function::get_post_info( $post_id, 'bus_return_discount_type', 'percent' );
				?>
                <div class="_dLayout_padding">
                    <div class="_dFlex_justifyBetween_alignCenter">
                        <div class="col_6 _dFlex_fdColumn">
                            <label>                                <?php esc_html_e( 'Return Discount', 'addon-bus--ticket-booking-with-seat-pro' ); ?>                            </label>
							<?php WBTM_Settings::info_text( 'bus_return_discount' ); ?>
                        </div>
                        <div class="col_6 textRight _dFlex_justifyBetween_alignCenter">
                            <div class="col_8">
                                <input type="number" min="0" step="any" class="formControl max_300" name="bus_return_discount" placeholder="Ex: 10.4 or 5" value="<?php echo esc_attr( $discount ); ?>"/>
                            </div>
                            <div class="col_4">
                                <select class="formControl" name="bus_return_discount_type">
                                    <option value="percent" <?php selected( $discount_type, 'percent' ); ?>><?php esc_html_e( '%', 'addon-bus--ticket-booking-with-seat-pro' ); ?></option>
                                    <option value="fixed" <?php selected( $discount_type, 'fixed' ); ?>><?php esc_html_e( 'Fixed', 'addon-bus--ticket-booking-with-seat-pro' ); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
				<?php
			}
			public function discount_price( $price, $post_id, $bp, $dp ) {
				$discount = WBTM_Global_Function::get_post_info( $post_id, 'bus_return_discount', 0 );
				$discount_type = WBTM_Global_Function::get_post_info( $post_id, 'bus_return_discount_type', 'percent' );
				
				if ( $discount > 0 && $bp && $dp ) {
					$cart_items = WC()->cart->get_cart();
					if ( sizeof( $cart_items ) > 0 ) {
						foreach ( $cart_items as $cart_item ) {
							$start_route = array_key_exists( 'wbtm_bp_place', $cart_item ) ? $cart_item['wbtm_bp_place'] : '';
							$end_route   = array_key_exists( 'wbtm_dp_place', $cart_item ) ? $cart_item['wbtm_dp_place'] : '';
							if ( $bp == $end_route && $dp == $start_route ) {
								if ( $discount_type === 'percent' ) {
									$price = $discount / 100;
								} else {
									$price = $discount;
								}
							}
						}
					}
				}
				return $price;
			}
            public function settings_save($post_id) {
	            $discount = WBTM_Global_Function::get_submit_info('bus_return_discount',0);
	            $discount_type = WBTM_Global_Function::get_submit_info('bus_return_discount_type', 'percent');
	            update_post_meta($post_id, 'bus_return_discount', $discount);
	            update_post_meta($post_id, 'bus_return_discount_type', $discount_type);
            }
            public function custom_wc_add_discount() {
	            $total_disc = 0;
	            $cart_items = WC()->cart->get_cart();
	            if ( sizeof( $cart_items ) > 0 ) {
                    $all_infos=[];
                    $disc_infos=[];
                    $count=0;
		            foreach ( $cart_items as $cart_item ) {
			            $post_id = array_key_exists( 'wbtm_bus_id', $cart_item ) ? $cart_item['wbtm_bus_id'] : 0;
			            if ( get_post_type( $post_id ) == WBTM_Functions::get_cpt() ) {
				            $start_route = array_key_exists( 'wbtm_bp_place', $cart_item ) ? $cart_item['wbtm_bp_place'] : '';
				            $end_route   = array_key_exists( 'wbtm_dp_place', $cart_item ) ? $cart_item['wbtm_dp_place'] : '';
				            $wbtm_seats_qty   = array_key_exists( 'wbtm_seats_qty', $cart_item ) ? $cart_item['wbtm_seats_qty'] :1;
				            $all_infos[$count]['bp'] = $start_route;
				            $all_infos[$count]['dp'] = $end_route;
				            $all_infos[$count]['qty'] = $wbtm_seats_qty;
				            $discount = WBTM_Global_Function::get_post_info( $post_id, 'bus_return_discount', 0 );
				            $discount_type = WBTM_Global_Function::get_post_info( $post_id, 'bus_return_discount_type', 'percent' );
                            
                            if($discount > 0){
                                $base_price = array_key_exists( 'wbtm_base_price', $cart_item ) ? $cart_item['wbtm_base_price'] : 0;
	                            $disc_infos[$count]['bp'] = $start_route;
	                            $disc_infos[$count]['dp'] = $end_route;
	                            $disc_infos[$count]['qty'] = $wbtm_seats_qty;
	                            
	                            if ( $discount_type === 'percent' ) {
                                    $disc_infos[$count]['discount'] = ($base_price/$wbtm_seats_qty)*($discount/100);
                                } else {
                                    // For fixed amount, apply the discount directly
                                    $disc_infos[$count]['discount'] = $discount;
                                }
                            }
			            }
			            $count++;
		            }
                    if(sizeof($disc_infos)){
                        foreach ($disc_infos as $post_id=>$disc_info){
                            $bp=$disc_info['bp'];
                            $dp=$disc_info['dp'];
                            $qty=$disc_info['qty'];
                            foreach($all_infos as $key=>$all_info){
                                $_bp=$all_info['dp'];
                                $_dp=$all_info['bp'];
                                $_qty=$all_info['qty'];
                                if($bp==$_bp && $dp==$_dp){
	                                $total_disc=$total_disc+$disc_info['discount']*min($qty,$_qty);
                                }
                            }
                        }
                    }
	            }
	            if($total_disc>0) {
		            WC()->cart->add_fee( 'Discount on return tickets', - $total_disc );
	            }
            }
		}
		new WBTM_return_discount();
	}