<?php
/*
	* @Author 		engr.sumonazma@gmail.com
	* Copyright: 	mage-people.com
	*/
if (!defined('ABSPATH')) {
	die;
} // Cannot access pages directly.
if (!class_exists('WBTM_Passenger_List')) {
	class WBTM_Passenger_List
	{
		public function __construct()
		{
			add_action('admin_menu', array($this, 'passenger_menu'));
			add_action('wbtm_passenger_info_header', array($this, 'wbtm_passenger_info_header'));
			add_action('wbtm_passenger_info_column', array($this, 'wbtm_passenger_info_column'), 10, 2);
			add_action('admin_enqueue_scripts', array($this, 'enqueue_passenger_list_styles'));
			/**********************************/
			add_action('wp_ajax_get_wbtm_passenger_filter_result', array($this, 'get_wbtm_passenger_filter_result'));
			add_action('wp_ajax_nopriv_get_wbtm_passenger_filter_result', array($this, 'get_wbtm_passenger_filter_result'));
			/*********************************************/
			add_action('wp_ajax_wbtm_delete_attendee', array($this, 'wbtm_delete_attendee'));
			add_action('wp_ajax_nopriv_wbtm_delete_attendee', array($this, 'wbtm_delete_attendee'));
			/*********************************************/
			add_action('wp_ajax_wbtm_load_custom_attendee_fields', array($this, 'load_custom_attendee_fields'));
			add_action('wp_ajax_nopriv_wbtm_load_custom_attendee_fields', array($this, 'load_custom_attendee_fields'));
		}
		public static function wbtm_passenger_info_header_array($bus_id)
		{
			$passenger_infos = get_post_meta($bus_id, 'wbtm_attendee_info', true);
			$custom_passenger_infos = get_post_meta($bus_id, 'wbtm_custom_attendee_info', true);
			$passenger_infos = is_array($passenger_infos) ? $passenger_infos : array();
			$custom_passenger_infos = is_array($custom_passenger_infos) ? $custom_passenger_infos : array();
			$headers = array();
			foreach ($passenger_infos as $passenger_info) {
				if (is_array($passenger_info) && array_key_exists('field_id', $passenger_info)) {
					$headers[$passenger_info['field_id']] = $passenger_info;
				}
			}
			foreach ($custom_passenger_infos as $passenger_info) {
				if (is_array($passenger_info) && array_key_exists('field_id', $passenger_info)) {
					$headers[$passenger_info['field_id']] = $passenger_info;
				}
			}
			return $headers;
		}
		public static function wbtm_passenger_info_header($bus_id)
		{
			$passenger_infos = self::wbtm_passenger_info_header_array($bus_id);
			if (is_array($passenger_infos)) {
				foreach ($passenger_infos as $key => $passenger_info) {
					unset($field_label);
					$field_label = (is_array($passenger_info) && array_key_exists('field_label', $passenger_info) && empty($passenger_info['field_label'])) ? $passenger_info['d_label'] : $passenger_info['field_label'];
					if (array_key_exists('active', $passenger_info) && $passenger_info['active'] == 1) {
?>
						<th class="textLeft"><?php echo esc_html($field_label); ?></th>
					<?php
					}
				}
			}
		}
		public static function wbtm_passenger_info_column($attendee_id, $bus_id)
		{
			$headers = self::wbtm_passenger_info_header_array($bus_id);
			$passenger_infos = WBTM_Function_PRO::get_attendee_info($attendee_id);
			if (is_array($headers)) {
				foreach ($headers as $key => $header) {
					if (is_array($header) && (array_key_exists('active', $header) && $header['active'] == 1) && array_key_exists($key, $passenger_infos)) {
					?>
						<td class="textCenter"><?php echo esc_html($passenger_infos[$key]['value']); ?></td>
					<?php
					} else if (is_array($header) && (array_key_exists('active', $header) && $header['active'] == 1) && !array_key_exists($key, $passenger_infos)) {
					?>
						<td class="textCenter"></td>
					<?php
					} else if (is_array($header) && (array_key_exists('active', $header) && $header['active'] != 1)) {
					?>
			<?php
					}
				}
			}
		}
		public static function get_passenger_info($passenger_infos, $key)
		{
			if (is_array($passenger_infos) && array_key_exists($key, $passenger_infos) && array_key_exists('value', $passenger_infos[$key])) {
				return $passenger_infos[$key]['value'];
			} else {
				return "";
			}
		}
		public static function extra_service($attendee_id)
		{
			$extra_service = "";
			$ex_service_infos = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_services', []);
			if (sizeof($ex_service_infos) > 0) {
				$count = count($ex_service_infos);
				foreach ($ex_service_infos as $key => $ex_service_info) {
					$name = $ex_service_info['name'];
					$price = $ex_service_info['price'];
					$qty = $ex_service_info['qty'];
					if ($key == ($count - 1)) {
						$extra_service .= $name . ' x ' . $qty;
					} else {
						$extra_service .= $name . ' x ' . $qty . " , ";
					}
					$count++;
				}
				return $extra_service;
			} else {
				return "";
			}
		}
		public function passenger_menu()
		{
			$cpt = WBTM_Functions::get_cpt();
			add_submenu_page('edit.php?post_type=' . $cpt, esc_html__('Passenger List', 'addon-bus--ticket-booking-with-seat-pro'), esc_html__('Passenger List', 'addon-bus--ticket-booking-with-seat-pro'), 'manage_options', 'wbtm_passenger_list', array($this, 'passenger_filter'));
		}
		public function passenger_filter()
		{
			?>
			<div class="wrap">
				<div class="wbtm_style wbtm_passenger_filter_area wbtm_admin_page">
					<div class="_dLayout_pRelative placeholder_area">
						<h4 class="title_on_border"><?php echo WBTM_Functions::get_name() . ' ' . esc_html__('Passenger Filter', 'addon-bus--ticket-booking-with-seat-pro'); ?></h4>
						
						<!-- Filter Status Indicator -->
						<div class="wbtm_filter_status" id="wbtm_filter_status" style="display: none;">
							<span class="filter-icon fas fa-filter"></span>
							<span class="filter-text"><?php esc_html_e('Filters are active', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
							<span class="active-filters" id="active_filters_text"></span>
						</div>
						
						<div class="wbtm_filter_form inputInline" data-placeholder>
							<!-- First Row -->
							<div class="mpForm">
								<?php WBTM_Layout_Pro::select_bus(); ?>
								<?php WBTM_Layout_Pro::select_journey_date(); ?>
								<?php WBTM_Layout_Pro::select_order_date(); ?>
								<?php WBTM_Layout_Pro::select_bp_date(); ?>
								<?php WBTM_Layout_Pro::select_bp_point(); ?>
							</div>
							<!-- Second Row -->
							<div class="mpForm">
								<!-- Order ID -->
								<div class="inputList">
									<label>
										<span><?php esc_html_e('Order ID', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
										<input type="text" class="formControl" name="wbtm_order_id" placeholder="<?php esc_attr_e('Enter Order ID', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
									</label>
								</div>
								<!-- Billing Name -->
								<div class="inputList">
									<label>
										<span><?php esc_html_e('Billing Name', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
										<input type="text" class="formControl" name="wbtm_user_name" placeholder="<?php esc_attr_e('Enter Billing Name', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
									</label>
								</div>
								<!-- Billing Email -->
								<div class="inputList">
									<label>
										<span><?php esc_html_e('Billing Email', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
										<input type="text" class="formControl" name="wbtm_user_email" placeholder="<?php esc_attr_e('Enter Billing Email', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
									</label>
								</div>
								<!-- Billing Phone -->
								<div class="inputList">
									<label>
										<span><?php esc_html_e('Billing Phone', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
										<input type="text" class="formControl" name="wbtm_user_phone" placeholder="<?php esc_attr_e('Enter Billing Phone', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
									</label>
								</div>
								<!-- Passenger Name -->
								<div class="inputList">
									<label>
										<span><?php esc_html_e('Passenger Name', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
										<input type="text" class="formControl" name="wbtm_full_name" placeholder="<?php esc_attr_e('Search by passenger name', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
									</label>
								</div>
							</div>
							<!-- Third Row (if needed for more passenger fields) -->
							<div class="mpForm">
								<!-- Passenger Email -->
								<div class="inputList">
									<label>
										<span><?php esc_html_e('Passenger Email', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
										<input type="text" class="formControl" name="wbtm_reg_email" placeholder="<?php esc_attr_e('Search by passenger email', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
									</label>
								</div>
								<!-- Passenger Phone -->
								<div class="inputList">
									<label>
										<span><?php esc_html_e('Passenger Phone', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
										<input type="text" class="formControl" name="wbtm_reg_phone" placeholder="<?php esc_attr_e('Search by passenger phone', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
									</label>
								</div>
								<!-- Passenger Address -->
								<div class="inputList">
									<label>
										<span><?php esc_html_e('Passenger Address', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
										<input type="text" class="formControl" name="wbtm_reg_address" placeholder="<?php esc_attr_e('Search by passenger address', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
									</label>
								</div>
								<!-- Custom Attendee Fields Container -->
								<div id="wbtm_custom_attendee_filters">
									<!-- Custom attendee filters will be loaded here dynamically -->
								</div>
								<!-- Button Group -->
								<div class="inputList buttonGroup">
									<button class="_themeButton" type="button" id="get_wbtm_passenger_filter_result"><?php esc_html_e('Filter', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
									<button class="_warningButton" id="wbtm_filter_reset" type="button"><?php esc_html_e('Reset', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
								</div>
							</div>
						</div>
					</div>
					<div class="wbtm_filter_result" id="wbtm_passenger_list_result">
						<?php $this->passenger_filter_result(); ?>
					</div>
				</div>
			</div>
			<style>
				div.notice,
				#update-nag,
				.update-nag {
					display: none;
				}
			</style>
			<script>
window.wbtm_pdf_nonce = "<?php echo wp_create_nonce('wbtm_generate_pdf'); ?>";
</script>
		<?php
		}
		public function passenger_filter_result()
		{
			$post_per_page = isset($_REQUEST['post_per_page']) ? WBTM_Global_Function::data_sanitize($_REQUEST['post_per_page']) : 20;
			$post_per_page = $post_per_page > 0 ? $post_per_page : 20;
			$filter_args = isset($_REQUEST['filter_args']) ? WBTM_Global_Function::data_sanitize($_REQUEST['filter_args']) : [];
			$bus_id = array_key_exists('wbtm_bus_id', $filter_args) ? $filter_args['wbtm_bus_id'] : 0;
			$page = isset($_REQUEST['page']) ? WBTM_Global_Function::data_sanitize($_REQUEST['page']) : 1;
			
			// Always get the current sort checkbox state from the request, not just filter_args
			$sort_by_seat = isset($_REQUEST['filter_args']['sort_by_seat']) ? $_REQUEST['filter_args']['sort_by_seat'] : '0';
			$filter_args['sort_by_seat'] = $sort_by_seat;
			
			$all_passengers = WBTM_Function_PRO::attendee_query($filter_args, $post_per_page, $page, $sort_by_seat);
			$total_passenger = $all_passengers->post_count;
			
			// Check if any filter is applied (not just bus_id)
			$has_filters = !empty($filter_args) && count(array_filter($filter_args)) > 0;
		?>
			<div class="_dLayout_pRelative placeholder_area">
				<table class="_mb_layoutFixed passenger-table-header" data-placeholder>
					<thead>
						<tr>
							<th class="textLeft">
								<label class="alignCenter">
									<span class="pR"><?php _e('Passenger Per Page', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
									<input type="number" min="1" class="formControl pagination_input" name="post_per_page" value="<?php echo $post_per_page > 0 ? $post_per_page : 20; ?>" />
								</label>
							</th>
							<th class="textCenter">
								<label class="alignCenter">
									<div style="display: flex; align-items: center; gap: 24px; justify-content: center;">
										<input type="checkbox" id="wbtm_sort_by_seat" name="sort_by_seat" value="1" <?php checked($sort_by_seat, '1'); ?> />
										<span class="pL"><?php esc_html_e('Sort by Seat Number', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
									</div>
									<div style="display: flex; align-items: center; gap: 24px; justify-content: center;">
										<input type="checkbox" id="wbtm_show_coupon_price" name="show_coupon_price" value="1" <?php checked(isset($_REQUEST['filter_args']['show_coupon_price']) ? $_REQUEST['filter_args']['show_coupon_price'] : '', '1'); ?> />
										<span class="pL"><?php esc_html_e('Show Price with Coupon Discount', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
									</div>
								</label>
							</th>
							<th class="textRight">
								<label class="mp_zero">
									<?php _e('Showing ', 'addon-bus--ticket-booking-with-seat-pro'); ?>
									<strong class="textTheme"><?php echo esc_html(min($post_per_page, $total_passenger)); ?></strong>
									<?php _e('of total ', 'addon-bus--ticket-booking-with-seat-pro'); ?>
									<strong class="textTheme"><?php echo esc_html($all_passengers->found_posts); ?></strong>
									<?php _e(' Passenger.', 'addon-bus--ticket-booking-with-seat-pro'); ?>
								</label>
							</th>
							<?php if ($has_filters) { ?>
								<?php
								$download_url = WBTM_Pro_Pdf::get_pdf_url($filter_args);
								$default_args = array('action' => 'wbtm_download_csv', 'document_type' => 'csv', 'args' => $filter_args);
								$args = wp_parse_args($default_args);
								$build_url = http_build_query($args);
								$download_url_csv = wp_nonce_url(admin_url("admin-ajax.php?" . $build_url), 'wbtm_download_csv');
								?>
								<th>
									<div class="buttonGroup">
										<?php if (class_exists('WBTM_QR_CODE_Functions')) : ?>
											<button class="_themeButton" type="button" id="bulk_check_in">
												<?php esc_html_e('Bulk Check-In', 'addon-bus--ticket-booking-with-seat-pro'); ?>
											</button>
											<button class="_warningButton" type="button" id="bulk_revoke">
												<?php esc_html_e('Bulk Revoke', 'addon-bus--ticket-booking-with-seat-pro'); ?>
											</button>
											<button class="_themeButton" type="button" id="scan_qr">
												<?php esc_html_e('Scan QR', 'addon-bus--ticket-booking-with-seat-pro'); ?>
											</button>
										<?php endif; ?>
										<button class="_themeButton" type="button" id="wbtm_download_pdf_dynamic">
											<span class="fas fa-file-pdf _mR_xs"></span>
											<?php esc_html_e('Download Passenger List', 'addon-bus--ticket-booking-with-seat-pro'); ?>
										</button>
										<button type="button" class="_successButton_xs" data-href="<?php echo esc_attr($download_url_csv); ?>">
											<span class="fas fa-file-csv _mR_xs"></span>
											<?php esc_html_e('Download CSV', 'addon-bus--ticket-booking-with-seat-pro'); ?>
										</button>
									</div>
								</th>
							<?php } ?>
						</tr>
					</thead>
				</table>
				<?php $this->passenger_list($all_passengers, $page); ?>
			</div>
			<?php
		}
		public function passenger_list($all_passengers, $page)
		{
			$total_passenger = $all_passengers ? $all_passengers->found_posts : 0;
			$page = $page ?? 1;
			if ($total_passenger > 0) {
				$active_page = (int)$page - 1;
				$active_page = max($active_page, 0);
				$post_per_page = $_REQUEST['post_per_page'] ?? 20;
				$post_per_page = $post_per_page > 0 ? $post_per_page : 20;
				$count = $active_page * $post_per_page + 1;
				$passenger_infos = $all_passengers->posts;
				$attendee_ids = [];
				foreach ($passenger_infos as $passenger) {
					$attendee_ids[] = $passenger->ID;
				}
				self::passenger_table($attendee_ids, $count);
			?>
				<?php
				$parameter = array("show" => $post_per_page, "pagination" => "yes", "pagination-style" => "ajax",);
				do_action('wbtm_pagination_section', $parameter, $total_passenger, $active_page);
				?>
				<input type="hidden" name="mp_total_item" value="<?php echo esc_attr($total_passenger); ?>" />
			<?php
			} else {
				WBTM_Layout::msg(esc_html__('No Record Found.', 'addon-bus--ticket-booking-with-seat-pro'));
			}
		}
		public static function ex_service_price($attendee_id){
			$ex_service_infos = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_services', []);
			if (sizeof($ex_service_infos) > 0) {
				$total_ex_service_price = 0;
				foreach ($ex_service_infos as $ex_service_info) {
					$price = $ex_service_info['price'] * $ex_service_info['qty'];
					$total_ex_service_price = $total_ex_service_price + $price;
				}
				return $total_ex_service_price;
			}
			return 0;
		}
		public static function passenger_table($attendee_ids = [], $count = 1)
		{
			if (sizeof($attendee_ids) > 0) {
				$filter_args = isset($_REQUEST['filter_args']) ? WBTM_Global_Function::data_sanitize($_REQUEST['filter_args']) : [];
				$bus_id = array_key_exists('wbtm_bus_id', $filter_args) ? $filter_args['wbtm_bus_id'] : 0;
				$has_filters = !empty($filter_args) && count(array_filter($filter_args)) > 0;
			?>
				<div class="wbtm_passenger_list_table">
					<?php if (class_exists('WBTM_QR_CODE_Functions')) : ?>
					<div class="wbtm_passenger_list_table_header">
						<div class="wbtm_passenger_list_table_header_left">
							<label>
								<input type="checkbox" id="wbtm-select-all-attendee" />
								<?php esc_html_e('Select All', 'addon-bus--ticket-booking-with-seat-pro'); ?>
							</label>
						</div>
						<div class="wbtm_passenger_list_table_header_right">
					<button class="_successButton" id="wbtm-bulk-checkin" type="button"><?php esc_html_e('Bulk Check-In', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
					<button class="_dangerButton" id="wbtm-bulk-revoke" type="button"><?php esc_html_e('Bulk Revoke', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
					<button class="_themeButton" id="wbtm-scan-qr-btn" type="button"><?php esc_html_e('Scan QR', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
				</div>
					</div>
					<?php endif; ?>
				<table class="groupCheckBox passenger-list-table" data-placeholder>
					<thead>
						<tr>
								<?php if (class_exists('WBTM_QR_CODE_Functions')) : ?>
								<th class="textCenter">
									<label class="customCheckboxLabel">
										<input type="checkbox" class="customCheckbox" disabled />
										<span class="customCheckboxMark"></span>
									</label>
								</th>
								<th class="textCenter"><?php esc_html_e('SL', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<?php endif; ?>
							<th class="_w_50"><?php esc_html_e('Order ID', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="textLeft"><?php echo esc_html(WBTM_Functions::get_name()); ?></th>
							<th class="textLeft"><?php esc_html_e('Billing Info', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<?php if ($bus_id > 0) {
								do_action('wbtm_passenger_info_header', $bus_id);
							} else if ($has_filters) {
								// When no specific bus is selected but filters are applied, 
								// we'll show dynamic passenger info columns based on the first attendee's bus
								// This will be handled in the table body
								$first_attendee_id = $attendee_ids[0];
								$first_bus_id = WBTM_Global_Function::get_post_info($first_attendee_id, 'wbtm_bus_id');
								if ($first_bus_id > 0) {
									do_action('wbtm_passenger_info_header', $first_bus_id);
								}
							} ?>
							<th><?php echo WBTM_Translations::text_seat_name(); ?></th>
							<th><?php echo WBTM_Translations::text_order_date(); ?></th>
							<th><?php echo WBTM_Translations::text_journey_date(); ?></th>
							<th class="_w_100"><?php esc_html_e('Time', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_150"><?php esc_html_e('From=>To', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_150"><?php echo WBTM_Translations::text_pickup() . '=>' . WBTM_Translations::text_drop_off(); ?></th>
							<th class="textLeft"><?php esc_html_e('Extra Bag', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_125"><?php esc_html_e('Paid Amount', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<?php if (class_exists('WBTM_QR_CODE_Functions')) : ?>
								<th class="_w_150"><?php esc_html_e('Check in', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<?php endif; ?>
							<th class="_w_100"><?php esc_html_e('Status', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_125"><?php echo WBTM_Translations::text_action(); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php
						foreach ($attendee_ids as $attendee_id) {
							$post_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_id');
							$category = WBTM_Global_Function::get_post_info($post_id, 'wbtm_bus_category');
							$order_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_id');
							$billing_name = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_name');
							$billing_email = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_email');
							$billing_phone = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_phone');
							$booking_date = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_booking_date');
							$boarding_time = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_time');
							$bp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_point');
							$dp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_dropping_point');
							$pickup_point = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_pickup_point');
							$drop_off_point = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_drop_off_point');
							$download_url = WBTM_Pro_Pdf::get_pdf_url(array('attendee_id' => $attendee_id));
							$download_url_order = WBTM_Pro_Pdf::get_pdf_url(array('wbtm_order_id' => $order_id));
							$order_status = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_status');
							// Get Paid Amount
							if ($order_status == 'partially-paid') {
								$paid_amount = floatval(WBTM_Global_Function::get_post_info($order_id, '_order_total'));
								$paid_amount += floatval(self::ex_service_price($attendee_id));
							} else {
								$paid_amount = floatval(WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_fare'));
								$paid_amount += floatval(self::ex_service_price($attendee_id));
							}
						?>
							<tr class="passenger-list">
								<?php if (class_exists('WBTM_QR_CODE_Functions')) : ?>
									<td class="textCenter">
										<input type="checkbox" class="wbtm-passenger-checkbox" value="<?php echo esc_attr($attendee_id); ?>">
									</td>
									<td class="textCenter"><?php echo esc_html($count); ?></td>
								<?php endif; ?>
								<td class="textCenter">#<?php echo esc_html($order_id); ?></td>
								<td>
									<?php 
									$bus_title = get_the_title($post_id);
									if (empty($bus_title) || $bus_title == $post_id) {
										// If no title or title is same as ID, try to get bus name from meta
										$bus_name = WBTM_Global_Function::get_post_info($post_id, 'wbtm_bus_name');
										if (!empty($bus_name)) {
											echo esc_html($bus_name);
										} else {
											echo esc_html__('Bus ID: ', 'addon-bus--ticket-booking-with-seat-pro') . esc_html($post_id);
										}
									} else {
										echo esc_html($bus_title);
									}
									?>
								</td>
								<td>
									<div class="textSuccess">
										<?php if ($billing_name) { ?>
											<i class="fas fa-user-circle"></i>&nbsp;&nbsp;<?php echo esc_html($billing_name); ?>
										<?php }
										if ($billing_phone) { ?>
											<i class="fas fa-phone-alt"></i>&nbsp;&nbsp;<?php echo esc_html($billing_phone); ?>
										<?php }
										if ($billing_email) { ?>
											<i class="fas fa-envelope"></i>&nbsp;&nbsp;<?php echo esc_html($billing_email); ?>
										<?php } ?>
									</div>
								</td>
								<?php 
								// Show passenger info columns based on the attendee's bus
								$current_bus_id = $bus_id > 0 ? $bus_id : $post_id;
								if ($current_bus_id > 0) {
									do_action('wbtm_passenger_info_column', $attendee_id, $current_bus_id);
								} 
								?>
								<td class="textCenter" data-seat="<?php echo esc_attr(WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_seat')); ?>"><?php echo WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_seat'); ?></td>
								<td class="textCenter"><?php echo WBTM_Global_Function::date_format($booking_date, 'date'); ?></td>
								<td class="textCenter"><?php echo WBTM_Global_Function::date_format($boarding_time, 'date'); ?></td>
								<td class="textCenter"><?php echo WBTM_Global_Function::date_format($boarding_time, 'time'); ?></td>
								<td class="textCenter"><?php echo esc_html($bp); ?> <i class="fas fa-long-arrow-alt-right"></i> <?php echo esc_html($dp); ?></td>
								<td><?php echo esc_html($pickup_point) . '=>' . esc_html($drop_off_point); ?></td>
								<td><?php echo esc_html(self::extra_service($attendee_id)); ?></td>
								<td class="textCenter">
									<?php
									$show_coupon_price = isset($_REQUEST['filter_args']['show_coupon_price']) ? $_REQUEST['filter_args']['show_coupon_price'] : '';
									if ($show_coupon_price == '1') {
										$discounted_price = self::get_discounted_price_for_attendee($order_id, $attendee_id, null, 'table');
										if ($discounted_price !== false) {
											echo wc_price($discounted_price);
										} else {
											echo wc_price($paid_amount);
										}
									} else {
										echo wc_price($paid_amount);
									}
									?>
								</td>
								<?php if (class_exists('WBTM_QR_CODE_Functions')) : ?>
									<td><?php do_action('wbtm_qr_ticket_status_text', $attendee_id); ?></td>
								<?php endif; ?>
								<td class="textCenter"><span class="label textWhite bgSuccess" style="padding:.2em .6em;"><?php echo esc_html($order_status); ?></span></td>
								<td>
									<div class="buttonGroup">
										<button class="_whiteButton_xs" type="button" title="<?php esc_attr_e('Download Attendee Pdf.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-href="<?php echo esc_attr($download_url); ?>">
											<span class="fas fa-file-pdf mp_zero"></span>
										</button>
										<button class="_whiteButton_xs " type="button" title="<?php esc_attr_e('Download Order Pdf.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-href="<?php echo esc_attr($download_url_order); ?>">
											<span class="far fa-file-pdf mp_zero"></span>
										</button>
										<button class="_whiteButton_xs" type="button" data-collapse-target="wbtm_expand_<?php echo esc_attr($attendee_id); ?>" title="<?php esc_attr_e('Open Passenger Details.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-open-icon="fa-eye" data-close-icon="fa-eye-slash">
											<span data-icon class="fas fa-eye mp_zero"></span>
										</button>
										<button class="_themeButton_xs" id="wbtm_delete_attendee" type="button" data-attendee-id="<?php echo esc_attr($attendee_id); ?>" title="<?php echo esc_attr__('Remove Passenger.', 'addon-bus--ticket-booking-with-seat-pro') . ' : ' . esc_attr($attendee_id); ?>">
											<span class="fas fa-trash-alt mp_zero"></span>
										</button>
									</div>
								</td>
							</tr>
							<tr class="passenger-list-details" data-collapse="wbtm_expand_<?php echo $attendee_id; ?>">
								<td></td>
								<td colspan="4"><?php WBTM_Layout_Pro::service_info($attendee_id); ?></td>
								<td colspan="4"> <?php WBTM_Layout_Pro::billing_info($attendee_id); ?> </td>
								<td colspan="4">
									<h4><?php echo WBTM_Translations::text_passenger_info(); ?></h4>
									<?php WBTM_Layout_Pro::seat_info($attendee_id); ?>
									<?php
									$show_coupon_price = isset($_REQUEST['filter_args']['show_coupon_price']) ? $_REQUEST['filter_args']['show_coupon_price'] : '';
									if ($show_coupon_price == '1') {
										$discounted_price = self::get_discounted_price_for_attendee($order_id, $attendee_id, null, 'details');
										if ($discounted_price !== false) {
											echo '<div><strong>' . esc_html__('Paid Amount (after discount):', 'addon-bus--ticket-booking-with-seat-pro') . '</strong> ' . wc_price($discounted_price) . '</div>';
										}
									}
									?>
								</td>
							</tr>
						<?php
							$count++;
						}
						?>
					</tbody>
				</table>
				</div>
<?php
			}
		}
		//********************//
		public function get_wbtm_passenger_filter_result()
		{
			$this->passenger_filter_result();
			die();
		}
		public function wbtm_delete_attendee()
		{
			$attendee_id = isset($_REQUEST['attendee_id']) ? WBTM_Global_Function::data_sanitize($_REQUEST['attendee_id']) : '';
			if ($attendee_id) {
				update_post_meta($attendee_id, 'wbtm_order_status', 'canceled');
			}
			die();
		}
		public function load_custom_attendee_fields() {
			if (!isset($_POST['bus_id']) || empty($_POST['bus_id'])) {
				// No bus selected: aggregate all unique custom attendee fields from all buses
				$all_buses = get_posts([
					'post_type' => 'wbtm_bus',
					'posts_per_page' => -1,
					'fields' => 'ids',
				]);
				$all_custom_fields = [];
				foreach ($all_buses as $bus_id) {
					$custom_fields = get_post_meta($bus_id, 'wbtm_custom_attendee_info', true);
					if (is_array($custom_fields)) {
						foreach ($custom_fields as $field) {
							if (empty($field['field_id']) || empty($field['field_label'])) continue;
							$field_id = sanitize_key($field['field_id']);
							$field_label = sanitize_text_field($field['field_label']);
							$all_custom_fields[$field_id] = $field_label;
						}
					}
				}
				if (empty($all_custom_fields)) {
					wp_send_json_success('<div class="notice notice-info"><p>' . esc_html__('No custom attendee fields found for any bus.', 'addon-bus--ticket-booking-with-seat-pro') . '</p></div>');
					return;
				}
				ob_start();
				foreach ($all_custom_fields as $field_id => $field_label) {
					?>
					<div class="inputList">
						<label class="fdColumn">
							<span class="fas fa-info-circle"><?php echo esc_html($field_label); ?></span>
							<input type="text" 
							   name="wbtm_custom_<?php echo esc_attr($field_id); ?>" 
							   class="formControl custom_attendee_filter" 
							   data-field-id="<?php echo esc_attr($field_id); ?>"
							   placeholder="<?php echo esc_attr(sprintf(__('Filter by %s', 'addon-bus--ticket-booking-with-seat-pro'), $field_label)); ?>"
							/>
						</label>
					</div>
					<?php
				}
				$html = ob_get_clean();
				wp_send_json_success($html);
				return;
			}

			// Default: load custom fields for the selected bus
			$bus_id = intval($_POST['bus_id']);
			$custom_fields = get_post_meta($bus_id, 'wbtm_custom_attendee_info', true);
			if (!is_array($custom_fields) || empty($custom_fields)) {
				wp_send_json_success('<div class="notice notice-info"><p>' . esc_html__('No custom attendee fields found for this bus.', 'addon-bus--ticket-booking-with-seat-pro') . '</p></div>');
				return;
			}
			ob_start();
			foreach ($custom_fields as $field) {
				if (empty($field['field_id']) || empty($field['field_label'])) {
					continue;
				}
				$field_id = sanitize_key($field['field_id']);
				$field_label = sanitize_text_field($field['field_label']);
				?>
				<div class="inputList">
					<label class="fdColumn">
						<span class="fas fa-info-circle"><?php echo esc_html($field_label); ?></span>
						<input type="text" 
						   name="wbtm_custom_<?php echo esc_attr($field_id); ?>" 
						   class="formControl custom_attendee_filter" 
						   data-field-id="<?php echo esc_attr($field_id); ?>"
						   placeholder="<?php echo esc_attr(sprintf(__('Filter by %s', 'addon-bus--ticket-booking-with-seat-pro'), $field_label)); ?>"
						/>
					</label>
				</div>
				<?php
			}
			$html = ob_get_clean();
			if (empty($html)) {
				wp_send_json_success('<div class="notice notice-info"><p>' . esc_html__('No valid custom attendee fields found for this bus.', 'addon-bus--ticket-booking-with-seat-pro') . '</p></div>');
				return;
			}
			wp_send_json_success($html);
		}
		public static function get_discounted_price_for_attendee($order_id, $attendee_id, $debug = null, $context = '') {
			if ($context) {
				error_log('WBTM DEBUG: get_discounted_price_for_attendee called from ' . $context . ' for attendee ' . $attendee_id . ', order ' . $order_id);
			} else {
				error_log('WBTM DEBUG: get_discounted_price_for_attendee called for attendee ' . $attendee_id . ', order ' . $order_id);
			}
			if (!function_exists('wc_get_order')) {
				error_log('WBTM DEBUG: wc_get_order does not exist');
				return false;
			}
			$order = wc_get_order($order_id);
			if (!$order) {
				error_log('WBTM DEBUG: Order not found for order_id ' . $order_id);
				return false;
			}
			
			// Check if a coupon was actually applied to this order
			$coupon_codes = $order->get_coupon_codes();
			if (empty($coupon_codes)) {
				error_log('WBTM DEBUG: No coupon applied to order ' . $order_id . ', returning false');
				return false; // No coupon applied, return false to show original price
			}
			
			$order_total_paid = floatval($order->get_total());
			$order_total_items = 0;
			$attendee_item_total = 0;
			$attendee_found = false;
			foreach ($order->get_items() as $item) {
				$order_total_items += floatval($item->get_total());
			}
			foreach ($order->get_items() as $item) {
				$meta_attendee_ids = $item->get_meta('_wbtm_passenger_info');
				if (is_array($meta_attendee_ids) && in_array($attendee_id, $meta_attendee_ids)) {
					$attendee_item_total = floatval($item->get_total());
					$attendee_found = true;
					break;
				}
				$item_order_id = $item->get_meta('_wbtm_order_id');
				if ($item_order_id == $order_id) {
					$attendee_item_total = floatval($item->get_total());
					$attendee_found = true;
					break;
				}
			}
			if (!$attendee_found) {
				$attendee_seat = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_seat');
				foreach ($order->get_items() as $item) {
					$ticket_info = $item->get_meta('_wbtm_ticket_info');
					if (is_array($ticket_info)) {
						foreach ($ticket_info as $ticket) {
							if (isset($ticket['seat_name']) && $ticket['seat_name'] == $attendee_seat) {
								$attendee_item_total = floatval($item->get_total());
								$attendee_found = true;
								break 2;
							}
						}
					}
				}
			}
			if (!$attendee_found) {
				error_log('WBTM DEBUG: Attendee not found in order items for attendee_id ' . $attendee_id);
				return false;
			}
			if ($order_total_items == 0) {
				error_log('WBTM DEBUG: Order total items is zero for order_id ' . $order_id);
				return false;
			}
			$proportion = $attendee_item_total / $order_total_items;
			$paid_amount = $order_total_paid * $proportion;
			if (method_exists($order, 'get_total_paid')) {
				$total_paid = floatval($order->get_total_paid());
				if ($total_paid > 0 && $total_paid < $order_total_paid) {
					$paid_amount = $total_paid * $proportion;
				}
			}
			error_log('WBTM DEBUG: get_discounted_price_for_attendee returning ' . $paid_amount . ' for attendee ' . $attendee_id . ', order ' . $order_id . ' (context: ' . $context . ')');
			return $paid_amount;
		}
		public function enqueue_passenger_list_styles($hook) {
			if($hook != 'bus_page_wbtm_passenger_list') {
				return;
			}
			wp_enqueue_style('wbtm-passenger-list', plugins_url('assets/admin/css/wbtm-passenger-list.css', dirname(__FILE__)), array(), '1.0.0');
		}
	}
	new WBTM_Passenger_List();
}
// Bulk check-in/revoke AJAX handler (must be outside the class)
add_action('wp_ajax_wbtm_bulk_update_ticket_status', function() {
	$attendee_ids = isset($_POST['attendee_ids']) ? (array) $_POST['attendee_ids'] : [];
	$action_type = isset($_POST['action_type']) ? sanitize_text_field($_POST['action_type']) : 'checkin';
	if (!empty($attendee_ids)) {
		foreach ($attendee_ids as $attendee_id) {
			$attendee_id = WBTM_Global_Function::data_sanitize($attendee_id);
			if ($action_type === 'revoke') {
				if (class_exists('WBTM_QR_CODE_Functions')) {
					(new WBTM_QR_CODE_Functions())->revoke_ticket_status($attendee_id);
				}
			} else {
				if (class_exists('WBTM_QR_CODE_Functions')) {
					(new WBTM_QR_CODE_Functions())->change_ticket_status($attendee_id);
				}
			}
		}
		wp_send_json_success(['message' => 'Bulk action completed.']);
	} else {
		wp_send_json_error(['message' => 'No attendees selected.']);
	}
	wp_die();
});

// Improved pagination rendering for passenger list (buttonGroup, button elements)
add_action('wbtm_pagination_section', function($parameter, $total_passenger, $active_page) {
    $per_page = isset($parameter['show']) ? intval($parameter['show']) : 20;
    $total_pages = ($per_page > 0) ? ceil($total_passenger / $per_page) : 1;
    if ($total_pages <= 1) return;
    
    ob_start();
    ?>
    <div class="wbtm_pagination_area" style="margin: 20px 0; text-align: center; width: 100%; display: block;">
        <div class="buttonGroup" style="display: inline-flex !important; gap: 8px; align-items: center; justify-content: center; margin: 0 auto; width: auto; min-width: fit-content;">
            <?php for ($i = 0; $i < $total_pages; $i++) : 
                $active = ($i == $active_page) ? 'active_pagination' : '';
                $button_style = $active ? 'background:#2271b1;color:#fff;' : 'color:#2271b1;background:#fff;';
            ?>
                <button type="button" 
                        class="_mpBtn_xs <?php echo esc_attr($active); ?>" 
                        data-pagination="<?php echo esc_attr($i + 1); ?>" 
                        style="min-width:36px;padding:6px 16px;border:1px solid #2271b1;border-radius:3px;text-decoration:none;font-weight:500;<?php echo esc_attr($button_style); ?>;flex-shrink:0;white-space:nowrap;">
                    <?php echo esc_html($i + 1); ?>
                </button>
            <?php endfor; ?>
        </div>
    </div>
    <?php
    $pagination_html = ob_get_clean();
    
    // Use wp_kses_post to safely output HTML
    echo wp_kses_post($pagination_html);
}, 10, 3);
