<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if (!defined('ABSPATH')) {
		die;
	} // Cannot access pages directly.
	if (!class_exists('WBTM_PRO_License')) {
		class WBTM_PRO_License {
			public function __construct() {
				add_action('wbtm_addon_list', [$this, 'bus_licence'], 10);
				/*********************************************/
				add_action('wp_ajax_wbtm_pro_license_key_inactive', array($this, 'wbtm_pro_license_key_inactive'));
				add_action('wp_ajax_nopriv_wbtm_pro_license_key_inactive', array($this, 'wbtm_pro_license_key_inactive'));
				/*********************************************/
				add_action('wp_ajax_wbtm_pro_license_key_active', array($this, 'wbtm_pro_license_key_active'));
				add_action('wp_ajax_nopriv_wbtm_pro_license_key_active', array($this, 'wbtm_pro_license_key_active'));
			}
			public function bus_licence() {
				$license = get_option('wbtm_pro_license_key');
				$order_id = get_option('wbtm_pro_license_order_id');
				$expire_date = get_option('wbtm_pro_license_expire');
				$status = get_option('wbtm_pro_license_status');
				$status_text = $status && $status == 'valid' ? esc_html__('Active', 'addon-bus--ticket-booking-with-seat-pro') : esc_html__('Inactive', 'addon-bus--ticket-booking-with-seat-pro');
				$status_class = $status && $status == 'valid' ? 'textSuccess' : 'textDanger';
				//47d80f3f9e5310f58ff11a37e1c3eece
				?>
				<tr>
					<th colspan="4" class="_textLeft"><?php echo esc_html('Bus ticket booking with seat pro', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
					<th><?php esc_html_e('PRO', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
					<th> #<?php echo esc_html($order_id); ?></th>
					<th colspan="2"><?php echo esc_html(WBTM_Global_Function::check_licensee_date($expire_date)); ?></th>
					<th colspan="3">
						<label>
							<input type="text" name="wbtm_pro_license_key" id="wbtm_pro_license_key" class="formControl" value="<?php echo esc_attr($license); ?>"/>
						</label>
					</th>
					<th class="<?php echo esc_attr($status_class); ?>"><?php echo esc_html($status_text); ?></th>
					<td colspan="2">
						<?php if ($status && $status == 'valid') { ?>
							<button type="button" class="_warningButton_fullWidth" id="wbtm_pro_license_key_inactive">
								<?php esc_html_e('Inactive Licence', 'addon-bus--ticket-booking-with-seat-pro'); ?>
							</button>
						<?php } else { ?>
							<button type="button" class="_successButton_fullWidth" id="wbtm_pro_license_key_active" data-alert="<?php esc_attr_e('Please enter your valid licence key.', 'addon-bus--ticket-booking-with-seat-pro'); ?>">
								<?php esc_html_e('Active Licence', 'addon-bus--ticket-booking-with-seat-pro'); ?>
							</button>
						<?php } ?>
					</td>
				</tr>
				<?php
			}
			public function wbtm_pro_license_key_inactive() {
				update_option('wbtm_pro_license_key', '');
				update_option('wbtm_pro_license_order_id', '');
				update_option('wbtm_pro_license_expire', '');
				update_option('wbtm_pro_license_status', 'invalid');
				do_action('wbtm_basic_license_list');
				die();
			}
			public function wbtm_pro_license_key_active() {
				$license = isset($_REQUEST['key']) ? sanitize_text_field($_REQUEST['key']) : '';
				$api_params = array(
					'edd_action' => 'activate_license',
					'license' => $license,
					'item_id' => WBTM_PRO_ID,
					'url' => home_url()
				);
				// Call the custom API.
				$response = wp_remote_post(WBTM_STORE_URL, array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));
				$license_data = json_decode(wp_remote_retrieve_body($response));
				?>
				<h6 class="_mB_xs_textInfo"><?php echo esc_html(WBTM_Global_Function::license_error_text($response, $license_data, get_plugin_data(__FILE__)['Name'])); ?></h6>
				<?php
				if ($license_data->success) {
					update_option('wbtm_pro_license_key', $license);
					update_option('wbtm_pro_license_order_id', $license_data->payment_id);
					update_option('wbtm_pro_license_expire', $license_data->expires);
					update_option('wbtm_pro_license_status', 'valid');
				}
				else {
					update_option('wbtm_pro_license_key', '');
					update_option('wbtm_pro_license_order_id', '');
					update_option('wbtm_pro_license_expire', '');
					update_option('wbtm_pro_license_status', 'invalid');
				}
				do_action('wbtm_basic_license_list');
				die();
			}
		}
		new WBTM_PRO_License();
	}