<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if (!defined('ABSPATH')) {
		die;
	} // Cannot access pages directly.
	if (!class_exists('WBTM_Function_PRO')) {
		class WBTM_Function_PRO {
			public function __construct() {
				add_action('wbtm_order_status_change', array($this, 'order_status_changed'), 10, 4);
			}
			public function order_status_changed( $order_status, $post_id, $order_id ) {

				$email_status = WBTM_Global_Function::get_settings( 'wbtm_email_settings', 'pdf_email_status', array('processing','completed') );

				if ( get_post_type( $post_id ) == WBTM_Functions::get_cpt() && sizeof($email_status)>0) {
					if ( in_array( $order_status, $email_status ) ) {
						do_action( 'wbtm_send_mail', $order_id );
					}
				}
			}
			public static function order_item_data($order_id) {
				$args['wbtm_order_id'] = $order_id;
				$guest_query = self::attendee_query($args);
				$attendees = $guest_query->posts;
				$all_data = [];
				foreach ($attendees as $attendee) {
					$ticket_id = $attendee->ID;
					$item_id = WBTM_Global_Function::get_post_info($ticket_id, 'wbtm_item_id');
					if ($item_id) {
						$all_data[$item_id][] = $ticket_id;
					}else{
						$all_data[]=$ticket_id;
					}
				}
				wp_reset_postdata();
				return $all_data;
			}
			public static function attendee_query($filter_args = [], $show = -1, $page = 1, $sort_by_seat = '0') {
				$meta_query = [];
				
				// Basic filters
				if (array_key_exists('wbtm_bus_id', $filter_args) && $filter_args['wbtm_bus_id']) {
					$meta_query[] = array(
						'key' => 'wbtm_bus_id',
						'value' => $filter_args['wbtm_bus_id'],
						'compare' => '='
					);
				}

				// Journey Date
				if (array_key_exists('wbtm_start_time', $filter_args) && $filter_args['wbtm_start_time']) {
					$meta_query[] = array(
						'key' => 'wbtm_boarding_time',
						'value' => $filter_args['wbtm_start_time'],
						'compare' => 'LIKE'
					);
				}

				// Booking Date
				if (array_key_exists('wbtm_booking_date', $filter_args) && $filter_args['wbtm_booking_date']) {
					$meta_query[] = array(
						'key' => 'wbtm_booking_date',
						'value' => $filter_args['wbtm_booking_date'],
						'compare' => '='
					);
				}

				// Boarding Time
				if (array_key_exists('wbtm_boarding_time', $filter_args) && $filter_args['wbtm_boarding_time']) {
					$meta_query[] = array(
						'key' => 'wbtm_boarding_time',
						'value' => $filter_args['wbtm_boarding_time'],
						'compare' => '='
					);
				}

				// Boarding Point
				if (array_key_exists('wbtm_boarding_point', $filter_args) && $filter_args['wbtm_boarding_point']) {
					$meta_query[] = array(
						'key' => 'wbtm_boarding_point',
						'value' => $filter_args['wbtm_boarding_point'],
						'compare' => '='
					);
				}

				// Dropping Point
				if (array_key_exists('wbtm_dropping_point', $filter_args) && $filter_args['wbtm_dropping_point']) {
					$meta_query[] = array(
						'key' => 'wbtm_dropping_point',
						'value' => $filter_args['wbtm_dropping_point'],
						'compare' => '='
					);
				}

				// Order ID
				if (array_key_exists('wbtm_order_id', $filter_args) && $filter_args['wbtm_order_id']) {
					$meta_query[] = array(
						'key' => 'wbtm_order_id',
						'value' => $filter_args['wbtm_order_id'],
						'compare' => '='
					);
				}

				// User Name
				if (array_key_exists('wbtm_user_name', $filter_args) && $filter_args['wbtm_user_name']) {
					$meta_query[] = array(
						'key' => 'wbtm_user_name',
						'value' => $filter_args['wbtm_user_name'],
						'compare' => 'LIKE'
					);
				}

				// User Email
				if (array_key_exists('wbtm_user_email', $filter_args) && $filter_args['wbtm_user_email']) {
					$meta_query[] = array(
						'key' => 'wbtm_user_email',
						'value' => $filter_args['wbtm_user_email'],
						'compare' => 'LIKE'
					);
				}

				// User Phone
				if (array_key_exists('wbtm_user_phone', $filter_args) && $filter_args['wbtm_user_phone']) {
					$meta_query[] = array(
						'key' => 'wbtm_user_phone',
						'value' => $filter_args['wbtm_user_phone'],
						'compare' => 'LIKE'
					);
				}

				// Handle default form field filtering
				$default_fields_map = [
					'wbtm_full_name' => ['meta_key' => 'wbtm_user_name', 'label' => 'Passenger Name'],
					'wbtm_reg_email' => ['meta_key' => 'wbtm_user_email', 'label' => 'Passenger Email'],
					'wbtm_reg_phone' => ['meta_key' => 'wbtm_user_phone', 'label' => 'Passenger Phone'],
					'wbtm_reg_address' => ['meta_key' => 'wbtm_user_address', 'label' => 'Passenger Address']
				];

				foreach ($default_fields_map as $form_field => $meta_info) {
					if (array_key_exists($form_field, $filter_args) && $filter_args[$form_field]) {
						$value = $filter_args[$form_field];
						
						// Create a meta query for this field
						$field_meta_query = array(
							'relation' => 'OR',
							// Search in direct meta field
							array(
								'key' => $meta_info['meta_key'],
								'value' => $value,
								'compare' => 'LIKE'
							),
							// Search in wbtm_attendee_info serialized array
							array(
								'key' => 'wbtm_attendee_info',
								'value' => $value,
								'compare' => 'LIKE'
							)
						);

						$meta_query[] = $field_meta_query;
					}
				}

				// Handle custom field filtering
				foreach ($filter_args as $key => $value) {
					if (strpos($key, 'wbtm_custom_') === 0 && $value) {
						$field_id = str_replace('wbtm_custom_', '', $key);
						
						// Create a meta query for this custom field
						$custom_field_meta_query = array(
							'relation' => 'OR',
							array(
								'key' => $field_id,
								'value' => $value,
								'compare' => 'LIKE'
							),
							array(
								'key' => 'wbtm_attendee_info',
								'value' => $value,
								'compare' => 'LIKE'
							)
						);

						$meta_query[] = $custom_field_meta_query;
					}
				}
				
				// Add order status condition
				$meta_query[] = array(
					'relation' => 'OR',
					array(
						'key' => 'wbtm_order_status',
						'value' => 'partially-paid',
						'compare' => '='
					),
					array(
						'key' => 'wbtm_order_status',
						'value' => ['completed', 'processing'],
						'compare' => 'IN'
					)
				);

				// Build WP_Query arguments
				$args = array(
					'post_type' => 'wbtm_bus_booking',
					'posts_per_page' => $show,
					'paged' => $page,
					'meta_query' => $meta_query
				);

				// Add sorting based on sort_by_seat parameter
				if ($sort_by_seat === '1') {
					// Sort by seat number
					$args['meta_key'] = 'wbtm_seat';
					$args['orderby'] = 'meta_value';
					$args['order'] = 'ASC';
				} else {
					// Default sorting by date
					$args['orderby'] = 'date';
					$args['order'] = 'DESC';
				}

				$query = new WP_Query($args);
				
				// If sorting by seat is enabled, we need to do custom sorting after the query
				if ($sort_by_seat === '1' && $query->have_posts()) {
					$posts = $query->posts;
					
					// Custom sorting function for seat numbers
					usort($posts, function($a, $b) {
						$seat_a = WBTM_Global_Function::get_post_info($a->ID, 'wbtm_seat');
						$seat_b = WBTM_Global_Function::get_post_info($b->ID, 'wbtm_seat');
						
						// If no seat numbers found, return 0 (no change)
						if (empty($seat_a) && empty($seat_b)) return 0;
						if (empty($seat_a)) return 1; // seats without numbers go to end
						if (empty($seat_b)) return -1;
						
						// Extract numeric part from seat numbers (e.g., "A1" -> 1, "B12" -> 12)
						$num_a = intval(preg_replace('/[^0-9]/', '', $seat_a)) ?: 0;
						$num_b = intval(preg_replace('/[^0-9]/', '', $seat_b)) ?: 0;
						
						// Extract letter part from seat numbers (e.g., "A1" -> "A", "B12" -> "B")
						$letter_a = strtoupper(preg_replace('/[^A-Za-z]/', '', $seat_a));
						$letter_b = strtoupper(preg_replace('/[^A-Za-z]/', '', $seat_b));
						
						// First sort by letter (row), then by number (column)
						if ($letter_a !== $letter_b) {
							return strcmp($letter_a, $letter_b);
						}
						return $num_a - $num_b;
					});
					
					// Update the query posts with sorted results
					$query->posts = $posts;
				}

				return $query;
			}
			public static function get_extra_bag_info($post_id) {
				$ex_bag_infos = WBTM_Global_Function::get_post_info($post_id, 'wbtm_ex_bag_info', []);
				if (sizeof($ex_bag_infos) < 1) {
					$ex_bag_infos = [
						'max_qty' => WBTM_Global_Function::get_post_info($post_id, 'wbtm_extra_max_qty'),
						'price' => WBTM_Global_Function::get_post_info($post_id, 'wbtm_extra_bag_price'),
						'field_label' => esc_html__('Extra Bag', 'addon-bus--ticket-booking-with-seat-pro'),
						'active' => WBTM_Global_Function::get_post_info($post_id, 'wbtm_user_extra_bag'),
					];
					delete_post_meta($post_id, 'wbtm_extra_max_qty');
					delete_post_meta($post_id, 'wbtm_extra_bag_price');
					delete_post_meta($post_id, 'wbtm_user_extra_bag');
					update_post_meta($post_id, 'wbtm_ex_bag_info', $ex_bag_infos);
				}
				return $ex_bag_infos;
			}
			public static function get_attendee_info($attendee_id) {
				
				$attendee_data = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_attendee_info', []);
				
				if (is_array($attendee_data) && sizeof($attendee_data) == 0) {
					
					$user_additional = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_additional', []);
					$attendee_infos = WBTM_Attendee_form::default_form();
					if (sizeof($attendee_infos) > 0) {
						foreach ($attendee_infos as $form) {
							$name = array_key_exists('field_id', $form) ? $form['field_id'] : '';
							$attendee_data = WBTM_Global_Function::get_post_info($attendee_id, $name);
							
							if ($attendee_data) {
								$label = array_key_exists('field_label', $form) ? $form['field_label'] : $form['d_label'];
								$user_additional[] = [
									'name' => $label,
									'value' => $attendee_data,
								];
							}
						}
						$extra_bag = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_bag_qty');
						if ($extra_bag > 0) {
							$user_additional[] = [
								'name' => esc_html__('Extra Bag', 'addon-bus--ticket-booking-with-seat-pro'),
								'value' => $extra_bag,
							];
						}
					}
					update_post_meta($attendee_id, 'wbtm_attendee_info', $user_additional);
					$attendee_data = $user_additional;
					
				}
				
				return $attendee_data;
			}
			public function filter_passenger_list($filter_args, $show = 20, $page = 1) {
				$seat_booked_status = array('completed', 'processing');
				$meta_query = [];
				
				// Basic filters
				if (array_key_exists('wbtm_bus_id', $filter_args) && $filter_args['wbtm_bus_id']) {
					$meta_query[] = array(
						'key' => 'wbtm_bus_id',
						'value' => $filter_args['wbtm_bus_id'],
						'compare' => '='
					);
				}
				if (array_key_exists('wbtm_journey_date', $filter_args) && $filter_args['wbtm_journey_date']) {
					$meta_query[] = array(
						'key' => 'wbtm_journey_date',
						'value' => $filter_args['wbtm_journey_date'],
						'compare' => '='
					);
				}
				if (array_key_exists('wbtm_order_date', $filter_args) && $filter_args['wbtm_order_date']) {
					$meta_query[] = array(
						'key' => 'wbtm_order_date',
						'value' => $filter_args['wbtm_order_date'],
						'compare' => '='
					);
				}
				if (array_key_exists('wbtm_boarding_point_date', $filter_args) && $filter_args['wbtm_boarding_point_date']) {
					$meta_query[] = array(
						'key' => 'wbtm_boarding_point_date',
						'value' => $filter_args['wbtm_boarding_point_date'],
						'compare' => '='
					);
				}
				if (array_key_exists('wbtm_boarding_point', $filter_args) && $filter_args['wbtm_boarding_point']) {
					$meta_query[] = array(
						'key' => 'wbtm_boarding_point',
						'value' => $filter_args['wbtm_boarding_point'],
						'compare' => '='
					);
				}
				if (array_key_exists('wbtm_order_id', $filter_args) && $filter_args['wbtm_order_id']) {
					$meta_query[] = array(
						'key' => 'wbtm_order_id',
						'value' => $filter_args['wbtm_order_id'],
						'compare' => '='
					);
				}
				if (array_key_exists('wbtm_user_name', $filter_args) && $filter_args['wbtm_user_name']) {
					$meta_query[] = array(
						'key' => 'wbtm_user_name',
						'value' => $filter_args['wbtm_user_name'],
						'compare' => '='
					);
				}
				if (array_key_exists('wbtm_user_email', $filter_args) && $filter_args['wbtm_user_email']) {
					$meta_query[] = array(
						'key' => 'wbtm_user_email',
						'value' => $filter_args['wbtm_user_email'],
						'compare' => '='
					);
				}
				if (array_key_exists('wbtm_user_phone', $filter_args) && $filter_args['wbtm_user_phone']) {
					$meta_query[] = array(
						'key' => 'wbtm_user_phone',
						'value' => $filter_args['wbtm_user_phone'],
						'compare' => '='
					);
				}

				// Handle custom field filtering
				foreach ($filter_args as $key => $value) {
					if (strpos($key, 'wbtm_custom_') === 0) {
						$field_id = str_replace('wbtm_custom_', '', $key);
						
						// Search in serialized data with multiple patterns
						$meta_query[] = array(
							'relation' => 'OR',
							array(
								'key' => 'wbtm_attendee_info',
								'value' => '"' . $field_id . '"',
								'compare' => 'LIKE'
							),
							array(
								'key' => 'wbtm_attendee_info',
								'value' => '"' . $value . '"',
								'compare' => 'LIKE'
							),
							array(
								'key' => 'wbtm_user_additional',
								'value' => '"' . $field_id . '"',
								'compare' => 'LIKE'
							),
							array(
								'key' => 'wbtm_user_additional',
								'value' => '"' . $value . '"',
								'compare' => 'LIKE'
							),
							array(
								'key' => $field_id,
								'value' => $value,
								'compare' => '='
							)
						);
					}
				}

				// Add order status condition
				$meta_query[] = array(
					'relation' => 'OR',
					array(
						'key' => 'wbtm_order_status',
						'value' => 'partially-paid',
						'compare' => '='
					),
					array(
						'key' => 'wbtm_order_status',
						'value' => $seat_booked_status,
						'compare' => 'IN'
					)
				);

				$args = array(
					'post_type' => 'wbtm_bus_booking',
					'posts_per_page' => $show,
					'paged' => $page,
					'meta_query' => array(
						'relation' => 'AND',
						$meta_query
					)
				);

				return get_posts($args);
			}
		}
		new WBTM_Function_PRO();
	}