<?php
	if ( ! defined( 'ABSPATH' ) ) {
		die;
	} // Cannot access pages directly.
	if ( ! class_exists( 'WBTM_CSV' ) ) {
		class WBTM_CSV {
			public function __construct() {
				add_action( 'wp_ajax_wbtm_download_csv', array( $this, 'wbtm_download_csv' ) );
				add_action( 'wp_ajax_nopriv_wbtm_download_csv', array( $this, 'wbtm_download_csv' ) );
			}
			public function wbtm_download_csv() {
				if ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] == 'wbtm_download_csv' && $_REQUEST['document_type'] == 'csv' ) {
					if ( ! current_user_can( 'manage_options' ) || ! is_admin() ) {
						return false;
					}
					ob_start();
					
					// Read filter arguments the same way as PDF function
					$order_id = WBTM_Global_Function::get_submit_info_get_method('wbtm_order_id');
					$attendee_id = WBTM_Global_Function::get_submit_info_get_method('attendee_id');
					$bus_id = WBTM_Global_Function::get_submit_info_get_method('wbtm_bus_id');
					$date = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time');
					
					$args = array();
					$args['attendee_id'] = $attendee_id;
					$args['wbtm_bus_id'] = $bus_id;
					$args['wbtm_booking_date'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date');
					$args['wbtm_booking_date_from'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date_from');
					$args['wbtm_booking_date_to'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_booking_date_to');
					$args['wbtm_start_time'] = $date;
					$args['wbtm_start_time_from'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time_from');
					$args['wbtm_start_time_to'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_start_time_to');
					$args['wbtm_boarding_time'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_boarding_time');
					$args['wbtm_boarding_point'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_boarding_point');
					$args['wbtm_dropping_point'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_dropping_point');
					$args['wbtm_order_id'] = $order_id;
					$args['wbtm_user_name'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_name');
					$args['wbtm_user_email'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_email');
					$args['wbtm_user_phone'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_user_phone');
					$args['sort_by_seat'] = WBTM_Global_Function::get_submit_info_get_method('sort_by_seat');
					$args['show_coupon_price'] = WBTM_Global_Function::get_submit_info_get_method('show_coupon_price');
					$args['wbtm_full_name'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_full_name');
					$args['wbtm_reg_email'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_reg_email');
					$args['wbtm_reg_phone'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_reg_phone');
					$args['wbtm_reg_address'] = WBTM_Global_Function::get_submit_info_get_method('wbtm_reg_address');
					
					$filename   = 'Bus_passenger_Export_' . $_SERVER['SERVER_NAME'] . '_' . time() . '.csv';
					$header_row = $this->csv_header();
					
					$data_rows  = $this->csv_data( $args);
					
					// Action hook to allow other addons to modify CSV headers
					$header_row = apply_filters('wbtm_csv_headers', $header_row, $args);
					
					// Action hook to allow other addons to modify CSV data
					$data_rows = apply_filters('wbtm_csv_data', $data_rows, $args);
					
					$fh         = @fopen( 'php://output', 'w' );
					fprintf( $fh, chr( 0xEF ) . chr( 0xBB ) . chr( 0xBF ) );
					header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
					header( 'Content-Description: File Transfer' );
					header( 'Content-type: text/csv' );
					header( "Content-Disposition: attachment; filename={$filename}" );
					header( 'Expires: 0' );
					header( 'Pragma: public' );
					if ( sizeof( $data_rows ) > 0 ) {
						fputcsv( $fh, $header_row );
						foreach ( $data_rows as $data_row ) {
							fputcsv( $fh, $data_row );
						}
					} else {
						fputcsv( $fh, array( esc_html__( 'No Data Found !', 'addon-bus--ticket-booking-with-seat-pro' ) ) );
					}
					fclose( $fh );
					ob_end_flush();
				}
				die();
			}
			public function csv_header(): array {
				$header = [];
				$show_bus_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_bus_name', 'on');
				$show_bus_id = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_bus_id', 'on');
				$show_price = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_price', 'on');
				$show_pin = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_pin', 'on');
				$show_order_id = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_order_id', 'on');
				$show_seat_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_seat_name', 'on');
				$show_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_name', 'on');
				$show_phone = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_phone', 'on');
				$show_email = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_email', 'on');
				$show_address = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_address', 'on');
				$show_extra_service = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_extra_service', 'on');
				$show_from_to = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_from_to', 'on');
				$show_pick_drop = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_pickup_drop_off', 'on');
				$show_journey_date = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_journey_date', 'on');

				if ($show_bus_name != 'off') {
					$header[] = esc_html__('Bus Name', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_bus_id != 'off') {
					$header[] = esc_html__('Bus No', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_order_id != 'off') {
					$header[] = esc_html__('Order ID', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_pin != 'off') {
					$header[] = esc_html__('PIN', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_journey_date != 'off') {
					$header[] = esc_html__('Journey Date', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_seat_name != 'off') {
					$header[] = esc_html__('Seat', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_name != 'off') {
					$header[] = esc_html__('Passenger Name', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_phone != 'off') {
					$header[] = esc_html__('Phone', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_email != 'off') {
					$header[] = esc_html__('Email', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_address != 'off') {
					$header[] = esc_html__('Address', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_extra_service != 'off') {
					$header[] = esc_html__('Extra Service', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_from_to != 'off') {
					$header[] = esc_html__('From => To', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_pick_drop != 'off') {
					$header[] = esc_html__('Pickup Point', 'addon-bus--ticket-booking-with-seat-pro');
					$header[] = esc_html__('Drop-off Point', 'addon-bus--ticket-booking-with-seat-pro');
				}
				if ($show_price != 'off') {
					$header[] = esc_html__('Price', 'addon-bus--ticket-booking-with-seat-pro');
				}

				// Add additional passenger info headers
				$header[] = esc_html__('Passenger Type', 'addon-bus--ticket-booking-with-seat-pro');
				$header[] = esc_html__('Booking Date', 'addon-bus--ticket-booking-with-seat-pro');
				$header[] = esc_html__('Boarding Time', 'addon-bus--ticket-booking-with-seat-pro');
				$header[] = esc_html__('Order Status', 'addon-bus--ticket-booking-with-seat-pro');
				$header[] = esc_html__('Extra Bag Qty', 'addon-bus--ticket-booking-with-seat-pro');

				return $header;
			}
			public function csv_data($args): array {
				$show_bus_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_bus_name', 'on');
				$show_bus_id = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_bus_id', 'on');
				$show_price = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_price', 'on');
				$show_pin = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_pin', 'on');
				$show_order_id = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_order_id', 'on');
				$show_seat_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_seat_name', 'on');
				$show_name = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_name', 'on');
				$show_phone = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_phone', 'on');
				$show_email = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_email', 'on');
				$show_address = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_address', 'on');
				$show_extra_service = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_extra_service', 'on');
				$show_from_to = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_from_to', 'on');
				$show_pick_drop = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_pickup_drop_off', 'on');
				$show_journey_date = WBTM_Global_Function::get_settings('wbtm_passenger_csv_settings', 'csv_journey_date', 'on');

				$data = array();
				
				// Get sorting preference
				$sort_by_seat = array_key_exists('sort_by_seat', $args) ? $args['sort_by_seat'] : '0';
				
				$all_passengers = WBTM_Function_PRO::attendee_query($args, -1, 1, $sort_by_seat);
				
				if ($all_passengers->found_posts > 0) {
					$attendee_query = $all_passengers->posts;
					$count = 0;
					foreach ($attendee_query as $_attendee) {
						$attendee_id = $_attendee->ID;
						$post_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_id');
						$order_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_id');
						$bp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_point');
						$dp = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_dropping_point');
						$order_status = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_status');
						$journey_date = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_time');
						$journey_date = $journey_date ? WBTM_Global_Function::date_format($journey_date, 'full') : '';
						$booking_date = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_booking_date');
						$boarding_time = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_boarding_time');
						$passenger_type = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_ticket');
						$extra_bag_qty = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_extra_bag_qty');

						// Calculate paid amount including extra services
						if ($order_status == 'partially-paid') {
							$paid_amount = WBTM_Global_Function::get_post_info($order_id, '_order_total');
							$paid_amount = $paid_amount + WBTM_Passenger_List::ex_service_price($attendee_id);
						} else {
							$paid_amount = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_fare');
							$paid_amount = $paid_amount + WBTM_Passenger_List::ex_service_price($attendee_id);
						}

						$row = array();

						if ($show_bus_name != 'off') {
							$row[] = get_the_title($post_id);
						}
						if ($show_bus_id != 'off') {
							$row[] = WBTM_Global_Function::get_post_info($post_id, 'wbtm_bus_no');
						}
						if ($show_order_id != 'off') {
							$row[] = $order_id;
						}
						if ($show_pin != 'off') {
							$row[] = $attendee_id;
						}
						if ($show_journey_date != 'off') {
							$row[] = $journey_date;
						}
						if ($show_seat_name != 'off') {
							$row[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_seat');
						}
						if ($show_name != 'off') {
							$row[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_name');
						}
						if ($show_phone != 'off') {
							$row[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_phone');
						}
						if ($show_email != 'off') {
							$row[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_email');
						}
						if ($show_address != 'off') {
							$row[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_user_address');
						}
						if ($show_extra_service != 'off') {
							$row[] = WBTM_Passenger_List::extra_service($attendee_id);
						}
						if ($show_from_to != 'off') {
							$row[] = $bp . ' => ' . $dp;
						}
						if ($show_pick_drop != 'off') {
							$row[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_pickup_point');
							$row[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_drop_off_point');
						}
						if ($show_price != 'off') {
							$show_coupon_price = isset($args['show_coupon_price']) ? $args['show_coupon_price'] : '';
							if ($show_coupon_price == '1') {
								$discounted_price = WBTM_Passenger_List::get_discounted_price_for_attendee($order_id, $attendee_id, null, 'csv');
								if ($discounted_price !== false) {
									$row[] = $discounted_price;
								} else {
									$row[] = $paid_amount;
								}
							} else {
								$row[] = $paid_amount;
							}
						}

						// Add additional passenger info
						$row[] = $passenger_type;
						$row[] = WBTM_Global_Function::date_format($booking_date, 'date');
						$row[] = WBTM_Global_Function::date_format($boarding_time, 'time');
						$row[] = $order_status;
						$row[] = $extra_bag_qty;

						$data[$count] = $row;
						$count++;
					}
				}
				return $data;
			}
			
			/**
			 * Get CSV download URL for sales report
			 * 
			 * @param array $args Filter arguments
			 * @return string CSV download URL
			 */
			public static function get_csv_url($args = array()) {
				$default_args = array(
					'action' => 'wbtm_download_csv',
					'document_type' => 'csv'
				);
				$args = wp_parse_args($args, $default_args);
				$build_url = http_build_query($args);
				$nonce_url = wp_nonce_url(admin_url("admin-ajax.php?" . $build_url), $args['action']);
				return apply_filters('wbtm_filter_csv_url', $nonce_url);
			}
		}
		new WBTM_CSV();
	}