<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if ( ! defined( 'ABSPATH' ) ) {
		die;
	} // Cannot access pages directly.
	if ( ! class_exists( 'WBTM_Attendee_form' ) ) {
		class WBTM_Attendee_form {
			public function __construct() {
				add_action( 'wbtm_attendee_form', [ $this, 'attendee_form' ] );
				add_action( 'wbtm_attendee_form_hidden', [ $this, 'attendee_form_hidden' ] );
				add_filter( 'add_wbtm_user_info_data', [ $this, 'wbtm_user_info_data' ], 10, 3 );
				add_action( 'add_wbtm_after_cart_ticket_info', [ $this, 'cart_ticket_info' ], 10, 3 );
			}

			public function attendee_form( $post_id ) {
				if ( $this->check_form_exit( $post_id ) ) {
					?>
<div class="_dLayout_xs col_12 wbtm_attendee_area">
                    </div>
					<?php
				}
				//echo '<pre>'; print_r($attendee_infos); echo '</pre>';
				//echo '<pre>'; print_r($custom_infos); echo '</pre>';
			}

			public function attendee_form_hidden( $post_id ) {
				$attendee_infos = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_attendee_info', [] );
				$custom_infos   = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_custom_attendee_info', [] );
				if ( sizeof( $attendee_infos ) > 0 || sizeof( $custom_infos ) > 0 ) {
					?>
<div class="wbtm_hidden_form">

						<div class="mpPanel_xs wbtm_attendee_item " data-seat_name>

							<div class="mpPanelHeader _bgLight">
								<h5 class="_textTheme">
									<?php echo WBTM_Translations::text_passenger_info(); ?> :
									<span class="wbtm_seat_name"></span>
								</h5>
							</div>
							<div class="mpPanelBody _bgWhite flexWrap justifyBetween">
								<?php foreach ($attendee_infos as $attendee_info) { ?>
									<?php $this->form_item($attendee_info); ?>
								<?php } ?>
								<?php if ( sizeof( $custom_infos ) > 0 ) { ?>
									<?php foreach ( $custom_infos as $custom_info ) { ?>
										<?php $this->form_item( $custom_info ); ?>
									<?php } ?>
								<?php } ?>
                            </div>
                        </div>
                    </div>
					<?php
				}
				//echo '<pre>'; print_r($attendee_infos); echo '</pre>';
				//echo '<pre>'; print_r($custom_infos); echo '</pre>';
			}

			public function check_form_exit( $post_id ) {
				$attendee_infos = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_attendee_info', [] );
				if ( sizeof( $attendee_infos ) > 0 ) {
					foreach ( $attendee_infos as $attendee_info ) {
						$active = array_key_exists( 'active', $attendee_info ) ? $attendee_info['active'] : '';
						if ( $active ) {
							return true;
						}
					}
				}
				$custom_infos = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_custom_attendee_info', [] );
				if ( sizeof( $custom_infos ) > 0 ) {
					return true;
				}

				return false;
			}

			public function form_item( $form ) {
				$active = array_key_exists( 'active', $form ) ? $form['active'] : '';
				if ( $active ) {
					$name             = array_key_exists( 'field_id', $form ) ? $form['field_id'] . '[]' : '';
					$type             = array_key_exists( 'filed_type', $form ) ? $form['filed_type'] : '';
					$required         = array_key_exists( 'required', $form ) && $form['required'] == 1 ? 'required' : '';
					$label            = array_key_exists( 'field_label', $form ) ? $form['field_label'] : $form['d_label'];
					$d_value          = array_key_exists( 'd_value', $form ) ? $form['d_value'] : '';
					$validation_class = '';
					if ( $type == 'text' || $type == 'number' || $type == 'email' ) {
						$validation_class = $type == 'text' ? 'wbtm_name_validation' : $validation_class;
						$validation_class = $type == 'number' ? 'wbtm_number_validation' : $validation_class;
						?>
                        <label class="mp_form_item fdColumn">
										<span>
											<?php echo esc_html( $label ); ?>
											<?php if ( $required ) { ?>
                                                <sup class="textRequired">*</sup>
											<?php } ?>
										</span>
                            <input type="<?php echo esc_attr( $type ); ?>" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $d_value ); ?>" class="formControl <?php echo esc_attr( $validation_class ); ?>" placeholder="<?php echo esc_attr( $label ); ?>" title="<?php echo esc_attr( $label ); ?>" <?php echo esc_attr( $required ); ?> />
                        </label>
						<?php
					}
					if ( $type == 'date' ) {
						$date         = $d_value;
						$date_format  = WBTM_Global_Function::date_picker_format();
						$hidden_date  = $date ? date( 'Y-m-d', strtotime( $date ) ) : '';
						$visible_date = $date ? date_i18n( $date_format, strtotime( $date ) ) : '';
						?>
                        <label class="mp_form_item fdColumn">
										<span>
											<?php echo esc_html( $label ); ?>
											<?php if ( $required ) { ?>
                                                <sup class="textRequired">*</sup>
											<?php } ?>
										</span>
                            <input type="hidden" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $hidden_date ); ?>" <?php echo esc_attr( $required ); ?> />
                            <input type="text" value="<?php echo esc_attr( $visible_date ); ?>" class="date_type formControl" placeholder="<?php echo esc_attr( $label ); ?>" title="<?php echo esc_attr( $label ); ?>" readonly/>
                        </label>
						<?php
					}
					if ( $type == 'textarea' ) {
						?>
                        <label class="mp_form_item fdColumn">
										<span>
											<?php echo esc_html( $label ); ?>
											<?php if ( $required ) { ?>
                                                <sup class="textRequired">*</sup>
											<?php } ?>
										</span>
                            <textarea name="<?php echo esc_attr( $name ); ?>" rows="3" class="formControl" placeholder="<?php echo esc_attr( $label ); ?>" title="<?php echo esc_attr( $label ); ?>"  <?php echo esc_attr( $required ); ?>><?php echo esc_html( $d_value ); ?></textarea>
                        </label>
						<?php
					}
					if ( $type == 'select' ) {
						$options = array_key_exists( 'args', $form ) ? $form['args'] : '';
						$options = $options ? explode( ',', $options ) : '';
						if ( is_array( $options ) && sizeof( $options ) > 0 ) {
							?>
                            <label class="mp_form_item fdColumn">
											<span>
												<?php echo esc_html( $label ); ?>
												<?php if ( $required ) { ?>
                                                    <sup class="textRequired">*</sup>
												<?php } ?>
											</span>
                                <select name="<?php echo esc_attr( $name ); ?>" class="formControl" title="<?php echo esc_attr( $label ); ?>" <?php echo esc_attr( $required ); ?>>
                                    <option value="" disabled selected><?php echo WBTM_Translations::text_please_select() . ' ' . esc_html( $label ); ?></option>
									<?php
										foreach ( $options as $option ) {
											?>
                                            <option value="<?php echo esc_attr( $option ); ?>" <?php echo esc_attr( $option == $d_value ? 'selected' : '' ); ?>><?php echo esc_html( $option ); ?></option>
											<?php
										}
									?>
                                </select>
                            </label>
							<?php
						}
					}
					if ( $type == 'select_gender' ) {
						$options = array_key_exists( 'args', $form ) ? $form['args'] : [];
						if ( sizeof( $options ) > 0 ) {
							?>
                            <label class="mp_form_item fdColumn">
											<span>
												<?php echo esc_html( $label ); ?>
												<?php if ( $required ) { ?>
                                                    <sup class="textRequired">*</sup>
												<?php } ?>
											</span>
                                <select name="<?php echo esc_attr( $name ); ?>" class="formControl" title="<?php echo esc_attr( $label ); ?>" <?php echo esc_attr( $required ); ?>>
									<?php
										foreach ( $options as $option ) {
											?>
                                            <option value="<?php echo esc_attr( $option['value'] ); ?>" <?php echo esc_attr( $option['value'] == $d_value ? 'selected' : '' ); ?>><?php echo esc_html( $option['label'] ); ?></option>
											<?php
										}
									?>
                                </select>
                            </label>
							<?php
						}
					}
					if ( $type == 'checkbox' ) {
						$options = array_key_exists( 'args', $form ) ? $form['args'] : '';
						$options = $options ? explode( ',', $options ) : '';
						if ( is_array( $options ) && sizeof( $options ) > 0 ) {
							?>
                            <div class="fdColumn mp_form_item">
								<span class="_fs_label">
									<?php echo esc_html( $label ); ?>
									<?php if ( $required ) { ?>
                                        <sup class="textRequired">*</sup>
									<?php } ?>
								</span>
                                <div class="groupCheckBox flexWrap">
                                    <input type="hidden" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $d_value ); ?>"/>
									<?php foreach ( $options as $option ) { ?>
                                        <label class="customCheckboxLabel _mR">
                                            <input type="checkbox" <?php echo esc_attr( $option == $d_value ? 'checked' : '' ); ?> data-checked="<?php echo esc_attr( $option ); ?>"/>
                                            <span class="customCheckbox"><?php echo esc_html( $option ); ?></span>
                                        </label>
									<?php } ?>
                                </div>
                            </div>
							<?php
						}
					}
					if ( $type == 'radio' ) {
						$options = array_key_exists( 'args', $form ) ? $form['args'] : '';
						$options = $options ? explode( ',', $options ) : '';
						if ( is_array( $options ) && sizeof( $options ) > 0 ) {
							?>
                            <div class="fdColumn mp_form_item groupRadioCheck">
								<span class="_fs_label">
									<?php echo esc_html( $label ); ?>
									<?php if ( $required ) { ?>
                                        <sup class="textRequired">*</sup>
									<?php } ?>
								</span>
                                <input type="hidden" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $d_value ); ?>"/>
                                <div class="flexWrap">
									<?php
										foreach ( $options as $option ) {
											?>
                                            <button type="button" class="_mpBtn_mR <?php echo esc_attr( $option == $d_value ? 'mpActive' : '' ); ?>" data-radio-check="<?php echo esc_attr( $option ); ?>" data-open-icon="fas fa-check" data-close-icon="">
                                                <span data-icon class="_mR_xs <?php echo esc_attr( $option == $d_value ? 'fas fa-check' : '' ); ?>"></span><?php echo esc_html( $option ); ?>
                                            </button>
											<?php
										}
									?>
                                </div>
                            </div>
							<?php
						}
					}
				}
			}

			public function wbtm_user_info_data( $all_infos, $post_id, $ticket_infos ) {
				$attendee_infos = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_attendee_info', [] );
				$custom_infos   = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_custom_attendee_info', [] );
				if ( sizeof( $ticket_infos ) > 0 && ( sizeof( $attendee_infos ) > 0 || sizeof( $custom_infos ) > 0 ) ) {
					foreach ( $attendee_infos as $form ) {
						$all_infos = $this->push_user_data( $form, $ticket_infos, $all_infos );
					}
					if ( sizeof( $custom_infos ) > 0 ) {
						foreach ( $custom_infos as $form ) {
							$all_infos = $this->push_user_data( $form, $ticket_infos, $all_infos );
						}
					}
					//$all_infos[]=$attendee_infos;
					//$all_infos[]=$custom_infos;
				}

				return $all_infos;
			}

			public function push_user_data($form, $ticket_infos, $all_infos) {
				$active = array_key_exists('active', $form) ? $form['active'] : '';
				if ($active) {
					$name = array_key_exists('field_id', $form) ? $form['field_id'] : '';
					$label = array_key_exists('field_label', $form) ? $form['field_label'] : $form['d_label'];
					$value = $name ? WBTM_Global_Function::get_submit_info($name, []) : '';
                    $count=0;
					if ($name && sizeof($value) > 0) {
						foreach ($ticket_infos as $ticket_info) {
                            $qty=array_key_exists('ticket_qty',$ticket_info) && $ticket_info['ticket_qty']>0 ? $ticket_info['ticket_qty'] : 1;
                            for ($i=0; $i < $qty; $i++) {
	                            $all_infos[$count][$name] = [
		                            'name' => $label,
		                            'value' => $value[$count],
	                            ];
                                $count++;
                            }


						}
					}
				}

				return $all_infos;
			}

			public function cart_ticket_info( $cart_item, $key ) {
				$passenger_infos = array_key_exists( 'wbtm_passenger_info', $cart_item ) ? $cart_item['wbtm_passenger_info'] : [];
				$bus_id          = array_key_exists( 'wbtm_bus_id', $cart_item ) ? $cart_item['wbtm_bus_id'] : '';
				$seat_type       = WBTM_Global_Function::get_post_info( $bus_id, 'wbtm_seat_type_conf' );
				if ( $seat_type == 'wbtm_seat_plan' ) {
					$passenger_infos = array_key_exists( $key, $passenger_infos ) ? $passenger_infos[ $key ] : [];
					if ( sizeof( $passenger_infos ) > 0 ) {
						foreach ( $passenger_infos as $passenger_info ) {
							?>
                            <li>
                                <h6 class="_mR_xs"><?php echo esc_html( $passenger_info['name'] ); ?></h6>
                                <span><?php echo esc_html( $passenger_info['value'] ); ?></span>
                            </li>
							<?php
						}
					}
				} else {
					if ( sizeof( $passenger_infos ) > 0 ) {
						// Get the passenger info for the current key
						$current_passenger_info = array_key_exists( $key, $passenger_infos ) ? $passenger_infos[$key] : [];
						if (is_array($current_passenger_info)) {
							foreach ($current_passenger_info as $info) {
								?>
								<li>
									<h6 class="_mR_xs"><?php echo esc_html( $info['name'] ); ?></h6>
									<span><?php echo esc_html( $info['value'] ); ?></span>
								</li>
								<?php
							}
						}
					}
				}
			}

			public static function default_form() {
				$form['wbtm_full_name']   = [
					'field_id'    => 'wbtm_full_name',
					'filed_type'  => 'text',
					'required'    => 1,
					'field_label' => esc_html__( 'Passenger Name', 'addon-bus--ticket-booking-with-seat-pro' ),
					'd_label'     => esc_html__( 'Passenger Name', 'addon-bus--ticket-booking-with-seat-pro' ),
					'active'      => '',
				];
				$form['wbtm_reg_email']   = [
					'field_id'    => 'wbtm_reg_email',
					'filed_type'  => 'email',
					'required'    => 1,
					'field_label' => esc_html__( 'Passenger Email', 'addon-bus--ticket-booking-with-seat-pro' ),
					'd_label'     => esc_html__( 'Passenger Email', 'addon-bus--ticket-booking-with-seat-pro' ),
					'active'      => '',
				];
				$form['wbtm_reg_phone']   = [
					'field_id'    => 'wbtm_reg_phone',
					'filed_type'  => 'text',
					'required'    => 1,
					'field_label' => esc_html__( 'Passenger Phone', 'addon-bus--ticket-booking-with-seat-pro' ),
					'd_label'     => esc_html__( 'Passenger Phone', 'addon-bus--ticket-booking-with-seat-pro' ),
					'active'      => '',
				];
				$form['wbtm_reg_address'] = [
					'field_id'    => 'wbtm_reg_address',
					'filed_type'  => 'textarea',
					'required'    => 1,
					'field_label' => esc_html__( 'Passenger Address', 'addon-bus--ticket-booking-with-seat-pro' ),
					'd_label'     => esc_html__( 'Passenger Address', 'addon-bus--ticket-booking-with-seat-pro' ),
					'active'      => '',
				];
				$form['wbtm_user_gender'] = [
					'field_id'    => 'wbtm_user_gender',
					'filed_type'  => 'select_gender',
					'required'    => 1,
					'field_label' => esc_html__( 'Gender', 'addon-bus--ticket-booking-with-seat-pro' ),
					'd_label'     => esc_html__( 'Gender', 'addon-bus--ticket-booking-with-seat-pro' ),
					'active'      => '',
					'args'        => [
						[
							'value' => 'male',
							'label' => esc_html__( 'Male', 'addon-bus--ticket-booking-with-seat-pro' )
						],
						[
							'value' => 'female',
							'label' => esc_html__( 'Female', 'addon-bus--ticket-booking-with-seat-pro' )
						]
					]
				];

				return $form;
			}
		}
		new WBTM_Attendee_form();
	}