function placeholderLoader(target) {
	target.addClass('loading').append('<div class="placeholder_area_loader"><div class="mp_spinner"></div></div>');
}

function placeholderLoaderRemove(target) {
	target.removeClass('loading').find('.placeholder_area_loader').remove();
}

function get_wbtm_filter_args(parent) {
	let filter_args = {};
	
	// Helper function to get and sanitize value
	function getFieldValue(name) {
		let field = parent.find('[name="' + name + '"]');
		let value = field.val();
		return value ? value.trim() : '';
	}

	// Get values for standard fields
	let standard_fields = [
		'wbtm_bus_id',
		'wbtm_booking_date',
		'wbtm_start_time',
		'wbtm_boarding_time',
		'wbtm_boarding_point',
		'wbtm_dropping_point',
		'wbtm_order_id',
		'wbtm_user_name',
		'wbtm_user_email',
		'wbtm_user_phone'
	];

	standard_fields.forEach(field => {
		let value = getFieldValue(field);
		if (value) {
			filter_args[field] = value;
		}
	});

	// Get values for default attendee fields
	let default_fields = [
		'wbtm_full_name',
		'wbtm_reg_email',
		'wbtm_reg_phone',
		'wbtm_reg_address'
	];

	default_fields.forEach(field => {
		let value = parent.find('[name="' + field + '"]').val();
		if (value && value.trim()) {
			filter_args[field] = value.trim();
		}
	});

	// Get values for custom attendee fields
	parent.find('#wbtm_custom_attendee_filters input').each(function() {
		let field = jQuery(this);
		let value = field.val().trim();
		let fieldId = field.data('field-id');
		if (value && fieldId) {
			filter_args['wbtm_custom_' + fieldId] = value;
		}
	});

	// Always include the sort_by_seat checkbox state in filter_args
	let sortCheckbox = parent.find('#wbtm_sort_by_seat');
	let sortChecked = sortCheckbox.is(':checked');
	filter_args['sort_by_seat'] = sortChecked ? '1' : '0';
	// Include the show_coupon_price checkbox state
	let couponCheckbox = parent.find('#wbtm_show_coupon_price');
	let couponChecked = couponCheckbox.is(':checked');
	filter_args['show_coupon_price'] = couponChecked ? '1' : '0';
	return filter_args;
}

// Function to update filter status indicator
function updateFilterStatus(parent, filter_args) {
	let statusIndicator = parent.find('#wbtm_filter_status');
	let activeFiltersText = parent.find('#active_filters_text');
	let hasFilters = Object.keys(filter_args).length > 0;
	
	if (hasFilters) {
		let activeFilters = [];
		
		// Map field names to readable labels
		let fieldLabels = {
			'wbtm_bus_id': 'Bus',
			'wbtm_booking_date': 'Order Date',
			'wbtm_start_time': 'Journey Date',
			'wbtm_boarding_time': 'Boarding Date',
			'wbtm_boarding_point': 'Boarding Point',
			'wbtm_dropping_point': 'Dropping Point',
			'wbtm_order_id': 'Order ID',
			'wbtm_user_name': 'Billing Name',
			'wbtm_user_email': 'Billing Email',
			'wbtm_user_phone': 'Billing Phone',
			'wbtm_full_name': 'Passenger Name',
			'wbtm_reg_email': 'Passenger Email',
			'wbtm_reg_phone': 'Passenger Phone',
			'wbtm_reg_address': 'Passenger Address'
		};
		
		Object.keys(filter_args).forEach(key => {
			let label = fieldLabels[key] || key.replace('wbtm_', '').replace(/_/g, ' ');
			if (key.startsWith('wbtm_custom_')) {
				label = 'Custom Field';
			}
			activeFilters.push(label + ': ' + filter_args[key]);
		});
		
		activeFiltersText.html('<strong>' + activeFilters.join(', ') + '</strong>');
		statusIndicator.addClass('active').show();
	} else {
		statusIndicator.removeClass('active').hide();
	}
}

//=======Passenger  filter=============//
(function ($) {
	"use strict";
	
	// Store original order of rows for restoration
	let originalRowOrder = [];
	
	function get_wbtm_passenger_filter_result(parent) {
		let post_per_page = parseInt(parent.find("[name='post_per_page']").val()) || 20;
		let page = parseInt(parent.find('.active_pagination').attr('data-pagination')) || 1;
		let target = parent.find('#wbtm_passenger_list_result');
		
		// Get filter arguments
		let filter_args = get_wbtm_filter_args(parent);
		
		// Add sorting preference to filter args
		let sortBySeat = parent.find('#wbtm_sort_by_seat').is(':checked');
		filter_args['sort_by_seat'] = sortBySeat ? '1' : '0';
		
		// Update filter status indicator
		updateFilterStatus(parent, filter_args);
		
		$.ajax({
			type: 'POST',
			url: wbtm_ajax_url,
			data: {
				action: "get_wbtm_passenger_filter_result",
				filter_args: filter_args,
				post_per_page: post_per_page,
				page: page
			},
			beforeSend: function () {
				placeholderLoader(target);
			},
			success: function (response) {
				target.html(response).slideDown('fast').promise().done(function () {
					let total_item = target.find("[name='mp_total_item']").val();
					$.when(wbtm_pagination_page_management(target, page - 1, total_item)).then(function () {
						placeholderLoaderRemove(target);
						
						// Ensure pagination is visible after AJAX response
						ensurePaginationVisibility(target);
						ensurePaginationCentered(target); // Ensure pagination stays centered
						
						// Store original order of rows (server-sorted data)
						storeOriginalRowOrder(parent);
						
						// Don't re-sort here - let the server handle it
						// The server already sorts the data based on the sort_by_seat parameter
					});
				});
			},
			error: function(xhr, status, error) {
				console.error('AJAX error:', {xhr, status, error});
				placeholderLoaderRemove(target);
			}
		});
	}

	// Function to store original row order
	function storeOriginalRowOrder(parent) {
		let table = parent.find('.passenger-list-table tbody');
		originalRowOrder = table.find('tr.passenger-list').get();
	}

	// Attach change event handlers, but exclude bulk and row checkboxes
	$(document).on('change', '.wbtm_passenger_filter_area select, .wbtm_passenger_filter_area input:not(.wbtm-passenger-checkbox):not(#wbtm-select-all):not(#wbtm_sort_by_seat)', function() {
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		get_wbtm_passenger_filter_result(parent);
	});

	// Pagination input handler
	$(document).on('change', '.pagination_input', function() {
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		get_wbtm_passenger_filter_result(parent);
	});

	// Seat sorting checkbox handler
	$(document).on('change', '#wbtm_sort_by_seat', function() {
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		let checkboxContainer = $(this).closest('th');
		
		// Add visual feedback
		if ($(this).is(':checked')) {
			checkboxContainer.addClass('sorting-active');
		} else {
			checkboxContainer.removeClass('sorting-active');
		}
		
		// Always trigger a full filter reload so the download button is updated
		get_wbtm_passenger_filter_result(parent);
	});

	// Add change event for show_coupon_price checkbox
	$(document).on('change', '#wbtm_show_coupon_price', function() {
    let parent = $(this).closest('.wbtm_passenger_filter_area');
    get_wbtm_passenger_filter_result(parent);
});

	// Function to sort passenger list by seat number
	function sortPassengerList(parent) {
		let sortBySeat = parent.find('#wbtm_sort_by_seat').is(':checked');
		let table = parent.find('.passenger-list-table tbody');
		
		if (sortBySeat) {
			// Sort by seat number
			let rows = table.find('tr.passenger-list').get();
			
			rows.sort(function(a, b) {
				// Find the seat column - look for the column that contains seat-like data
				let seatA = '';
				let seatB = '';
				
				// First try to get seat from data attribute
				seatA = $(a).find('td[data-seat]').attr('data-seat') || '';
				seatB = $(b).find('td[data-seat]').attr('data-seat') || '';
				
				// If not found in data attribute, try to find by scanning cells
				if (!seatA || !seatB) {
					// Get all cells in the row
					let cellsA = $(a).find('td');
					let cellsB = $(b).find('td');
					
					// Look for seat numbers in the cells
					if (!seatA) {
						cellsA.each(function(index) {
							let cellText = $(this).text().trim();
							// Check if this looks like a seat number (contains letters and numbers)
							if (cellText.match(/^[A-Za-z]+\d+$/) || cellText.match(/^\d+[A-Za-z]+$/) || cellText.match(/^\d+$/)) {
								seatA = cellText;
								return false; // break the loop
							}
						});
					}
					
					if (!seatB) {
						cellsB.each(function(index) {
							let cellText = $(this).text().trim();
							// Check if this looks like a seat number (contains letters and numbers)
							if (cellText.match(/^[A-Za-z]+\d+$/) || cellText.match(/^\d+[A-Za-z]+$/) || cellText.match(/^\d+$/)) {
								seatB = cellText;
								return false; // break the loop
							}
						});
					}
				}
				
				// If no seat numbers found, return 0 (no change)
				if (!seatA && !seatB) {
					return 0;
				}
				if (!seatA) {
					return 1; // seats without numbers go to end
				}
				if (!seatB) {
					return -1;
				}
				
				// Extract numeric part from seat numbers (e.g., "A1" -> 1, "B12" -> 12)
				let numA = parseInt(seatA.replace(/\D/g, '')) || 0;
				let numB = parseInt(seatB.replace(/\D/g, '')) || 0;
				
				// Extract letter part from seat numbers (e.g., "A1" -> "A", "B12" -> "B")
				let letterA = seatA.replace(/\d/g, '').toUpperCase();
				let letterB = seatB.replace(/\d/g, '').toUpperCase();
				
				// First sort by letter (row), then by number (column)
				if (letterA !== letterB) {
					let result = letterA.localeCompare(letterB);
					return result;
				}
				let result = numA - numB;
				return result;
			});
			
			// Re-insert sorted rows
			$.each(rows, function(index, row) {
				table.append(row);
			});
		} else {
			// Restore original order
			if (originalRowOrder.length > 0) {
				// Clear current rows
				table.find('tr.passenger-list').remove();
				
				// Re-insert original rows
				$.each(originalRowOrder, function(index, row) {
					table.append(row);
				});
			} else {
				// Fallback: sort by SL number if original order not available
				let rows = table.find('tr.passenger-list').get();
				rows.sort(function(a, b) {
					let slA = parseInt($(a).find('td:eq(1)').text()) || 0;
					let slB = parseInt($(b).find('td:eq(1)').text()) || 0;
					return slA - slB;
				});
				
				// Re-insert sorted rows
				$.each(rows, function(index, row) {
					table.append(row);
				});
			}
		}
		
		// Update SL numbers
		updateSerialNumbers(parent);
	}

	// Function to update serial numbers after sorting
	function updateSerialNumbers(parent) {
		let table = parent.find('.passenger-list-table tbody');
		let rows = table.find('tr.passenger-list');
		
		rows.each(function(index) {
			let slCell = $(this).find('td:eq(1)'); // SL column
			if (slCell.length) {
				slCell.text(index + 1);
			}
		});
	}

	// Filter button click handler
	$(document).on('click', '#get_wbtm_passenger_filter_result', function () {
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		get_wbtm_passenger_filter_result(parent);
	});

	// Reset button handler
	$(document).on('click', '#wbtm_filter_reset', function () {
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		// Hide filter status indicator
		parent.find('#wbtm_filter_status').removeClass('active').hide();
		// Uncheck sort by seat checkbox
		parent.find('#wbtm_sort_by_seat').prop('checked', false).trigger('change');
		window.location.reload();
	});

	// Load custom attendee fields when bus is selected
	$(document).on('change', '[name="wbtm_bus_id"]', function() {
		let busId = $(this).val();
		let customFieldsContainer = $('#wbtm_custom_attendee_filters');

		if (busId) {
			$.ajax({
				type: 'POST',
				url: wbtm_ajax_url,
				data: {
					action: 'wbtm_load_custom_attendee_fields',
					bus_id: busId
				},
				success: function(response) {
					if (response.success) {
						customFieldsContainer.html(response.data).slideDown();
					} else {
						customFieldsContainer.hide().empty();
					}
				},
				error: function() {
					customFieldsContainer.hide().empty();
				}
			});
		} else {
			// If no bus selected, load all custom attendee fields globally
			$.ajax({
				type: 'POST',
				url: wbtm_ajax_url,
				data: {
					action: 'wbtm_load_custom_attendee_fields'
				},
				success: function(response) {
					if (response.success) {
						customFieldsContainer.html(response.data).slideDown();
					} else {
						customFieldsContainer.hide().empty();
					}
				},
				error: function() {
					customFieldsContainer.hide().empty();
				}
			});
		}
	});

	// On page load, load all custom attendee fields globally
	$(document).ready(function() {
		let customFieldsContainer = $('#wbtm_custom_attendee_filters');
		$.ajax({
			type: 'POST',
			url: wbtm_ajax_url,
			data: {
				action: 'wbtm_load_custom_attendee_fields'
			},
			success: function(response) {
				if (response.success) {
					customFieldsContainer.html(response.data).slideDown();
				} else {
					customFieldsContainer.hide().empty();
				}
			},
			error: function() {
				customFieldsContainer.hide().empty();
			}
		});
		
		// Store original row order on page load
		let parent = $('.wbtm_passenger_filter_area');
		setTimeout(function() {
			storeOriginalRowOrder(parent);
		}, 500);
	});

	$(document).on('click', '#wbtm_delete_attendee', function (e) {
		e.preventDefault();
		if (confirm('Are You Sure , Remove this Passenger ? \n\n 1. Ok : To Remove . \n 2. Cancel : To Cancel .')) {
			let attendee_id = $(this).data('attendee-id');
			let parent = $(this).closest('.wbtm_passenger_filter_area');
			if (attendee_id) {
				$.ajax({
					type: 'POST', url: wbtm_ajax_url, data: {
						"action": "wbtm_delete_attendee", "attendee_id": attendee_id
					}, beforeSend: function () {
						placeholderLoader(parent);
					}, success: function () {
						placeholderLoaderRemove(parent);
						parent.find('#get_wbtm_passenger_filter_result').trigger('click');
					}
				});
			}
			return true;
		} else {
			return false;
		}
	});

	// Function to ensure pagination buttons are always visible
	function ensurePaginationVisibility(target) {
		target.find('.wbtm_pagination_area button').each(function() {
			let button = $(this);
			let currentStyle = button.attr('style') || '';
			
			// Remove any display:none from the style
			currentStyle = currentStyle.replace(/display\s*:\s*none\s*;?/gi, '');
			currentStyle = currentStyle.replace(/display\s*:\s*none\s*;?/gi, '');
			
			// Ensure display is set to inline-block
			if (!currentStyle.includes('display:')) {
				currentStyle += 'display: inline-block;';
			} else if (!currentStyle.includes('display: inline-block')) {
				currentStyle = currentStyle.replace(/display\s*:\s*[^;]+;?/gi, 'display: inline-block;');
			}
			
			button.attr('style', currentStyle);
		});
		
		// Also ensure the pagination area itself is visible
		let paginationArea = target.find('.wbtm_pagination_area');
		let areaStyle = paginationArea.attr('style') || '';
		areaStyle = areaStyle.replace(/display\s*:\s*none\s*;?/gi, '');
		if (!areaStyle.includes('display:')) {
			areaStyle += 'display: block;';
		}
		paginationArea.attr('style', areaStyle);
	}

	// Function to ensure pagination stays centered
	function ensurePaginationCentered(target) {
		let paginationArea = target.find('.wbtm_pagination_area');
		let buttonGroup = paginationArea.find('.buttonGroup');
		
		// Ensure pagination area is centered
		if (paginationArea.length > 0) {
			let areaStyle = paginationArea.attr('style') || '';
			if (!areaStyle.includes('text-align: center')) {
				areaStyle += 'text-align: center;';
			}
			if (!areaStyle.includes('width: 100%')) {
				areaStyle += 'width: 100%;';
			}
			if (!areaStyle.includes('display: block')) {
				areaStyle += 'display: block;';
			}
			paginationArea.attr('style', areaStyle);
		}
		
		// Ensure button group is centered
		if (buttonGroup.length > 0) {
			let groupStyle = buttonGroup.attr('style') || '';
			if (!groupStyle.includes('display: inline-flex')) {
				groupStyle += 'display: inline-flex !important;';
			}
			if (!groupStyle.includes('justify-content: center')) {
				groupStyle += 'justify-content: center;';
			}
			if (!groupStyle.includes('margin: 0 auto')) {
				groupStyle += 'margin: 0 auto;';
			}
			buttonGroup.attr('style', groupStyle);
		}
	}

	// Add the missing pagination management function
	function wbtm_pagination_page_management(target, active_page, total_item) {
		return new Promise(function(resolve) {
			// Ensure pagination buttons are visible
			ensurePaginationVisibility(target);
			ensurePaginationCentered(target); // Ensure pagination stays centered
			
			// Remove any existing pagination click handlers to prevent duplicates
			target.find('.wbtm_pagination_area [data-pagination]').off('click');
			
			// Add click handlers to pagination buttons
			target.find('.wbtm_pagination_area [data-pagination]').on('click', function(e) {
				e.preventDefault();
				let parent = $(this).closest('.wbtm_passenger_filter_area');
				
				// Remove active class from all pagination buttons
				parent.find('.wbtm_pagination_area [data-pagination]').removeClass('active_pagination');
				
				// Add active class to clicked button
				$(this).addClass('active_pagination');
				
				// Trigger filter with new page
				get_wbtm_passenger_filter_result(parent);
			});
			
			resolve();
		});
	}

	// Update the existing pagination click handler to use the new class
	$(document).on('click', '.wbtm_passenger_filter_area .wbtm_pagination_area [data-pagination]', function (e) {
		e.preventDefault();
		let parent = $(this).closest('.wbtm_passenger_filter_area');
		parent.find('.wbtm_pagination_area [data-pagination]').removeClass('active_pagination');
		$(this).addClass('active_pagination');
		get_wbtm_passenger_filter_result(parent);
	});

	// Select All and Individual Checkbox Logic
	$(document).on('change', '#wbtm-select-all', function() {
		var checked = $(this).is(':checked');
		$('.wbtm-passenger-checkbox').prop('checked', checked);
	});
	$(document).on('change', '.wbtm-passenger-checkbox', function() {
		var all = $('.wbtm-passenger-checkbox').length;
		var checked = $('.wbtm-passenger-checkbox:checked').length;
		$('#wbtm-select-all').prop('checked', all === checked);
	});

	// Bulk Check-In and Bulk Revoke
	$(document).on('click', '#wbtm-bulk-checkin, #wbtm-bulk-revoke', function() {
		var actionType = $(this).attr('id') === 'wbtm-bulk-checkin' ? 'checkin' : 'revoke';
		var ids = $('.wbtm-passenger-checkbox:checked').map(function() { return $(this).val(); }).get();
		if (ids.length === 0) {
			alert('Please select at least one passenger.');
			return;
		}
		var parent = $(this).closest('.wbtm_passenger_filter_area');
		var target = parent.find('#wbtm_passenger_list_result');
		$.ajax({
			type: 'POST',
			url: wbtm_ajax_url,
			data: {
				action: 'wbtm_bulk_update_ticket_status',
				attendee_ids: ids,
				action_type: actionType
			},
			beforeSend: function() {
				placeholderLoader(target);
			},
			success: function(response) {
				// Reload the passenger list
				parent.find('#get_wbtm_passenger_filter_result').trigger('click');
			},
			error: function() {
				placeholderLoaderRemove(target);
				alert('Bulk action failed.');
			}
		});
	});

	// QR Code Scan Modal HTML
	if ($('#wbtm-qr-modal').length === 0) {
		$('body').append(`
			<div id="wbtm-qr-modal" style="display:none;position:fixed;z-index:9999;left:0;top:0;width:100vw;height:100vh;background:rgba(0,0,0,0.7);align-items:center;justify-content:center;">
				<div style="background:#fff;padding: 50px;max-width:400px;margin: 9%;position:relative;margin-left: 37%;">
					<button id="wbtm-qr-close" style="position:absolute;top:5px;right:5px;font-size:20px;">&times;</button>
					<h3>Scan QR Code</h3>
					<div id="wbtm-qr-reader" style="width:300px;height:300px;"></div>
					<div id="wbtm-qr-status" style="margin-top:10px;color:#d00;"></div>
				</div>
			</div>
		`);
	}

	// Load html5-qrcode library if not loaded
	function loadHtml5QrcodeLib(callback) {
		if (window.Html5Qrcode) { callback(); return; }
		var script = document.createElement('script');
		script.src = 'https://unpkg.com/html5-qrcode@2.3.8/html5-qrcode.min.js';
		script.onload = callback;
		document.head.appendChild(script);
	}

	$(document).on('click', '#wbtm-scan-qr-btn', function() {
		loadHtml5QrcodeLib(function() {
			$('#wbtm-qr-modal').fadeIn(200);
			var qrReader = new Html5Qrcode("wbtm-qr-reader");
			$('#wbtm-qr-status').text('');
			qrReader.start(
				{ facingMode: "environment" },
				{ fps: 10, qrbox: 250 },
				function(decodedText, decodedResult) {
					// Try to extract attendee_id from QR (assume it's a URL param or just the value)
					let attendee_id = null;
					try {
						// If it's a URL with ?wbtm_pin=123, extract 123
						let url = new URL(decodedText);
						attendee_id = url.searchParams.get('wbtm_pin');
					} catch (e) {
						// Not a URL, maybe just the ID
						attendee_id = decodedText;
					}
					if (attendee_id) {
						$('#wbtm-qr-status').text('Processing...');
						qrReader.stop().then(() => {
							// Send AJAX to check in
							$.post(wbtm_ajax_url, {
								action: 'wbtm_qr_update_ticket_status',
								attendee_id: attendee_id
							}, function(response) {
								$('#wbtm-qr-status').css('color','#080').text('Check-in successful!');
								setTimeout(function() {
									$('#wbtm-qr-modal').fadeOut(200);
									// Reload passenger list
									$('.wbtm_passenger_filter_area #get_wbtm_passenger_filter_result').trigger('click');
								}, 1200);
							}).fail(function() {
								$('#wbtm-qr-status').css('color','#d00').text('Check-in failed.');
							});
						});
					} else {
						$('#wbtm-qr-status').text('Invalid QR code.');
					}
				},
				function(errorMessage) {
					// ignore scan errors
				}
			);
			// Close modal handler
			$('#wbtm-qr-close').off('click').on('click', function() {
				qrReader.stop().then(() => {
					$('#wbtm-qr-modal').fadeOut(200);
				});
			});
		});
	});

	// Initialize pagination on page load
	$(document).ready(function() {
		// Ensure pagination is visible and working on initial page load
		$('.wbtm_passenger_filter_area').each(function() {
			let parent = $(this);
			let target = parent.find('#wbtm_passenger_list_result');
			
			if (target.length > 0) {
				// Ensure pagination is visible
				let paginationArea = target.find('.wbtm_pagination_area');
				if (paginationArea.length > 0) {
					paginationArea.show();
					paginationArea.css('display', 'block');
					paginationArea.css('text-align', 'center');
					
					// Ensure all pagination buttons are visible
					paginationArea.find('button').each(function() {
						$(this).show();
						$(this).css('display', 'inline-block');
					});
					
					// Ensure button group is properly displayed
					let buttonGroup = paginationArea.find('.buttonGroup');
					if (buttonGroup.length > 0) {
						buttonGroup.show();
						buttonGroup.css('display', 'inline-flex');
						buttonGroup.css('justify-content', 'center');
						buttonGroup.css('margin', '0 auto');
					}
				}
				
				// Ensure pagination stays centered
				let paginationAreaCentered = target.find('.wbtm_pagination_area');
				if (paginationAreaCentered.length > 0) {
					paginationAreaCentered.css('text-align', 'center');
					paginationAreaCentered.css('width', '100%');
					paginationAreaCentered.css('margin', '20px 0');
					
					let buttonGroupCentered = paginationAreaCentered.find('.buttonGroup');
					if (buttonGroupCentered.length > 0) {
						buttonGroupCentered.css('display', 'inline-flex');
						buttonGroupCentered.css('justify-content', 'center');
						buttonGroupCentered.css('margin', '0 auto');
						buttonGroupCentered.css('gap', '8px');
						buttonGroupCentered.css('align-items', 'center');
					}
				}
				
				// Set up initial pagination click handlers
				target.find('.wbtm_pagination_area [data-pagination]').on('click', function(e) {
					e.preventDefault();
					
					// Remove active class from all pagination buttons
					parent.find('.wbtm_pagination_area [data-pagination]').removeClass('active_pagination');
					
					// Add active class to clicked button
					$(this).addClass('active_pagination');
					
					// Trigger filter with new page
					get_wbtm_passenger_filter_result(parent);
				});
			}
		});
	});

})(jQuery);

//=======Report  filter=============//
(function ($) {
	"use strict";
	function get_wbtm_report_filter_result(parent) {
		let target = parent.find('#wbtm_sales_report_result');
		$.ajax({
			type: 'POST', url: wbtm_ajax_url, data: {
				"action": "get_wbtm_report_filter_result",
				"filter_args": get_wbtm_filter_args(parent),
			}, beforeSend: function () {
				placeholderLoader(target);
			}, success: function (data) {
				target.html(data).slideDown('fast').promise().done(function () {
					placeholderLoaderRemove(target);
				});
			}
		});
	}
	$(document).on('change', '' +
		'.wbtm_sales_report_area [name="wbtm_bus_id"],' +
		'.wbtm_sales_report_area [name="wbtm_booking_date"],' +
		'.wbtm_sales_report_area [name="wbtm_start_time"],' +
		'.wbtm_sales_report_area [name="wbtm_boarding_time"],' +
		'.wbtm_sales_report_area [name="wbtm_boarding_point"],' +
		'.wbtm_sales_report_area [name="wbtm_dropping_point"],' +
		'.wbtm_sales_report_area [name="wbtm_order_id"],' +
		'.wbtm_sales_report_area [name="wbtm_user_name"],' +
		'.wbtm_sales_report_area [name="wbtm_user_email"],' +
		'.wbtm_sales_report_area [name="wbtm_user_phone"]', function () {
		let parent = $(this).closest('.wbtm_sales_report_area');
		get_wbtm_report_filter_result(parent);
	});
	$(document).on('click', '#get_wbtm_sales_report_filter_result', function () {
		let parent = $(this).closest('.wbtm_sales_report_area');
		get_wbtm_report_filter_result(parent)
	});
}(jQuery));

(function ($) {
	"use strict";
	$(document).on('change', 'div.wbtm_custom_form_setting_area [name="wbtm_custom_type[]"]', function () {
		let parent = $(this).closest('tr');
		let target = parent.find('[name="wbtm_custom_value[]"]').closest('label');
		let target_date = parent.find('[name="wbtm_default_date[]"]').closest('label');
		let target_d_value = parent.find('[name="wbtm_default_value[]"]').closest('label');
		let val = $(this).val();
		if (val === 'select' || val === 'checkbox' || val === 'radio') {
			target.slideDown(250);
			target_date.slideUp(250);
			target_d_value.slideDown(250);
		} else if(val === 'date'){
			target.slideUp(250);
			target_date.slideDown(250);
			target_d_value.slideUp(250);
		}else {
			target.slideUp(250);
			target_date.slideUp(250);
			target_d_value.slideDown(250);
		}
	});
}(jQuery));

//=======Licence=============//
(function ($) {
	"use strict";
	$(document).on('click', '#wbtm_pro_license_key_inactive', function () {
		let parent= $(this).closest('.mp_basic_license_area');
		let key=parent.find('#wbtm_pro_license_key').val();
		if(key ) {
			if (confirm('Are you sure remove Licence? \n\n 1. Ok : To remove Licence . \n 2. Cancel : To Cancel .')) {
				$.ajax({
					type: 'POST', url: wbtm_ajax_url, data: {
						"action": "wbtm_pro_license_key_inactive"
					}, beforeSend: function () {
						wbtm_loader(parent);
					}, success: function (data) {
						parent.html(data);
					}
				});
			}
		}
	});
	$(document).on('click', '#wbtm_pro_license_key_active', function () {
		let parent= $(this).closest('.mp_basic_license_area');
		let key=parent.find('#wbtm_pro_license_key').val();
		if(key ) {
			$.ajax({
				type: 'POST', url: wbtm_ajax_url, data: {
					"action": "wbtm_pro_license_key_active",
					"key": key,
				}, beforeSend: function () {
					wbtm_loader(parent);
				}, success: function (data) {
					parent.html(data);
				}
			});
		}else{
			wbtm_alert($(this));
		}
	});
}(jQuery));

// Add download handler for CSV and PDF buttons
jQuery(document).on('click', '.buttonGroup button[data-href]', function(e) {
    e.preventDefault();
    var url = jQuery(this).attr('data-href');
    if (!url) return;
    // Show loading indicator
    var loadingMsg = jQuery('<div id="wbtm-download-loading" style="position:fixed;top:0;left:0;width:100vw;height:100vh;z-index:99999;background:rgba(255,255,255,0.7);display:flex;align-items:center;justify-content:center;"><div style="background:#fff;padding:30px 50px;border-radius:8px;box-shadow:0 2px 8px #ccc;font-size:18px;font-weight:600;color:#2271b1;">Preparing download...</div></div>');
    jQuery('body').append(loadingMsg);
    // Trigger download
    window.location = url;
    // Remove loading after 3 seconds (cannot detect download completion reliably)
    setTimeout(function() {
        jQuery('#wbtm-download-loading').fadeOut(300, function() { jQuery(this).remove(); });
    }, 3000);
});

jQuery(document).on('click', '#wbtm_download_pdf_dynamic', function(e) {
    e.preventDefault();
    var parent = jQuery(this).closest('.wbtm_passenger_filter_area');
    var filter_args = get_wbtm_filter_args(parent);
    filter_args['action'] = 'wbtm_generate_pdf';
    // Add the nonce
    filter_args['_wpnonce'] = window.wbtm_pdf_nonce || '';
    // Debug log (for development only)
    if (typeof console !== 'undefined') {
        console.log('WBTM PDF DEBUG: filter_args', filter_args);
    }
    var url = wbtm_ajax_url + '?' + jQuery.param(filter_args);
    if (typeof console !== 'undefined') {
        console.log('WBTM PDF DEBUG: url', url);
    }
    // Show loading indicator
    var loadingMsg = jQuery('<div id="wbtm-download-loading" style="position:fixed;top:0;left:0;width:100vw;height:100vh;z-index:99999;background:rgba(255,255,255,0.7);display:flex;align-items:center;justify-content:center;"><div style="background:#fff;padding:30px 50px;border-radius:8px;box-shadow:0 2px 8px #ccc;font-size:18px;font-weight:600;color:#2271b1;">Preparing download...</div></div>');
    jQuery('body').append(loadingMsg);
    // Trigger download
    window.location = url;
    // Remove loading after 3 seconds
    setTimeout(function() {
        jQuery('#wbtm-download-loading').fadeOut(300, function() { jQuery(this).remove(); });
    }, 3000);
});


