<?php
header('Content-Type: text/plain; charset=utf-8');

$payload = $_GET['request'] ?? '';
if ($payload === '') { http_response_code(400); exit('Empty payload'); }

$keyPath = __DIR__ . '/private-key.pem';
if (!file_exists($keyPath)) { http_response_code(500); exit('Private key not found'); }

$privKey = openssl_pkey_get_private('file://' . $keyPath);
if ($privKey === false) { http_response_code(500); exit('Invalid key'); }

if (!openssl_sign($payload, $signature, $privKey, OPENSSL_ALGO_SHA512)) {
    http_response_code(500); exit('Sign error');
}
echo base64_encode($signature);
