<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Autoimpressão QZ Tray</title>
 
  <script src="js/qz-tray.js"></script>
</head>
<body>
  <h2 id="status">🖨️ Conectando e imprimindo na EPSON TM-TX...</h2>

  <script>
    // 1. Carregar o certificado confiável
    qz.security.setCertificatePromise(function(resolve, reject) {
      fetch("digital-certificate.txt", {
        cache: 'no-store',
        headers: { 'Content-Type': 'text/plain' }
      }).then(res => res.ok ? resolve(res.text()) : reject("❌ Erro no certificado"));
    });

    // 2. Assinar cada mensagem com sua chave privada
    qz.security.setSignatureAlgorithm("SHA512");
    qz.security.setSignaturePromise(function(toSign) {
      return function(resolve, reject) {
        fetch("sign-message.php?request=" + encodeURIComponent(toSign), {
          cache: 'no-store',
          headers: { 'Content-Type': 'text/plain' }
        }).then(res => res.ok ? resolve(res.text()) : reject("❌ Erro na assinatura"));
      };
    });

    // 3. Conexão e impressão automática na EPSON TM-TX
    window.addEventListener("load", () => {
      qz.websocket.connect().then(() => {
        document.getElementById("status").innerText = "✅ Conectado!";
        const nomeImpressora = "EPSON TM-TX"; // <- aqui o nome exato
        const config = qz.configs.create(nomeImpressora);
        const dados = [
          "***************\n",
          "   CUPOM TESTE\n",
          "   via QZ Tray\n",
          "   Impressora:\n",
          "   EPSON TM-TX\n",
          "***************\n\n"
        ];
        return qz.print(config, dados);
      }).then(() => {
        document.getElementById("status").innerText = "🖨️ Impressão enviada para EPSON TM-TX!";
      }).catch(err => {
        document.getElementById("status").innerText = "❌ Erro: " + err;
      });
    });
  </script>
</body>
</html>
